/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFormationChangeSetRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<CreateCloudFormationChangeSetRequest.Builder, CreateCloudFormationChangeSetRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateCloudFormationChangeSetRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(CreateCloudFormationChangeSetRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(CreateCloudFormationChangeSetRequest::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeSetName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateCloudFormationChangeSetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCloudFormationChangeSetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationArns")
            .getter(getter(CreateCloudFormationChangeSetRequest::notificationArns))
            .setter(setter(Builder::notificationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterValue>> PARAMETER_OVERRIDES_FIELD = SdkField
            .<List<ParameterValue>> builder(MarshallingType.LIST)
            .memberName("ParameterOverrides")
            .getter(getter(CreateCloudFormationChangeSetRequest::parameterOverrides))
            .setter(setter(Builder::parameterOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(CreateCloudFormationChangeSetRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<RollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("RollbackConfiguration")
            .getter(getter(CreateCloudFormationChangeSetRequest::rollbackConfiguration))
            .setter(setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackConfiguration").build())
            .build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(CreateCloudFormationChangeSetRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(CreateCloudFormationChangeSetRequest::stackName))
            .setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCloudFormationChangeSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(CreateCloudFormationChangeSetRequest::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAPABILITIES_FIELD, CHANGE_SET_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NOTIFICATION_ARNS_FIELD,
            PARAMETER_OVERRIDES_FIELD, RESOURCE_TYPES_FIELD, ROLLBACK_CONFIGURATION_FIELD, SEMANTIC_VERSION_FIELD,
            STACK_NAME_FIELD, TAGS_FIELD, TEMPLATE_ID_FIELD));

    private final String applicationId;

    private final List<String> capabilities;

    private final String changeSetName;

    private final String clientToken;

    private final String description;

    private final List<String> notificationArns;

    private final List<ParameterValue> parameterOverrides;

    private final List<String> resourceTypes;

    private final RollbackConfiguration rollbackConfiguration;

    private final String semanticVersion;

    private final String stackName;

    private final List<Tag> tags;

    private final String templateId;

    private CreateCloudFormationChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.capabilities = builder.capabilities;
        this.changeSetName = builder.changeSetName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.notificationArns = builder.notificationArns;
        this.parameterOverrides = builder.parameterOverrides;
        this.resourceTypes = builder.resourceTypes;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.semanticVersion = builder.semanticVersion;
        this.stackName = builder.stackName;
        this.tags = builder.tags;
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns true if the Capabilities property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values that you must specify before you can deploy certain applications. Some applications might
     * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and
     * Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by
     * specifying this parameter.
     * </p>
     * <p>
     * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     * CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     * >AWS::IAM::Group</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     * >AWS::IAM::InstanceProfile</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM::Policy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     * CAPABILITY_NAMED_IAM.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     * >AWS::Lambda::Permission</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM:Policy</a>, <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     * >AWS::S3::BucketPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     * >AWS::SQS::QueuePolicy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     * >AWS::SNS:TopicPolicy</a>.
     * </p>
     * <p>
     * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * If your application template contains any of the above resources, we recommend that you review all permissions
     * associated with the application before deploying. If you don't specify this parameter for an application that
     * requires capabilities, the call will fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of values that you must specify before you can deploy certain applications. Some applications
     *         might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     *         Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their
     *         capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     *         CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     *         >AWS::IAM::Group</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     *         >AWS::IAM::InstanceProfile</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM::Policy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     *         >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     *         CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     *         CAPABILITY_NAMED_IAM.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     *         >AWS::Lambda::Permission</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM:Policy</a>, <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     *         >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     *         >AWS::S3::BucketPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     *         >AWS::SQS::QueuePolicy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     *         >AWS::SNS:TopicPolicy</a>.
     *         </p>
     *         <p>
     *         Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         If your application template contains any of the above resources, we recommend that you review all
     *         permissions associated with the application before deploying. If you don't specify this parameter for an
     *         application that requires capabilities, the call will fail.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the NotificationArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNotificationArns() {
        return notificationArns != null && !(notificationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final List<String> notificationArns() {
        return notificationArns;
    }

    /**
     * Returns true if the ParameterOverrides property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasParameterOverrides() {
        return parameterOverrides != null && !(parameterOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter values for the parameters of the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterOverrides()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of parameter values for the parameters of the application.
     */
    public final List<ParameterValue> parameterOverrides() {
        return parameterOverrides;
    }

    /**
     * Returns true if the ResourceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i>
     * API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *         >CreateChangeSet</a> </i> API.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The UUID returned by CreateCloudFormationTemplate.
     * </p>
     * <p>
     * Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
     * </p>
     * 
     * @return The UUID returned by CreateCloudFormationTemplate.</p>
     *         <p>
     *         Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationArns() ? notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterOverrides() ? parameterOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetRequest)) {
            return false;
        }
        CreateCloudFormationChangeSetRequest other = (CreateCloudFormationChangeSetRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilities(), other.capabilities()) && Objects.equals(changeSetName(), other.changeSetName())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasNotificationArns() == other.hasNotificationArns()
                && Objects.equals(notificationArns(), other.notificationArns())
                && hasParameterOverrides() == other.hasParameterOverrides()
                && Objects.equals(parameterOverrides(), other.parameterOverrides())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && Objects.equals(stackName(), other.stackName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudFormationChangeSetRequest").add("ApplicationId", applicationId())
                .add("Capabilities", hasCapabilities() ? capabilities() : null).add("ChangeSetName", changeSetName())
                .add("ClientToken", clientToken()).add("Description", description())
                .add("NotificationArns", hasNotificationArns() ? notificationArns() : null)
                .add("ParameterOverrides", hasParameterOverrides() ? parameterOverrides() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null)
                .add("RollbackConfiguration", rollbackConfiguration()).add("SemanticVersion", semanticVersion())
                .add("StackName", stackName()).add("Tags", hasTags() ? tags() : null).add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NotificationArns":
            return Optional.ofNullable(clazz.cast(notificationArns()));
        case "ParameterOverrides":
            return Optional.ofNullable(clazz.cast(parameterOverrides()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "RollbackConfiguration":
            return Optional.ofNullable(clazz.cast(rollbackConfiguration()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationChangeSetRequest, T> g) {
        return obj -> g.apply((CreateCloudFormationChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationId
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS:TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS:TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS:TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS:TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param changeSetName
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param clientToken
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param description
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param notificationArns
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(Collection<String> notificationArns);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param notificationArns
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(String... notificationArns);

        /**
         * <p>
         * A list of parameter values for the parameters of the application.
         * </p>
         * 
         * @param parameterOverrides
         *        A list of parameter values for the parameters of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(Collection<ParameterValue> parameterOverrides);

        /**
         * <p>
         * A list of parameter values for the parameters of the application.
         * </p>
         * 
         * @param parameterOverrides
         *        A list of parameter values for the parameters of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(ParameterValue... parameterOverrides);

        /**
         * <p>
         * A list of parameter values for the parameters of the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterValue>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterOverrides(List<ParameterValue>)}.
         * 
         * @param parameterOverrides
         *        a consumer that will call methods on {@link List<ParameterValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterOverrides(List<ParameterValue>)
         */
        Builder parameterOverrides(Consumer<ParameterValue.Builder>... parameterOverrides);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param resourceTypes
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param resourceTypes
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param rollbackConfiguration
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * This is a convenience that creates an instance of the {@link RollbackConfiguration.Builder} avoiding the need
         * to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().applyMutation(rollbackConfiguration).build());
        }

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param stackName
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param tags
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * 
         * @param tags
         *        This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
         *        >CreateChangeSet</a> </i> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
         * </i> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The UUID returned by CreateCloudFormationTemplate.
         * </p>
         * <p>
         * Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
         * </p>
         * 
         * @param templateId
         *        The UUID returned by CreateCloudFormationTemplate.</p>
         *        <p>
         *        Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String changeSetName;

        private String clientToken;

        private String description;

        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterValue> parameterOverrides = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private RollbackConfiguration rollbackConfiguration;

        private String semanticVersion;

        private String stackName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetRequest model) {
            super(model);
            applicationId(model.applicationId);
            capabilities(model.capabilities);
            changeSetName(model.changeSetName);
            clientToken(model.clientToken);
            description(model.description);
            notificationArns(model.notificationArns);
            parameterOverrides(model.parameterOverrides);
            resourceTypes(model.resourceTypes);
            rollbackConfiguration(model.rollbackConfiguration);
            semanticVersion(model.semanticVersion);
            stackName(model.stackName);
            tags(model.tags);
            templateId(model.templateId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = ___listOf__stringCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ___listOf__stringCopier.copy(capabilities);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getNotificationArns() {
            if (notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = ___listOf__stringCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String... notificationArns) {
            notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = ___listOf__stringCopier.copy(notificationArns);
        }

        public final List<ParameterValue.Builder> getParameterOverrides() {
            List<ParameterValue.Builder> result = ___listOfParameterValueCopier.copyToBuilder(this.parameterOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameterOverrides(Collection<ParameterValue> parameterOverrides) {
            this.parameterOverrides = ___listOfParameterValueCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(ParameterValue... parameterOverrides) {
            parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<ParameterValue.Builder>... parameterOverrides) {
            parameterOverrides(Stream.of(parameterOverrides).map(c -> ParameterValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<ParameterValue.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ___listOfParameterValueCopier.copyFromBuilder(parameterOverrides);
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ___listOf__stringCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ___listOf__stringCopier.copy(resourceTypes);
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = ___listOfTagCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = ___listOfTagCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = ___listOfTagCopier.copyFromBuilder(tags);
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFormationChangeSetRequest build() {
            return new CreateCloudFormationChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
