/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationPolicyResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<GetApplicationPolicyResponse.Builder, GetApplicationPolicyResponse> {
    private static final SdkField<List<ApplicationPolicyStatement>> STATEMENTS_FIELD = SdkField
            .<List<ApplicationPolicyStatement>> builder(MarshallingType.LIST)
            .memberName("Statements")
            .getter(getter(GetApplicationPolicyResponse::statements))
            .setter(setter(Builder::statements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationPolicyStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationPolicyStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));

    private final List<ApplicationPolicyStatement> statements;

    private GetApplicationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Statements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatements() {
        return statements != null && !(statements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of policy statements applied to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatements} method.
     * </p>
     * 
     * @return An array of policy statements applied to the application.
     */
    public final List<ApplicationPolicyStatement> statements() {
        return statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatements() ? statements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationPolicyResponse)) {
            return false;
        }
        GetApplicationPolicyResponse other = (GetApplicationPolicyResponse) obj;
        return hasStatements() == other.hasStatements() && Objects.equals(statements(), other.statements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationPolicyResponse").add("Statements", hasStatements() ? statements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statements":
            return Optional.ofNullable(clazz.cast(statements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationPolicyResponse, T> g) {
        return obj -> g.apply((GetApplicationPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationPolicyResponse> {
        /**
         * <p>
         * An array of policy statements applied to the application.
         * </p>
         * 
         * @param statements
         *        An array of policy statements applied to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<ApplicationPolicyStatement> statements);

        /**
         * <p>
         * An array of policy statements applied to the application.
         * </p>
         * 
         * @param statements
         *        An array of policy statements applied to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(ApplicationPolicyStatement... statements);

        /**
         * <p>
         * An array of policy statements applied to the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ApplicationPolicyStatement>.Builder}
         * avoiding the need to create one manually via {@link List<ApplicationPolicyStatement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationPolicyStatement>.Builder#build()} is called
         * immediately and its result is passed to {@link #statements(List<ApplicationPolicyStatement>)}.
         * 
         * @param statements
         *        a consumer that will call methods on {@link List<ApplicationPolicyStatement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(List<ApplicationPolicyStatement>)
         */
        Builder statements(Consumer<ApplicationPolicyStatement.Builder>... statements);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private List<ApplicationPolicyStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationPolicyResponse model) {
            super(model);
            statements(model.statements);
        }

        public final List<ApplicationPolicyStatement.Builder> getStatements() {
            List<ApplicationPolicyStatement.Builder> result = ___listOfApplicationPolicyStatementCopier
                    .copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<ApplicationPolicyStatement.BuilderImpl> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<ApplicationPolicyStatement> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(ApplicationPolicyStatement... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<ApplicationPolicyStatement.Builder>... statements) {
            statements(Stream.of(statements).map(c -> ApplicationPolicyStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetApplicationPolicyResponse build() {
            return new GetApplicationPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
