/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFormationTemplateResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<CreateCloudFormationTemplateResponse.Builder, CreateCloudFormationTemplateResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateCloudFormationTemplateResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(CreateCloudFormationTemplateResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationTime").getter(getter(CreateCloudFormationTemplateResponse::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(CreateCloudFormationTemplateResponse::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateCloudFormationTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(CreateCloudFormationTemplateResponse::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateUrl").getter(getter(CreateCloudFormationTemplateResponse::templateUrl))
            .setter(setter(Builder::templateUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, SEMANTIC_VERSION_FIELD, STATUS_FIELD, TEMPLATE_ID_FIELD,
            TEMPLATE_URL_FIELD));

    private final String applicationId;

    private final String creationTime;

    private final String expirationTime;

    private final String semanticVersion;

    private final String status;

    private final String templateId;

    private final String templateUrl;

    private CreateCloudFormationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.semanticVersion = builder.semanticVersion;
        this.status = builder.status;
        this.templateId = builder.templateId;
        this.templateUrl = builder.templateUrl;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The date and time this resource was created.
     * </p>
     * 
     * @return The date and time this resource was created.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time this template expires. Templates expire 1 hour after creation.
     * </p>
     * 
     * @return The date and time this template expires. Templates expire 1 hour after creation.
     */
    public final String expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * Status of the template creation workflow.
     * </p>
     * <p>
     * Possible values: PREPARING | ACTIVE | EXPIRED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the template creation workflow.</p>
     *         <p>
     *         Possible values: PREPARING | ACTIVE | EXPIRED
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status of the template creation workflow.
     * </p>
     * <p>
     * Possible values: PREPARING | ACTIVE | EXPIRED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the template creation workflow.</p>
     *         <p>
     *         Possible values: PREPARING | ACTIVE | EXPIRED
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The UUID returned by CreateCloudFormationTemplate.
     * </p>
     * <p>
     * Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
     * </p>
     * 
     * @return The UUID returned by CreateCloudFormationTemplate.</p>
     *         <p>
     *         Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * A link to the template that can be used to deploy the application using AWS CloudFormation.
     * </p>
     * 
     * @return A link to the template that can be used to deploy the application using AWS CloudFormation.
     */
    public final String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationTemplateResponse)) {
            return false;
        }
        CreateCloudFormationTemplateResponse other = (CreateCloudFormationTemplateResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(templateUrl(), other.templateUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudFormationTemplateResponse").add("ApplicationId", applicationId())
                .add("CreationTime", creationTime()).add("ExpirationTime", expirationTime())
                .add("SemanticVersion", semanticVersion()).add("Status", statusAsString()).add("TemplateId", templateId())
                .add("TemplateUrl", templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "TemplateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationTemplateResponse, T> g) {
        return obj -> g.apply((CreateCloudFormationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudFormationTemplateResponse> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The date and time this resource was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time this template expires. Templates expire 1 hour after creation.
         * </p>
         * 
         * @param expirationTime
         *        The date and time this template expires. Templates expire 1 hour after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(String expirationTime);

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * Status of the template creation workflow.
         * </p>
         * <p>
         * Possible values: PREPARING | ACTIVE | EXPIRED
         * </p>
         * 
         * @param status
         *        Status of the template creation workflow.</p>
         *        <p>
         *        Possible values: PREPARING | ACTIVE | EXPIRED
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the template creation workflow.
         * </p>
         * <p>
         * Possible values: PREPARING | ACTIVE | EXPIRED
         * </p>
         * 
         * @param status
         *        Status of the template creation workflow.</p>
         *        <p>
         *        Possible values: PREPARING | ACTIVE | EXPIRED
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The UUID returned by CreateCloudFormationTemplate.
         * </p>
         * <p>
         * Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
         * </p>
         * 
         * @param templateId
         *        The UUID returned by CreateCloudFormationTemplate.</p>
         *        <p>
         *        Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * A link to the template that can be used to deploy the application using AWS CloudFormation.
         * </p>
         * 
         * @param templateUrl
         *        A link to the template that can be used to deploy the application using AWS CloudFormation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String creationTime;

        private String expirationTime;

        private String semanticVersion;

        private String status;

        private String templateId;

        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationTemplateResponse model) {
            super(model);
            applicationId(model.applicationId);
            creationTime(model.creationTime);
            expirationTime(model.expirationTime);
            semanticVersion(model.semanticVersion);
            status(model.status);
            templateId(model.templateId);
            templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        @Override
        public CreateCloudFormationTemplateResponse build() {
            return new CreateCloudFormationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
