/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<GetApplicationRequest.Builder, GetApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(GetApplicationRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("semanticVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            SEMANTIC_VERSION_FIELD));

    private final String applicationId;

    private final String semanticVersion;

    private GetApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.semanticVersion = builder.semanticVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The semantic version of the application to get.
     * </p>
     * 
     * @return The semantic version of the application to get.
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRequest)) {
            return false;
        }
        GetApplicationRequest other = (GetApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(semanticVersion(), other.semanticVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationRequest").add("ApplicationId", applicationId())
                .add("SemanticVersion", semanticVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationRequest, T> g) {
        return obj -> g.apply((GetApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationId
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The semantic version of the application to get.
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String semanticVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            semanticVersion(model.semanticVersion);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        @Transient
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationRequest build() {
            return new GetApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
