/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This property corresponds to the <i>AWS CloudFormation <a
 * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
 * >RollbackConfiguration</a> </i> Data Type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RollbackConfiguration.Builder, RollbackConfiguration> {
    private static final SdkField<Integer> MONITORING_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringTimeInMinutes").getter(getter(RollbackConfiguration::monitoringTimeInMinutes))
            .setter(setter(Builder::monitoringTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringTimeInMinutes").build())
            .build();

    private static final SdkField<List<RollbackTrigger>> ROLLBACK_TRIGGERS_FIELD = SdkField
            .<List<RollbackTrigger>> builder(MarshallingType.LIST)
            .memberName("RollbackTriggers")
            .getter(getter(RollbackConfiguration::rollbackTriggers))
            .setter(setter(Builder::rollbackTriggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RollbackTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(RollbackTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_TIME_IN_MINUTES_FIELD, ROLLBACK_TRIGGERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer monitoringTimeInMinutes;

    private final List<RollbackTrigger> rollbackTriggers;

    private RollbackConfiguration(BuilderImpl builder) {
        this.monitoringTimeInMinutes = builder.monitoringTimeInMinutes;
        this.rollbackTriggers = builder.rollbackTriggers;
    }

    /**
     * <p>
     * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
     * >RollbackConfiguration</a> </i> Data Type.
     * </p>
     * 
     * @return This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
     *         >RollbackConfiguration</a> </i> Data Type.
     */
    public final Integer monitoringTimeInMinutes() {
        return monitoringTimeInMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the RollbackTriggers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRollbackTriggers() {
        return rollbackTriggers != null && !(rollbackTriggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
     * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
     * >RollbackConfiguration</a> </i> Data Type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRollbackTriggers} method.
     * </p>
     * 
     * @return This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
     *         href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
     *         >RollbackConfiguration</a> </i> Data Type.
     */
    public final List<RollbackTrigger> rollbackTriggers() {
        return rollbackTriggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasRollbackTriggers() ? rollbackTriggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackConfiguration)) {
            return false;
        }
        RollbackConfiguration other = (RollbackConfiguration) obj;
        return Objects.equals(monitoringTimeInMinutes(), other.monitoringTimeInMinutes())
                && hasRollbackTriggers() == other.hasRollbackTriggers()
                && Objects.equals(rollbackTriggers(), other.rollbackTriggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackConfiguration").add("MonitoringTimeInMinutes", monitoringTimeInMinutes())
                .add("RollbackTriggers", hasRollbackTriggers() ? rollbackTriggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringTimeInMinutes":
            return Optional.ofNullable(clazz.cast(monitoringTimeInMinutes()));
        case "RollbackTriggers":
            return Optional.ofNullable(clazz.cast(rollbackTriggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RollbackConfiguration, T> g) {
        return obj -> g.apply((RollbackConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RollbackConfiguration> {
        /**
         * <p>
         * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         * >RollbackConfiguration</a> </i> Data Type.
         * </p>
         * 
         * @param monitoringTimeInMinutes
         *        This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         *        >RollbackConfiguration</a> </i> Data Type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringTimeInMinutes(Integer monitoringTimeInMinutes);

        /**
         * <p>
         * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         * >RollbackConfiguration</a> </i> Data Type.
         * </p>
         * 
         * @param rollbackTriggers
         *        This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         *        >RollbackConfiguration</a> </i> Data Type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackTriggers(Collection<RollbackTrigger> rollbackTriggers);

        /**
         * <p>
         * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         * >RollbackConfiguration</a> </i> Data Type.
         * </p>
         * 
         * @param rollbackTriggers
         *        This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         *        href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         *        >RollbackConfiguration</a> </i> Data Type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackTriggers(RollbackTrigger... rollbackTriggers);

        /**
         * <p>
         * This property corresponds to the content of the same name for the <i>AWS CloudFormation <a
         * href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration"
         * >RollbackConfiguration</a> </i> Data Type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RollbackTrigger>.Builder} avoiding the need
         * to create one manually via {@link List<RollbackTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RollbackTrigger>.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackTriggers(List<RollbackTrigger>)}.
         * 
         * @param rollbackTriggers
         *        a consumer that will call methods on {@link List<RollbackTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackTriggers(List<RollbackTrigger>)
         */
        Builder rollbackTriggers(Consumer<RollbackTrigger.Builder>... rollbackTriggers);
    }

    static final class BuilderImpl implements Builder {
        private Integer monitoringTimeInMinutes;

        private List<RollbackTrigger> rollbackTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackConfiguration model) {
            monitoringTimeInMinutes(model.monitoringTimeInMinutes);
            rollbackTriggers(model.rollbackTriggers);
        }

        public final Integer getMonitoringTimeInMinutes() {
            return monitoringTimeInMinutes;
        }

        public final void setMonitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
        }

        @Override
        @Transient
        public final Builder monitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
            return this;
        }

        public final List<RollbackTrigger.Builder> getRollbackTriggers() {
            List<RollbackTrigger.Builder> result = ___listOfRollbackTriggerCopier.copyToBuilder(this.rollbackTriggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRollbackTriggers(Collection<RollbackTrigger.BuilderImpl> rollbackTriggers) {
            this.rollbackTriggers = ___listOfRollbackTriggerCopier.copyFromBuilder(rollbackTriggers);
        }

        @Override
        @Transient
        public final Builder rollbackTriggers(Collection<RollbackTrigger> rollbackTriggers) {
            this.rollbackTriggers = ___listOfRollbackTriggerCopier.copy(rollbackTriggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rollbackTriggers(RollbackTrigger... rollbackTriggers) {
            rollbackTriggers(Arrays.asList(rollbackTriggers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rollbackTriggers(Consumer<RollbackTrigger.Builder>... rollbackTriggers) {
            rollbackTriggers(Stream.of(rollbackTriggers).map(c -> RollbackTrigger.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RollbackConfiguration build() {
            return new RollbackConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
