/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An application version summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionSummary implements SdkPojo, Serializable, ToCopyableBuilder<VersionSummary.Builder, VersionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(VersionSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(VersionSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(VersionSummary::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCodeUrl").getter(getter(VersionSummary::sourceCodeUrl)).setter(setter(Builder::sourceCodeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATION_TIME_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String creationTime;

    private final String semanticVersion;

    private final String sourceCodeUrl;

    private VersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The date and time this resource was created.
     * </p>
     * 
     * @return The date and time this resource was created.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub
     * commit.
     * </p>
     * 
     * @return A link to a public repository for the source code of your application, for example the URL of a specific
     *         GitHub commit.
     */
    public final String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionSummary)) {
            return false;
        }
        VersionSummary other = (VersionSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionSummary").add("ApplicationId", applicationId()).add("CreationTime", creationTime())
                .add("SemanticVersion", semanticVersion()).add("SourceCodeUrl", sourceCodeUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "SourceCodeUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VersionSummary, T> g) {
        return obj -> g.apply((VersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionSummary> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The date and time this resource was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * A link to a public repository for the source code of your application, for example the URL of a specific
         * GitHub commit.
         * </p>
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application, for example the URL of a
         *        specific GitHub commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String creationTime;

        private String semanticVersion;

        private String sourceCodeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionSummary model) {
            applicationId(model.applicationId);
            creationTime(model.creationTime);
            semanticVersion(model.semanticVersion);
            sourceCodeUrl(model.sourceCodeUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        @Transient
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        @Override
        @Transient
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        @Override
        public VersionSummary build() {
            return new VersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
