/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfApplicationDependencySummaryCopier {
    static List<ApplicationDependencySummary> copy(
            Collection<? extends ApplicationDependencySummary> __listOfApplicationDependencySummaryParam) {
        List<ApplicationDependencySummary> list;
        if (__listOfApplicationDependencySummaryParam == null
                || __listOfApplicationDependencySummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ApplicationDependencySummary> modifiableList = new ArrayList<>();
            __listOfApplicationDependencySummaryParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ApplicationDependencySummary> copyFromBuilder(
            Collection<? extends ApplicationDependencySummary.Builder> __listOfApplicationDependencySummaryParam) {
        List<ApplicationDependencySummary> list;
        if (__listOfApplicationDependencySummaryParam == null
                || __listOfApplicationDependencySummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ApplicationDependencySummary> modifiableList = new ArrayList<>();
            __listOfApplicationDependencySummaryParam.forEach(entry -> {
                ApplicationDependencySummary member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ApplicationDependencySummary.Builder> copyToBuilder(
            Collection<? extends ApplicationDependencySummary> __listOfApplicationDependencySummaryParam) {
        List<ApplicationDependencySummary.Builder> list;
        if (__listOfApplicationDependencySummaryParam == null
                || __listOfApplicationDependencySummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ApplicationDependencySummary.Builder> modifiableList = new ArrayList<>();
            __listOfApplicationDependencySummaryParam.forEach(entry -> {
                ApplicationDependencySummary.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
