/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.BadRequestException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ConflictException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ForbiddenException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.InternalServerErrorException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.NotFoundException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.TooManyRequestsException;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable;

/**
 * Service client for accessing AWSServerlessApplicationRepository. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Serverless Application Repository makes it easy for developers and enterprises to quickly find and deploy
 * serverless applications in the AWS Cloud. For more information about serverless applications, see Serverless
 * Computing and Applications on the AWS website.
 * </p>
 * <p>
 * The AWS Serverless Application Repository is deeply integrated with the AWS Lambda console, so that developers of all
 * levels can get started with serverless computing without needing to learn anything new. You can use category keywords
 * to browse for applications such as web and mobile backends, data processing applications, or chatbots. You can also
 * search for applications by name, publisher, or event source. To use an application, you simply choose it, configure
 * any required fields, and deploy it with a few clicks.
 * </p>
 * <p>
 * You can also easily publish applications, sharing them publicly with the community at large, or privately within your
 * team or across your organization. To publish a serverless application (or app), you can use the AWS Management
 * Console, AWS Command Line Interface (AWS CLI), or AWS SDKs to upload the code. Along with the code, you upload a
 * simple manifest file, also known as the AWS Serverless Application Model (AWS SAM) template. For more information
 * about AWS SAM, see AWS Serverless Application Model (AWS SAM) on the AWS Labs GitHub repository.
 * </p>
 * <p>
 * The AWS Serverless Application Repository Developer Guide contains more information about the two developer
 * experiences available:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Consuming Applications – Browse for applications and view information about them, including source code and readme
 * files. Also install, configure, and deploy applications of your choosing.
 * </p>
 * <p>
 * Publishing Applications – Configure and upload applications to make them available to other developers, and publish
 * new versions of applications.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServerlessApplicationRepositoryClient extends AwsClient {
    String SERVICE_NAME = "serverlessrepo";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "serverlessrepo";

    /**
     * <p>
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws TooManyRequestsException, BadRequestException, InternalServerErrorException, ConflictException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws TooManyRequestsException, BadRequestException, InternalServerErrorException, ConflictException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an application version.
     * </p>
     *
     * @param createApplicationVersionRequest
     * @return Result of the CreateApplicationVersion operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationVersionResponse createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) throws TooManyRequestsException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createApplicationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest.Builder}
     *        to create a request.
     * @return Result of the CreateApplicationVersion operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationVersionResponse createApplicationVersion(
            Consumer<CreateApplicationVersionRequest.Builder> createApplicationVersionRequest) throws TooManyRequestsException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return createApplicationVersion(CreateApplicationVersionRequest.builder().applyMutation(createApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS CloudFormation change set for the given application.
     * </p>
     *
     * @param createCloudFormationChangeSetRequest
     * @return Result of the CreateCloudFormationChangeSet operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateCloudFormationChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationChangeSetResponse createCloudFormationChangeSet(
            CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest) throws TooManyRequestsException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS CloudFormation change set for the given application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationChangeSetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudFormationChangeSetRequest#builder()}
     * </p>
     *
     * @param createCloudFormationChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCloudFormationChangeSet operation returned by the service.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateCloudFormationChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationChangeSetResponse createCloudFormationChangeSet(
            Consumer<CreateCloudFormationChangeSetRequest.Builder> createCloudFormationChangeSetRequest)
            throws TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        return createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest.builder()
                .applyMutation(createCloudFormationChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates an AWS CloudFormation template.
     * </p>
     *
     * @param createCloudFormationTemplateRequest
     * @return Result of the CreateCloudFormationTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationTemplateResponse createCloudFormationTemplate(
            CreateCloudFormationTemplateRequest createCloudFormationTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS CloudFormation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudFormationTemplateRequest#builder()}
     * </p>
     *
     * @param createCloudFormationTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCloudFormationTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.CreateCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationTemplateResponse createCloudFormationTemplate(
            Consumer<CreateCloudFormationTemplateRequest.Builder> createCloudFormationTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return createCloudFormationTemplate(CreateCloudFormationTemplateRequest.builder()
                .applyMutation(createCloudFormationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.DeleteApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Gets the specified application.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the GetApplication operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves the policy for the application.
     * </p>
     *
     * @param getApplicationPolicyRequest
     * @return Result of the GetApplicationPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationPolicyResponse getApplicationPolicy(GetApplicationPolicyRequest getApplicationPolicyRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the policy for the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationPolicyRequest#builder()}
     * </p>
     *
     * @param getApplicationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the GetApplicationPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationPolicyResponse getApplicationPolicy(
            Consumer<GetApplicationPolicyRequest.Builder> getApplicationPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return getApplicationPolicy(GetApplicationPolicyRequest.builder().applyMutation(getApplicationPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the specified AWS CloudFormation template.
     * </p>
     *
     * @param getCloudFormationTemplateRequest
     * @return Result of the GetCloudFormationTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFormationTemplateResponse getCloudFormationTemplate(
            GetCloudFormationTemplateRequest getCloudFormationTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified AWS CloudFormation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFormationTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetCloudFormationTemplateRequest#builder()}
     * </p>
     *
     * @param getCloudFormationTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the GetCloudFormationTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.GetCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFormationTemplateResponse getCloudFormationTemplate(
            Consumer<GetCloudFormationTemplateRequest.Builder> getCloudFormationTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return getCloudFormationTemplate(GetCloudFormationTemplateRequest.builder()
                .applyMutation(getCloudFormationTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     *
     * @param listApplicationDependenciesRequest
     * @return Result of the ListApplicationDependencies operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesResponse listApplicationDependencies(
            ListApplicationDependenciesRequest listApplicationDependenciesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationDependencies operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesResponse listApplicationDependencies(
            Consumer<ListApplicationDependenciesRequest.Builder> listApplicationDependenciesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplicationDependencies(ListApplicationDependenciesRequest.builder()
                .applyMutation(listApplicationDependenciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client.listApplicationDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client
     *             .listApplicationDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client.listApplicationDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationDependenciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesIterable listApplicationDependenciesPaginator(
            ListApplicationDependenciesRequest listApplicationDependenciesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return new ListApplicationDependenciesIterable(this, listApplicationDependenciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client.listApplicationDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client
     *             .listApplicationDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesIterable responses = client.listApplicationDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesIterable listApplicationDependenciesPaginator(
            Consumer<ListApplicationDependenciesRequest.Builder> listApplicationDependenciesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplicationDependenciesPaginator(ListApplicationDependenciesRequest.builder()
                .applyMutation(listApplicationDependenciesRequest).build());
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return Result of the ListApplicationVersions operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsResponse listApplicationVersions(ListApplicationVersionsRequest listApplicationVersionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationVersions operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsResponse listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().applyMutation(listApplicationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client
     *             .listApplicationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsIterable listApplicationVersionsPaginator(
            ListApplicationVersionsRequest listApplicationVersionsRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        return new ListApplicationVersionsIterable(this, listApplicationVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client
     *             .listApplicationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsIterable listApplicationVersionsPaginator(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplicationVersionsPaginator(ListApplicationVersionsRequest.builder()
                .applyMutation(listApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     *
     * @return Result of the ListApplications operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see #listApplications(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications() throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see #listApplicationsPaginator(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator() throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Sets the permission policy for an application. For the list of actions supported for this operation, see <a href=
     * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     * >Application Permissions</a> .
     * </p>
     *
     * @param putApplicationPolicyRequest
     * @return Result of the PutApplicationPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.PutApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutApplicationPolicyResponse putApplicationPolicy(PutApplicationPolicyRequest putApplicationPolicyRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the permission policy for an application. For the list of actions supported for this operation, see <a href=
     * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     * >Application Permissions</a> .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutApplicationPolicyRequest#builder()}
     * </p>
     *
     * @param putApplicationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the PutApplicationPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.PutApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutApplicationPolicyResponse putApplicationPolicy(
            Consumer<PutApplicationPolicyRequest.Builder> putApplicationPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, ServerlessApplicationRepositoryException {
        return putApplicationPolicy(PutApplicationPolicyRequest.builder().applyMutation(putApplicationPolicyRequest).build());
    }

    /**
     * <p>
     * Unshares an application from an AWS Organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's master account.
     * </p>
     *
     * @param unshareApplicationRequest
     * @return Result of the UnshareApplication operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.UnshareApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UnshareApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UnshareApplicationResponse unshareApplication(UnshareApplicationRequest unshareApplicationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unshares an application from an AWS Organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnshareApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UnshareApplicationRequest#builder()}
     * </p>
     *
     * @param unshareApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the UnshareApplication operation returned by the service.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.UnshareApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UnshareApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UnshareApplicationResponse unshareApplication(Consumer<UnshareApplicationRequest.Builder> unshareApplicationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, ServerlessApplicationRepositoryException {
        return unshareApplication(UnshareApplicationRequest.builder().applyMutation(unshareApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws InternalServerErrorException
     *         The AWS Serverless Application Repository service encountered an internal error.
     * @throws ForbiddenException
     *         The client is not authenticated.
     * @throws NotFoundException
     *         The resource (for example, an access policy statement) specified in the request doesn't exist.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServerlessApplicationRepositoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServerlessApplicationRepositoryClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ServerlessApplicationRepositoryException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * Create a {@link ServerlessApplicationRepositoryClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServerlessApplicationRepositoryClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServerlessApplicationRepositoryClient}.
     */
    static ServerlessApplicationRepositoryClientBuilder builder() {
        return new DefaultServerlessApplicationRepositoryClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ServerlessApplicationRepositoryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
