/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationDependenciesResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<ListApplicationDependenciesResponse.Builder, ListApplicationDependenciesResponse> {
    private static final SdkField<List<ApplicationDependencySummary>> DEPENDENCIES_FIELD = SdkField
            .<List<ApplicationDependencySummary>> builder(MarshallingType.LIST)
            .memberName("Dependencies")
            .getter(getter(ListApplicationDependenciesResponse::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationDependencySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationDependencySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationDependenciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ApplicationDependencySummary> dependencies;

    private final String nextToken;

    private ListApplicationDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.dependencies = builder.dependencies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of application summaries nested in the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return An array of application summaries nested in the application.
     */
    public final List<ApplicationDependencySummary> dependencies() {
        return dependencies;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationDependenciesResponse)) {
            return false;
        }
        ListApplicationDependenciesResponse other = (ListApplicationDependenciesResponse) obj;
        return hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationDependenciesResponse")
                .add("Dependencies", hasDependencies() ? dependencies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dependencies", DEPENDENCIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationDependenciesResponse, T> g) {
        return obj -> g.apply((ListApplicationDependenciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationDependenciesResponse> {
        /**
         * <p>
         * An array of application summaries nested in the application.
         * </p>
         * 
         * @param dependencies
         *        An array of application summaries nested in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<ApplicationDependencySummary> dependencies);

        /**
         * <p>
         * An array of application summaries nested in the application.
         * </p>
         * 
         * @param dependencies
         *        An array of application summaries nested in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(ApplicationDependencySummary... dependencies);

        /**
         * <p>
         * An array of application summaries nested in the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary.Builder#build()}
         * is called immediately and its result is passed to {@link #dependencies(List<ApplicationDependencySummary>)}.
         * 
         * @param dependencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencies(java.util.Collection<ApplicationDependencySummary>)
         */
        Builder dependencies(Consumer<ApplicationDependencySummary.Builder>... dependencies);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private List<ApplicationDependencySummary> dependencies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationDependenciesResponse model) {
            super(model);
            dependencies(model.dependencies);
            nextToken(model.nextToken);
        }

        public final List<ApplicationDependencySummary.Builder> getDependencies() {
            List<ApplicationDependencySummary.Builder> result = ___listOfApplicationDependencySummaryCopier
                    .copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<ApplicationDependencySummary.BuilderImpl> dependencies) {
            this.dependencies = ___listOfApplicationDependencySummaryCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<ApplicationDependencySummary> dependencies) {
            this.dependencies = ___listOfApplicationDependencySummaryCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(ApplicationDependencySummary... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<ApplicationDependencySummary.Builder>... dependencies) {
            dependencies(Stream.of(dependencies).map(c -> ApplicationDependencySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationDependenciesResponse build() {
            return new ListApplicationDependenciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
