/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.testutils.service.http.MockHttpClient;
import software.amazon.awssdk.utils.Pair;

public final class MockSyncHttpClient
implements SdkHttpClient,
MockHttpClient {
    private static final Duration DEFAULT_DURATION = Duration.ofMillis(50L);
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private final List<Pair<HttpExecuteResponse, Duration>> responses = new LinkedList<Pair<HttpExecuteResponse, Duration>>();
    private final AtomicInteger responseIndex = new AtomicInteger(0);
    private boolean isClosed;

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        this.capturedRequests.add(request.httpRequest());
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() {
                Pair responseDurationPair = (Pair)MockSyncHttpClient.this.responses.get(MockSyncHttpClient.this.responseIndex.getAndIncrement() % MockSyncHttpClient.this.responses.size());
                HttpExecuteResponse response = (HttpExecuteResponse)responseDurationPair.left();
                Duration duration = (Duration)responseDurationPair.right();
                try {
                    Thread.sleep(duration.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (response == null) {
                    throw new IllegalStateException("No responses remain.");
                }
                return response;
            }

            public void abort() {
            }
        };
    }

    public void close() {
        this.isClosed = true;
    }

    @Override
    public void reset() {
        this.capturedRequests.clear();
        this.responses.clear();
        this.responseIndex.set(0);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.responses.clear();
        this.responses.add((Pair<HttpExecuteResponse, Duration>)Pair.of((Object)nextResponse, (Object)DEFAULT_DURATION));
        this.responseIndex.set(0);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse, Duration delay) {
        this.responses.add((Pair<HttpExecuteResponse, Duration>)Pair.of((Object)nextResponse, (Object)delay));
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(Pair<HttpExecuteResponse, Duration> ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.asList(responses));
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(HttpExecuteResponse ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.stream(responses).map(r -> Pair.of((Object)r, (Object)DEFAULT_DURATION)).collect(Collectors.toList()));
        this.responseIndex.set(0);
    }

    @Override
    public List<SdkHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.capturedRequests);
    }

    @Override
    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

