/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccessLevelFilterKey {
    ACCOUNT("Account"),
    ROLE("Role"),
    USER("User"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccessLevelFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessLevelFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccessLevelFilterKey.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessLevelFilterKey> knownValues() {
        return Stream.of(AccessLevelFilterKey.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

