/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ResourceDetail;
import software.amazon.awssdk.services.servicecatalog.model.ResourceDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesForTagOptionResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListResourcesForTagOptionResponse> {
    private static final SdkField<List<ResourceDetail>> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceDetails").getter(ListResourcesForTagOptionResponse.getter(ListResourcesForTagOptionResponse::resourceDetails)).setter(ListResourcesForTagOptionResponse.setter(Builder::resourceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(ListResourcesForTagOptionResponse.getter(ListResourcesForTagOptionResponse::pageToken)).setter(ListResourcesForTagOptionResponse.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DETAILS_FIELD, PAGE_TOKEN_FIELD));
    private final List<ResourceDetail> resourceDetails;
    private final String pageToken;

    private ListResourcesForTagOptionResponse(BuilderImpl builder) {
        super(builder);
        this.resourceDetails = builder.resourceDetails;
        this.pageToken = builder.pageToken;
    }

    public boolean hasResourceDetails() {
        return this.resourceDetails != null && !(this.resourceDetails instanceof SdkAutoConstructList);
    }

    public List<ResourceDetail> resourceDetails() {
        return this.resourceDetails;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDetails() ? this.resourceDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForTagOptionResponse)) {
            return false;
        }
        ListResourcesForTagOptionResponse other = (ListResourcesForTagOptionResponse)((Object)obj);
        return this.hasResourceDetails() == other.hasResourceDetails() && Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourcesForTagOptionResponse").add("ResourceDetails", this.hasResourceDetails() ? this.resourceDetails() : null).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesForTagOptionResponse, T> g) {
        return obj -> g.apply((ListResourcesForTagOptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ResourceDetail> resourceDetails = DefaultSdkAutoConstructList.getInstance();
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForTagOptionResponse model) {
            super(model);
            this.resourceDetails(model.resourceDetails);
            this.pageToken(model.pageToken);
        }

        public final Collection<ResourceDetail.Builder> getResourceDetails() {
            if (this.resourceDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceDetails != null ? (Collection)this.resourceDetails.stream().map(ResourceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceDetails(Collection<ResourceDetail> resourceDetails) {
            this.resourceDetails = ResourceDetailsCopier.copy(resourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetails(ResourceDetail ... resourceDetails) {
            this.resourceDetails(Arrays.asList(resourceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetails(Consumer<ResourceDetail.Builder> ... resourceDetails) {
            this.resourceDetails(Stream.of(resourceDetails).map(c -> (ResourceDetail)((ResourceDetail.Builder)ResourceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceDetails(Collection<ResourceDetail.BuilderImpl> resourceDetails) {
            this.resourceDetails = ResourceDetailsCopier.copyFromBuilder(resourceDetails);
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public ListResourcesForTagOptionResponse build() {
            return new ListResourcesForTagOptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesForTagOptionResponse> {
        public Builder resourceDetails(Collection<ResourceDetail> var1);

        public Builder resourceDetails(ResourceDetail ... var1);

        public Builder resourceDetails(Consumer<ResourceDetail.Builder> ... var1);

        public Builder pageToken(String var1);
    }
}

