/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.BudgetDetail;
import software.amazon.awssdk.services.servicecatalog.model.BudgetsCopier;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribePortfolioResponse> {
    private static final SdkField<PortfolioDetail> PORTFOLIO_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortfolioDetail").getter(DescribePortfolioResponse.getter(DescribePortfolioResponse::portfolioDetail)).setter(DescribePortfolioResponse.setter(Builder::portfolioDetail)).constructor(PortfolioDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribePortfolioResponse.getter(DescribePortfolioResponse::tags)).setter(DescribePortfolioResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagOptionDetail>> TAG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagOptions").getter(DescribePortfolioResponse.getter(DescribePortfolioResponse::tagOptions)).setter(DescribePortfolioResponse.setter(Builder::tagOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagOptionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Budgets").getter(DescribePortfolioResponse.getter(DescribePortfolioResponse::budgets)).setter(DescribePortfolioResponse.setter(Builder::budgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_DETAIL_FIELD, TAGS_FIELD, TAG_OPTIONS_FIELD, BUDGETS_FIELD));
    private final PortfolioDetail portfolioDetail;
    private final List<Tag> tags;
    private final List<TagOptionDetail> tagOptions;
    private final List<BudgetDetail> budgets;

    private DescribePortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
        this.tagOptions = builder.tagOptions;
        this.budgets = builder.budgets;
    }

    public final PortfolioDetail portfolioDetail() {
        return this.portfolioDetail;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasTagOptions() {
        return this.tagOptions != null && !(this.tagOptions instanceof SdkAutoConstructList);
    }

    public final List<TagOptionDetail> tagOptions() {
        return this.tagOptions;
    }

    public final boolean hasBudgets() {
        return this.budgets != null && !(this.budgets instanceof SdkAutoConstructList);
    }

    public final List<BudgetDetail> budgets() {
        return this.budgets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagOptions() ? this.tagOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgets() ? this.budgets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioResponse)) {
            return false;
        }
        DescribePortfolioResponse other = (DescribePortfolioResponse)((Object)obj);
        return Objects.equals(this.portfolioDetail(), other.portfolioDetail()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTagOptions() == other.hasTagOptions() && Objects.equals(this.tagOptions(), other.tagOptions()) && this.hasBudgets() == other.hasBudgets() && Objects.equals(this.budgets(), other.budgets());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePortfolioResponse").add("PortfolioDetail", (Object)this.portfolioDetail()).add("Tags", this.hasTags() ? this.tags() : null).add("TagOptions", this.hasTagOptions() ? this.tagOptions() : null).add("Budgets", this.hasBudgets() ? this.budgets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetail": {
                return Optional.ofNullable(clazz.cast(this.portfolioDetail()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TagOptions": {
                return Optional.ofNullable(clazz.cast(this.tagOptions()));
            }
            case "Budgets": {
                return Optional.ofNullable(clazz.cast(this.budgets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioResponse, T> g) {
        return obj -> g.apply((DescribePortfolioResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private PortfolioDetail portfolioDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<TagOptionDetail> tagOptions = DefaultSdkAutoConstructList.getInstance();
        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioResponse model) {
            super(model);
            this.portfolioDetail(model.portfolioDetail);
            this.tags(model.tags);
            this.tagOptions(model.tagOptions);
            this.budgets(model.budgets);
        }

        public final PortfolioDetail.Builder getPortfolioDetail() {
            return this.portfolioDetail != null ? this.portfolioDetail.toBuilder() : null;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final void setPortfolioDetail(PortfolioDetail.BuilderImpl portfolioDetail) {
            this.portfolioDetail = portfolioDetail != null ? portfolioDetail.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final List<TagOptionDetail.Builder> getTagOptions() {
            List<TagOptionDetail.Builder> result = TagOptionDetailsCopier.copyToBuilder(this.tagOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionDetail> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionDetail ... tagOptions) {
            this.tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionDetail.Builder> ... tagOptions) {
            this.tagOptions(Stream.of(tagOptions).map(c -> (TagOptionDetail)((TagOptionDetail.Builder)TagOptionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionDetail.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copyFromBuilder(tagOptions);
        }

        public final List<BudgetDetail.Builder> getBudgets() {
            List<BudgetDetail.Builder> result = BudgetsCopier.copyToBuilder(this.budgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder> ... budgets) {
            this.budgets(Stream.of(budgets).map(c -> (BudgetDetail)((BudgetDetail.Builder)BudgetDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public DescribePortfolioResponse build() {
            return new DescribePortfolioResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePortfolioResponse> {
        public Builder portfolioDetail(PortfolioDetail var1);

        default public Builder portfolioDetail(Consumer<PortfolioDetail.Builder> portfolioDetail) {
            return this.portfolioDetail((PortfolioDetail)((PortfolioDetail.Builder)PortfolioDetail.builder().applyMutation(portfolioDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder tagOptions(Collection<TagOptionDetail> var1);

        public Builder tagOptions(TagOptionDetail ... var1);

        public Builder tagOptions(Consumer<TagOptionDetail.Builder> ... var1);

        public Builder budgets(Collection<BudgetDetail> var1);

        public Builder budgets(BudgetDetail ... var1);

        public Builder budgets(Consumer<BudgetDetail.Builder> ... var1);
    }
}

