/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisionedProductPlanResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProvisionedProductPlanResponse.Builder, DescribeProvisionedProductPlanResponse> {
    private static final SdkField<ProvisionedProductPlanDetails> PROVISIONED_PRODUCT_PLAN_DETAILS_FIELD = SdkField
            .<ProvisionedProductPlanDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedProductPlanDetails")
            .getter(getter(DescribeProvisionedProductPlanResponse::provisionedProductPlanDetails))
            .setter(setter(Builder::provisionedProductPlanDetails))
            .constructor(ProvisionedProductPlanDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductPlanDetails")
                    .build()).build();

    private static final SdkField<List<ResourceChange>> RESOURCE_CHANGES_FIELD = SdkField
            .<List<ResourceChange>> builder(MarshallingType.LIST)
            .memberName("ResourceChanges")
            .getter(getter(DescribeProvisionedProductPlanResponse::resourceChanges))
            .setter(setter(Builder::resourceChanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceChanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(DescribeProvisionedProductPlanResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONED_PRODUCT_PLAN_DETAILS_FIELD, RESOURCE_CHANGES_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final ProvisionedProductPlanDetails provisionedProductPlanDetails;

    private final List<ResourceChange> resourceChanges;

    private final String nextPageToken;

    private DescribeProvisionedProductPlanResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductPlanDetails = builder.provisionedProductPlanDetails;
        this.resourceChanges = builder.resourceChanges;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * Information about the plan.
     * </p>
     * 
     * @return Information about the plan.
     */
    public final ProvisionedProductPlanDetails provisionedProductPlanDetails() {
        return provisionedProductPlanDetails;
    }

    /**
     * Returns true if the ResourceChanges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResourceChanges() {
        return resourceChanges != null && !(resourceChanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource changes that will occur when the plan is executed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceChanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resource changes that will occur when the plan is executed.
     */
    public final List<ResourceChange> resourceChanges() {
        return resourceChanges;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductPlanDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceChanges() ? resourceChanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisionedProductPlanResponse)) {
            return false;
        }
        DescribeProvisionedProductPlanResponse other = (DescribeProvisionedProductPlanResponse) obj;
        return Objects.equals(provisionedProductPlanDetails(), other.provisionedProductPlanDetails())
                && hasResourceChanges() == other.hasResourceChanges()
                && Objects.equals(resourceChanges(), other.resourceChanges())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProvisionedProductPlanResponse")
                .add("ProvisionedProductPlanDetails", provisionedProductPlanDetails())
                .add("ResourceChanges", hasResourceChanges() ? resourceChanges() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductPlanDetails":
            return Optional.ofNullable(clazz.cast(provisionedProductPlanDetails()));
        case "ResourceChanges":
            return Optional.ofNullable(clazz.cast(resourceChanges()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisionedProductPlanResponse, T> g) {
        return obj -> g.apply((DescribeProvisionedProductPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisionedProductPlanResponse> {
        /**
         * <p>
         * Information about the plan.
         * </p>
         * 
         * @param provisionedProductPlanDetails
         *        Information about the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductPlanDetails(ProvisionedProductPlanDetails provisionedProductPlanDetails);

        /**
         * <p>
         * Information about the plan.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedProductPlanDetails.Builder} avoiding
         * the need to create one manually via {@link ProvisionedProductPlanDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedProductPlanDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedProductPlanDetails(ProvisionedProductPlanDetails)}
         * .
         * 
         * @param provisionedProductPlanDetails
         *        a consumer that will call methods on {@link ProvisionedProductPlanDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedProductPlanDetails(ProvisionedProductPlanDetails)
         */
        default Builder provisionedProductPlanDetails(
                Consumer<ProvisionedProductPlanDetails.Builder> provisionedProductPlanDetails) {
            return provisionedProductPlanDetails(ProvisionedProductPlanDetails.builder()
                    .applyMutation(provisionedProductPlanDetails).build());
        }

        /**
         * <p>
         * Information about the resource changes that will occur when the plan is executed.
         * </p>
         * 
         * @param resourceChanges
         *        Information about the resource changes that will occur when the plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceChanges(Collection<ResourceChange> resourceChanges);

        /**
         * <p>
         * Information about the resource changes that will occur when the plan is executed.
         * </p>
         * 
         * @param resourceChanges
         *        Information about the resource changes that will occur when the plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceChanges(ResourceChange... resourceChanges);

        /**
         * <p>
         * Information about the resource changes that will occur when the plan is executed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceChange>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceChange>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceChanges(List<ResourceChange>)}.
         * 
         * @param resourceChanges
         *        a consumer that will call methods on {@link List<ResourceChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceChanges(List<ResourceChange>)
         */
        Builder resourceChanges(Consumer<ResourceChange.Builder>... resourceChanges);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProvisionedProductPlanDetails provisionedProductPlanDetails;

        private List<ResourceChange> resourceChanges = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisionedProductPlanResponse model) {
            super(model);
            provisionedProductPlanDetails(model.provisionedProductPlanDetails);
            resourceChanges(model.resourceChanges);
            nextPageToken(model.nextPageToken);
        }

        public final ProvisionedProductPlanDetails.Builder getProvisionedProductPlanDetails() {
            return provisionedProductPlanDetails != null ? provisionedProductPlanDetails.toBuilder() : null;
        }

        @Override
        public final Builder provisionedProductPlanDetails(ProvisionedProductPlanDetails provisionedProductPlanDetails) {
            this.provisionedProductPlanDetails = provisionedProductPlanDetails;
            return this;
        }

        public final void setProvisionedProductPlanDetails(ProvisionedProductPlanDetails.BuilderImpl provisionedProductPlanDetails) {
            this.provisionedProductPlanDetails = provisionedProductPlanDetails != null ? provisionedProductPlanDetails.build()
                    : null;
        }

        public final List<ResourceChange.Builder> getResourceChanges() {
            List<ResourceChange.Builder> result = ResourceChangesCopier.copyToBuilder(this.resourceChanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourceChanges(Collection<ResourceChange> resourceChanges) {
            this.resourceChanges = ResourceChangesCopier.copy(resourceChanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceChanges(ResourceChange... resourceChanges) {
            resourceChanges(Arrays.asList(resourceChanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceChanges(Consumer<ResourceChange.Builder>... resourceChanges) {
            resourceChanges(Stream.of(resourceChanges).map(c -> ResourceChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceChanges(Collection<ResourceChange.BuilderImpl> resourceChanges) {
            this.resourceChanges = ResourceChangesCopier.copyFromBuilder(resourceChanges);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public DescribeProvisionedProductPlanResponse build() {
            return new DescribeProvisionedProductPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
