/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAwsOrganizationsAccessStatusResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<GetAwsOrganizationsAccessStatusResponse.Builder, GetAwsOrganizationsAccessStatusResponse> {
    private static final SdkField<String> ACCESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessStatus").getter(getter(GetAwsOrganizationsAccessStatusResponse::accessStatusAsString))
            .setter(setter(Builder::accessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_STATUS_FIELD));

    private final String accessStatus;

    private GetAwsOrganizationsAccessStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accessStatus = builder.accessStatus;
    }

    /**
     * <p>
     * The status of the portfolio share feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link AccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessStatusAsString}.
     * </p>
     * 
     * @return The status of the portfolio share feature.
     * @see AccessStatus
     */
    public final AccessStatus accessStatus() {
        return AccessStatus.fromValue(accessStatus);
    }

    /**
     * <p>
     * The status of the portfolio share feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link AccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessStatusAsString}.
     * </p>
     * 
     * @return The status of the portfolio share feature.
     * @see AccessStatus
     */
    public final String accessStatusAsString() {
        return accessStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsOrganizationsAccessStatusResponse)) {
            return false;
        }
        GetAwsOrganizationsAccessStatusResponse other = (GetAwsOrganizationsAccessStatusResponse) obj;
        return Objects.equals(accessStatusAsString(), other.accessStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAwsOrganizationsAccessStatusResponse").add("AccessStatus", accessStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessStatus":
            return Optional.ofNullable(clazz.cast(accessStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAwsOrganizationsAccessStatusResponse, T> g) {
        return obj -> g.apply((GetAwsOrganizationsAccessStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAwsOrganizationsAccessStatusResponse> {
        /**
         * <p>
         * The status of the portfolio share feature.
         * </p>
         * 
         * @param accessStatus
         *        The status of the portfolio share feature.
         * @see AccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessStatus
         */
        Builder accessStatus(String accessStatus);

        /**
         * <p>
         * The status of the portfolio share feature.
         * </p>
         * 
         * @param accessStatus
         *        The status of the portfolio share feature.
         * @see AccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessStatus
         */
        Builder accessStatus(AccessStatus accessStatus);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String accessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsOrganizationsAccessStatusResponse model) {
            super(model);
            accessStatus(model.accessStatus);
        }

        public final String getAccessStatus() {
            return accessStatus;
        }

        @Override
        public final Builder accessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
            return this;
        }

        @Override
        public final Builder accessStatus(AccessStatus accessStatus) {
            this.accessStatus(accessStatus == null ? null : accessStatus.toString());
            return this;
        }

        public final void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }

        @Override
        public GetAwsOrganizationsAccessStatusResponse build() {
            return new GetAwsOrganizationsAccessStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
