/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateServiceActionFromProvisioningArtifactResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<BatchDisassociateServiceActionFromProvisioningArtifactResponse.Builder, BatchDisassociateServiceActionFromProvisioningArtifactResponse> {
    private static final SdkField<List<FailedServiceActionAssociation>> FAILED_SERVICE_ACTION_ASSOCIATIONS_FIELD = SdkField
            .<List<FailedServiceActionAssociation>> builder(MarshallingType.LIST)
            .memberName("FailedServiceActionAssociations")
            .getter(getter(BatchDisassociateServiceActionFromProvisioningArtifactResponse::failedServiceActionAssociations))
            .setter(setter(Builder::failedServiceActionAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedServiceActionAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedServiceActionAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedServiceActionAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_SERVICE_ACTION_ASSOCIATIONS_FIELD));

    private final List<FailedServiceActionAssociation> failedServiceActionAssociations;

    private BatchDisassociateServiceActionFromProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.failedServiceActionAssociations = builder.failedServiceActionAssociations;
    }

    /**
     * Returns true if the FailedServiceActionAssociations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasFailedServiceActionAssociations() {
        return failedServiceActionAssociations != null && !(failedServiceActionAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains a list of errors, along with information to help you identify the self-service action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedServiceActionAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that contains a list of errors, along with information to help you identify the self-service
     *         action.
     */
    public final List<FailedServiceActionAssociation> failedServiceActionAssociations() {
        return failedServiceActionAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFailedServiceActionAssociations() ? failedServiceActionAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateServiceActionFromProvisioningArtifactResponse)) {
            return false;
        }
        BatchDisassociateServiceActionFromProvisioningArtifactResponse other = (BatchDisassociateServiceActionFromProvisioningArtifactResponse) obj;
        return hasFailedServiceActionAssociations() == other.hasFailedServiceActionAssociations()
                && Objects.equals(failedServiceActionAssociations(), other.failedServiceActionAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchDisassociateServiceActionFromProvisioningArtifactResponse")
                .add("FailedServiceActionAssociations",
                        hasFailedServiceActionAssociations() ? failedServiceActionAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedServiceActionAssociations":
            return Optional.ofNullable(clazz.cast(failedServiceActionAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateServiceActionFromProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((BatchDisassociateServiceActionFromProvisioningArtifactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateServiceActionFromProvisioningArtifactResponse> {
        /**
         * <p>
         * An object that contains a list of errors, along with information to help you identify the self-service
         * action.
         * </p>
         * 
         * @param failedServiceActionAssociations
         *        An object that contains a list of errors, along with information to help you identify the self-service
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedServiceActionAssociations(Collection<FailedServiceActionAssociation> failedServiceActionAssociations);

        /**
         * <p>
         * An object that contains a list of errors, along with information to help you identify the self-service
         * action.
         * </p>
         * 
         * @param failedServiceActionAssociations
         *        An object that contains a list of errors, along with information to help you identify the self-service
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedServiceActionAssociations(FailedServiceActionAssociation... failedServiceActionAssociations);

        /**
         * <p>
         * An object that contains a list of errors, along with information to help you identify the self-service
         * action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedServiceActionAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<FailedServiceActionAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedServiceActionAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #failedServiceActionAssociations(List<FailedServiceActionAssociation>)}.
         * 
         * @param failedServiceActionAssociations
         *        a consumer that will call methods on {@link List<FailedServiceActionAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedServiceActionAssociations(List<FailedServiceActionAssociation>)
         */
        Builder failedServiceActionAssociations(
                Consumer<FailedServiceActionAssociation.Builder>... failedServiceActionAssociations);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<FailedServiceActionAssociation> failedServiceActionAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateServiceActionFromProvisioningArtifactResponse model) {
            super(model);
            failedServiceActionAssociations(model.failedServiceActionAssociations);
        }

        public final List<FailedServiceActionAssociation.Builder> getFailedServiceActionAssociations() {
            List<FailedServiceActionAssociation.Builder> result = FailedServiceActionAssociationsCopier
                    .copyToBuilder(this.failedServiceActionAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedServiceActionAssociations(
                Collection<FailedServiceActionAssociation> failedServiceActionAssociations) {
            this.failedServiceActionAssociations = FailedServiceActionAssociationsCopier.copy(failedServiceActionAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedServiceActionAssociations(FailedServiceActionAssociation... failedServiceActionAssociations) {
            failedServiceActionAssociations(Arrays.asList(failedServiceActionAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedServiceActionAssociations(
                Consumer<FailedServiceActionAssociation.Builder>... failedServiceActionAssociations) {
            failedServiceActionAssociations(Stream.of(failedServiceActionAssociations)
                    .map(c -> FailedServiceActionAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedServiceActionAssociations(
                Collection<FailedServiceActionAssociation.BuilderImpl> failedServiceActionAssociations) {
            this.failedServiceActionAssociations = FailedServiceActionAssociationsCopier
                    .copyFromBuilder(failedServiceActionAssociations);
        }

        @Override
        public BatchDisassociateServiceActionFromProvisioningArtifactResponse build() {
            return new BatchDisassociateServiceActionFromProvisioningArtifactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
