/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<CreateProductRequest.Builder, CreateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(CreateProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateProductRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(CreateProductRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateProductRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Distributor").getter(getter(CreateProductRequest::distributor)).setter(setter(Builder::distributor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()).build();

    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportDescription").getter(getter(CreateProductRequest::supportDescription))
            .setter(setter(Builder::supportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build())
            .build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportEmail").getter(getter(CreateProductRequest::supportEmail)).setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportUrl").getter(getter(CreateProductRequest::supportUrl)).setter(setter(Builder::supportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(CreateProductRequest::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProductRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningArtifactProperties> PROVISIONING_ARTIFACT_PARAMETERS_FIELD = SdkField
            .<ProvisioningArtifactProperties> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisioningArtifactParameters")
            .getter(getter(CreateProductRequest::provisioningArtifactParameters))
            .setter(setter(Builder::provisioningArtifactParameters))
            .constructor(ProvisioningArtifactProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactParameters")
                    .build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateProductRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_EMAIL_FIELD,
            SUPPORT_URL_FIELD, PRODUCT_TYPE_FIELD, TAGS_FIELD, PROVISIONING_ARTIFACT_PARAMETERS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String name;

    private final String owner;

    private final String description;

    private final String distributor;

    private final String supportDescription;

    private final String supportEmail;

    private final String supportUrl;

    private final String productType;

    private final List<Tag> tags;

    private final ProvisioningArtifactProperties provisioningArtifactParameters;

    private final String idempotencyToken;

    private CreateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.productType = builder.productType;
        this.tags = builder.tags;
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The name of the product.
     * </p>
     * 
     * @return The name of the product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the product.
     * </p>
     * 
     * @return The owner of the product.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The description of the product.
     * </p>
     * 
     * @return The description of the product.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The distributor of the product.
     * </p>
     * 
     * @return The distributor of the product.
     */
    public final String distributor() {
        return distributor;
    }

    /**
     * <p>
     * The support information about the product.
     * </p>
     * 
     * @return The support information about the product.
     */
    public final String supportDescription() {
        return supportDescription;
    }

    /**
     * <p>
     * The contact email for product support.
     * </p>
     * 
     * @return The contact email for product support.
     */
    public final String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The contact URL for product support.
     * </p>
     * <p>
     * <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.
     * </p>
     * 
     * @return The contact URL for product support.</p>
     *         <p>
     *         <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.
     */
    public final String supportUrl() {
        return supportUrl;
    }

    /**
     * <p>
     * The type of product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #productTypeAsString}.
     * </p>
     * 
     * @return The type of product.
     * @see ProductType
     */
    public final ProductType productType() {
        return ProductType.fromValue(productType);
    }

    /**
     * <p>
     * The type of product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #productTypeAsString}.
     * </p>
     * 
     * @return The type of product.
     * @see ProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration of the provisioning artifact.
     * </p>
     * 
     * @return The configuration of the provisioning artifact.
     */
    public final ProvisioningArtifactProperties provisioningArtifactParameters() {
        return provisioningArtifactParameters;
    }

    /**
     * <p>
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency
     * token, the same response is returned for each repeated request.
     * </p>
     * 
     * @return A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
     *         idempotency token, the same response is returned for each repeated request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(distributor());
        hashCode = 31 * hashCode + Objects.hashCode(supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactParameters());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductRequest)) {
            return false;
        }
        CreateProductRequest other = (CreateProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner()) && Objects.equals(description(), other.description())
                && Objects.equals(distributor(), other.distributor())
                && Objects.equals(supportDescription(), other.supportDescription())
                && Objects.equals(supportEmail(), other.supportEmail()) && Objects.equals(supportUrl(), other.supportUrl())
                && Objects.equals(productTypeAsString(), other.productTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(provisioningArtifactParameters(), other.provisioningArtifactParameters())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProductRequest").add("AcceptLanguage", acceptLanguage()).add("Name", name())
                .add("Owner", owner()).add("Description", description()).add("Distributor", distributor())
                .add("SupportDescription", supportDescription()).add("SupportEmail", supportEmail())
                .add("SupportUrl", supportUrl()).add("ProductType", productTypeAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ProvisioningArtifactParameters", provisioningArtifactParameters())
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Distributor":
            return Optional.ofNullable(clazz.cast(distributor()));
        case "SupportDescription":
            return Optional.ofNullable(clazz.cast(supportDescription()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportUrl":
            return Optional.ofNullable(clazz.cast(supportUrl()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ProvisioningArtifactParameters":
            return Optional.ofNullable(clazz.cast(provisioningArtifactParameters()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProductRequest, T> g) {
        return obj -> g.apply((CreateProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The name of the product.
         * </p>
         * 
         * @param name
         *        The name of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the product.
         * </p>
         * 
         * @param owner
         *        The owner of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The description of the product.
         * </p>
         * 
         * @param description
         *        The description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The distributor of the product.
         * </p>
         * 
         * @param distributor
         *        The distributor of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributor(String distributor);

        /**
         * <p>
         * The support information about the product.
         * </p>
         * 
         * @param supportDescription
         *        The support information about the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportDescription(String supportDescription);

        /**
         * <p>
         * The contact email for product support.
         * </p>
         * 
         * @param supportEmail
         *        The contact email for product support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The contact URL for product support.
         * </p>
         * <p>
         * <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.
         * </p>
         * 
         * @param supportUrl
         *        The contact URL for product support.</p>
         *        <p>
         *        <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportUrl(String supportUrl);

        /**
         * <p>
         * The type of product.
         * </p>
         * 
         * @param productType
         *        The type of product.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The type of product.
         * </p>
         * 
         * @param productType
         *        The type of product.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder productType(ProductType productType);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactParameters
         *        The configuration of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactParameters(ProvisioningArtifactProperties provisioningArtifactParameters);

        /**
         * <p>
         * The configuration of the provisioning artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisioningArtifactProperties.Builder} avoiding
         * the need to create one manually via {@link ProvisioningArtifactProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningArtifactProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #provisioningArtifactParameters(ProvisioningArtifactProperties)}.
         * 
         * @param provisioningArtifactParameters
         *        a consumer that will call methods on {@link ProvisioningArtifactProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactParameters(ProvisioningArtifactProperties)
         */
        default Builder provisioningArtifactParameters(
                Consumer<ProvisioningArtifactProperties.Builder> provisioningArtifactParameters) {
            return provisioningArtifactParameters(ProvisioningArtifactProperties.builder()
                    .applyMutation(provisioningArtifactParameters).build());
        }

        /**
         * <p>
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         * idempotency token, the same response is returned for each repeated request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         *        idempotency token, the same response is returned for each repeated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String name;

        private String owner;

        private String description;

        private String distributor;

        private String supportDescription;

        private String supportEmail;

        private String supportUrl;

        private String productType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningArtifactProperties provisioningArtifactParameters;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            name(model.name);
            owner(model.owner);
            description(model.description);
            distributor(model.distributor);
            supportDescription(model.supportDescription);
            supportEmail(model.supportEmail);
            supportUrl(model.supportUrl);
            productType(model.productType);
            tags(model.tags);
            provisioningArtifactParameters(model.provisioningArtifactParameters);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final String getProductType() {
            return productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(ProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = AddTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = AddTagsCopier.copyFromBuilder(tags);
        }

        public final ProvisioningArtifactProperties.Builder getProvisioningArtifactParameters() {
            return provisioningArtifactParameters != null ? provisioningArtifactParameters.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactParameters(ProvisioningArtifactProperties provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters;
            return this;
        }

        public final void setProvisioningArtifactParameters(
                ProvisioningArtifactProperties.BuilderImpl provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters != null ? provisioningArtifactParameters.build()
                    : null;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProductRequest build() {
            return new CreateProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
