/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePortfolioSharesRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<DescribePortfolioSharesRequest.Builder, DescribePortfolioSharesRequest> {
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(DescribePortfolioSharesRequest::portfolioId))
            .setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribePortfolioSharesRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(DescribePortfolioSharesRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(DescribePortfolioSharesRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_ID_FIELD,
            TYPE_FIELD, PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private final String portfolioId;

    private final String type;

    private final String pageToken;

    private final Integer pageSize;

    private DescribePortfolioSharesRequest(BuilderImpl builder) {
        super(builder);
        this.portfolioId = builder.portfolioId;
        this.type = builder.type;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The unique identifier of the portfolio for which shares will be retrieved.
     * </p>
     * 
     * @return The unique identifier of the portfolio for which shares will be retrieved.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can
     * be one of the following:
     * </p>
     * <p>
     * 1. <code>ACCOUNT</code> - Represents an external account to account share.
     * </p>
     * <p>
     * 2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in
     * the organization.
     * </p>
     * <p>
     * 3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
     * </p>
     * <p>
     * 4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DescribePortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share,
     *         which can be one of the following:</p>
     *         <p>
     *         1. <code>ACCOUNT</code> - Represents an external account to account share.
     *         </p>
     *         <p>
     *         2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
     *         account in the organization.
     *         </p>
     *         <p>
     *         3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
     *         </p>
     *         <p>
     *         4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
     * @see DescribePortfolioShareType
     */
    public final DescribePortfolioShareType type() {
        return DescribePortfolioShareType.fromValue(type);
    }

    /**
     * <p>
     * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can
     * be one of the following:
     * </p>
     * <p>
     * 1. <code>ACCOUNT</code> - Represents an external account to account share.
     * </p>
     * <p>
     * 2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in
     * the organization.
     * </p>
     * <p>
     * 3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
     * </p>
     * <p>
     * 4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DescribePortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share,
     *         which can be one of the following:</p>
     *         <p>
     *         1. <code>ACCOUNT</code> - Represents an external account to account share.
     *         </p>
     *         <p>
     *         2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
     *         account in the organization.
     *         </p>
     *         <p>
     *         3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
     *         </p>
     *         <p>
     *         4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
     * @see DescribePortfolioShareType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioSharesRequest)) {
            return false;
        }
        DescribePortfolioSharesRequest other = (DescribePortfolioSharesRequest) obj;
        return Objects.equals(portfolioId(), other.portfolioId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(pageToken(), other.pageToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePortfolioSharesRequest").add("PortfolioId", portfolioId()).add("Type", typeAsString())
                .add("PageToken", pageToken()).add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioSharesRequest, T> g) {
        return obj -> g.apply((DescribePortfolioSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePortfolioSharesRequest> {
        /**
         * <p>
         * The unique identifier of the portfolio for which shares will be retrieved.
         * </p>
         * 
         * @param portfolioId
         *        The unique identifier of the portfolio for which shares will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which
         * can be one of the following:
         * </p>
         * <p>
         * 1. <code>ACCOUNT</code> - Represents an external account to account share.
         * </p>
         * <p>
         * 2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
         * account in the organization.
         * </p>
         * <p>
         * 3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
         * </p>
         * <p>
         * 4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
         * </p>
         * 
         * @param type
         *        The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share,
         *        which can be one of the following:</p>
         *        <p>
         *        1. <code>ACCOUNT</code> - Represents an external account to account share.
         *        </p>
         *        <p>
         *        2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
         *        account in the organization.
         *        </p>
         *        <p>
         *        3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
         *        </p>
         *        <p>
         *        4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
         * @see DescribePortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribePortfolioShareType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which
         * can be one of the following:
         * </p>
         * <p>
         * 1. <code>ACCOUNT</code> - Represents an external account to account share.
         * </p>
         * <p>
         * 2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
         * account in the organization.
         * </p>
         * <p>
         * 3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
         * </p>
         * <p>
         * 4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
         * </p>
         * 
         * @param type
         *        The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share,
         *        which can be one of the following:</p>
         *        <p>
         *        1. <code>ACCOUNT</code> - Represents an external account to account share.
         *        </p>
         *        <p>
         *        2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every
         *        account in the organization.
         *        </p>
         *        <p>
         *        3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.
         *        </p>
         *        <p>
         *        4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.
         * @see DescribePortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribePortfolioShareType
         */
        Builder type(DescribePortfolioShareType type);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String portfolioId;

        private String type;

        private String pageToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioSharesRequest model) {
            super(model);
            portfolioId(model.portfolioId);
            type(model.type);
            pageToken(model.pageToken);
            pageSize(model.pageSize);
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DescribePortfolioShareType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePortfolioSharesRequest build() {
            return new DescribePortfolioSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
