/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPortfoliosForProductResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListPortfoliosForProductResponse.Builder, ListPortfoliosForProductResponse> {
    private static final SdkField<List<PortfolioDetail>> PORTFOLIO_DETAILS_FIELD = SdkField
            .<List<PortfolioDetail>> builder(MarshallingType.LIST)
            .memberName("PortfolioDetails")
            .getter(getter(ListPortfoliosForProductResponse::portfolioDetails))
            .setter(setter(Builder::portfolioDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortfolioDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortfolioDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListPortfoliosForProductResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_DETAILS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<PortfolioDetail> portfolioDetails;

    private final String nextPageToken;

    private ListPortfoliosForProductResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetails = builder.portfolioDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the PortfolioDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPortfolioDetails() {
        return portfolioDetails != null && !(portfolioDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the portfolios.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortfolioDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the portfolios.
     */
    public final List<PortfolioDetail> portfolioDetails() {
        return portfolioDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortfolioDetails() ? portfolioDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfoliosForProductResponse)) {
            return false;
        }
        ListPortfoliosForProductResponse other = (ListPortfoliosForProductResponse) obj;
        return hasPortfolioDetails() == other.hasPortfolioDetails()
                && Objects.equals(portfolioDetails(), other.portfolioDetails())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPortfoliosForProductResponse")
                .add("PortfolioDetails", hasPortfolioDetails() ? portfolioDetails() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioDetails":
            return Optional.ofNullable(clazz.cast(portfolioDetails()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortfoliosForProductResponse, T> g) {
        return obj -> g.apply((ListPortfoliosForProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPortfoliosForProductResponse> {
        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * 
         * @param portfolioDetails
         *        Information about the portfolios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails);

        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * 
         * @param portfolioDetails
         *        Information about the portfolios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioDetails(PortfolioDetail... portfolioDetails);

        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortfolioDetail>.Builder} avoiding the need
         * to create one manually via {@link List<PortfolioDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortfolioDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #portfolioDetails(List<PortfolioDetail>)}.
         * 
         * @param portfolioDetails
         *        a consumer that will call methods on {@link List<PortfolioDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portfolioDetails(List<PortfolioDetail>)
         */
        Builder portfolioDetails(Consumer<PortfolioDetail.Builder>... portfolioDetails);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<PortfolioDetail> portfolioDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfoliosForProductResponse model) {
            super(model);
            portfolioDetails(model.portfolioDetails);
            nextPageToken(model.nextPageToken);
        }

        public final List<PortfolioDetail.Builder> getPortfolioDetails() {
            List<PortfolioDetail.Builder> result = PortfolioDetailsCopier.copyToBuilder(this.portfolioDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(PortfolioDetail... portfolioDetails) {
            portfolioDetails(Arrays.asList(portfolioDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(Consumer<PortfolioDetail.Builder>... portfolioDetails) {
            portfolioDetails(Stream.of(portfolioDetails).map(c -> PortfolioDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortfolioDetails(Collection<PortfolioDetail.BuilderImpl> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copyFromBuilder(portfolioDetails);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListPortfoliosForProductResponse build() {
            return new ListPortfoliosForProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
