/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePortfolioShareStatusRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<DescribePortfolioShareStatusRequest.Builder, DescribePortfolioShareStatusRequest> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioShareToken").getter(getter(DescribePortfolioShareStatusRequest::portfolioShareToken))
            .setter(setter(Builder::portfolioShareToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD));

    private final String portfolioShareToken;

    private DescribePortfolioShareStatusRequest(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
    }

    /**
     * <p>
     * The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by
     * DeletePortfolioShare.
     * </p>
     * 
     * @return The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by
     *         DeletePortfolioShare.
     */
    public final String portfolioShareToken() {
        return portfolioShareToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioShareStatusRequest)) {
            return false;
        }
        DescribePortfolioShareStatusRequest other = (DescribePortfolioShareStatusRequest) obj;
        return Objects.equals(portfolioShareToken(), other.portfolioShareToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePortfolioShareStatusRequest").add("PortfolioShareToken", portfolioShareToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioShareToken":
            return Optional.ofNullable(clazz.cast(portfolioShareToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioShareStatusRequest, T> g) {
        return obj -> g.apply((DescribePortfolioShareStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePortfolioShareStatusRequest> {
        /**
         * <p>
         * The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by
         * DeletePortfolioShare.
         * </p>
         * 
         * @param portfolioShareToken
         *        The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or
         *        by DeletePortfolioShare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareToken(String portfolioShareToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String portfolioShareToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioShareStatusRequest model) {
            super(model);
            portfolioShareToken(model.portfolioShareToken);
        }

        public final String getPortfolioShareToken() {
            return portfolioShareToken;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        @Override
        @Transient
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePortfolioShareStatusRequest build() {
            return new DescribePortfolioShareStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
