/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecordHistoryRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ListRecordHistoryRequest.Builder, ListRecordHistoryRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ListRecordHistoryRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField
            .<AccessLevelFilter> builder(MarshallingType.SDK_POJO).memberName("AccessLevelFilter")
            .getter(getter(ListRecordHistoryRequest::accessLevelFilter)).setter(setter(Builder::accessLevelFilter))
            .constructor(AccessLevelFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()).build();

    private static final SdkField<ListRecordHistorySearchFilter> SEARCH_FILTER_FIELD = SdkField
            .<ListRecordHistorySearchFilter> builder(MarshallingType.SDK_POJO).memberName("SearchFilter")
            .getter(getter(ListRecordHistoryRequest::searchFilter)).setter(setter(Builder::searchFilter))
            .constructor(ListRecordHistorySearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListRecordHistoryRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListRecordHistoryRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ACCESS_LEVEL_FILTER_FIELD, SEARCH_FILTER_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));

    private final String acceptLanguage;

    private final AccessLevelFilter accessLevelFilter;

    private final ListRecordHistorySearchFilter searchFilter;

    private final Integer pageSize;

    private final String pageToken;

    private ListRecordHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.searchFilter = builder.searchFilter;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The access level to use to obtain results. The default is <code>User</code>.
     * </p>
     * 
     * @return The access level to use to obtain results. The default is <code>User</code>.
     */
    public final AccessLevelFilter accessLevelFilter() {
        return accessLevelFilter;
    }

    /**
     * <p>
     * The search filter to scope the results.
     * </p>
     * 
     * @return The search filter to scope the results.
     */
    public final ListRecordHistorySearchFilter searchFilter() {
        return searchFilter;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(accessLevelFilter());
        hashCode = 31 * hashCode + Objects.hashCode(searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordHistoryRequest)) {
            return false;
        }
        ListRecordHistoryRequest other = (ListRecordHistoryRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(accessLevelFilter(), other.accessLevelFilter())
                && Objects.equals(searchFilter(), other.searchFilter()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecordHistoryRequest").add("AcceptLanguage", acceptLanguage())
                .add("AccessLevelFilter", accessLevelFilter()).add("SearchFilter", searchFilter()).add("PageSize", pageSize())
                .add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "AccessLevelFilter":
            return Optional.ofNullable(clazz.cast(accessLevelFilter()));
        case "SearchFilter":
            return Optional.ofNullable(clazz.cast(searchFilter()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordHistoryRequest, T> g) {
        return obj -> g.apply((ListRecordHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecordHistoryRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * 
         * @param accessLevelFilter
         *        The access level to use to obtain results. The default is <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLevelFilter(AccessLevelFilter accessLevelFilter);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessLevelFilter.Builder} avoiding the need to
         * create one manually via {@link AccessLevelFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessLevelFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLevelFilter(AccessLevelFilter)}.
         * 
         * @param accessLevelFilter
         *        a consumer that will call methods on {@link AccessLevelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLevelFilter(AccessLevelFilter)
         */
        default Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return accessLevelFilter(AccessLevelFilter.builder().applyMutation(accessLevelFilter).build());
        }

        /**
         * <p>
         * The search filter to scope the results.
         * </p>
         * 
         * @param searchFilter
         *        The search filter to scope the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchFilter(ListRecordHistorySearchFilter searchFilter);

        /**
         * <p>
         * The search filter to scope the results.
         * </p>
         * This is a convenience that creates an instance of the {@link ListRecordHistorySearchFilter.Builder} avoiding
         * the need to create one manually via {@link ListRecordHistorySearchFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListRecordHistorySearchFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #searchFilter(ListRecordHistorySearchFilter)}.
         * 
         * @param searchFilter
         *        a consumer that will call methods on {@link ListRecordHistorySearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchFilter(ListRecordHistorySearchFilter)
         */
        default Builder searchFilter(Consumer<ListRecordHistorySearchFilter.Builder> searchFilter) {
            return searchFilter(ListRecordHistorySearchFilter.builder().applyMutation(searchFilter).build());
        }

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private AccessLevelFilter accessLevelFilter;

        private ListRecordHistorySearchFilter searchFilter;

        private Integer pageSize;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordHistoryRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            accessLevelFilter(model.accessLevelFilter);
            searchFilter(model.searchFilter);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return accessLevelFilter != null ? accessLevelFilter.toBuilder() : null;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final ListRecordHistorySearchFilter.Builder getSearchFilter() {
            return searchFilter != null ? searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(ListRecordHistorySearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder searchFilter(ListRecordHistorySearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        @Transient
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecordHistoryRequest build() {
            return new ListRecordHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
