/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the portfolio share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortfolioShareDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PortfolioShareDetail.Builder, PortfolioShareDetail> {
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(PortfolioShareDetail::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PortfolioShareDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> ACCEPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Accepted").getter(getter(PortfolioShareDetail::accepted)).setter(setter(Builder::accepted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accepted").build()).build();

    private static final SdkField<Boolean> SHARE_TAG_OPTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShareTagOptions").getter(getter(PortfolioShareDetail::shareTagOptions))
            .setter(setter(Builder::shareTagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTagOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_FIELD,
            TYPE_FIELD, ACCEPTED_FIELD, SHARE_TAG_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String principalId;

    private final String type;

    private final Boolean accepted;

    private final Boolean shareTagOptions;

    private PortfolioShareDetail(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.type = builder.type;
        this.accepted = builder.accepted;
        this.shareTagOptions = builder.shareTagOptions;
    }

    /**
     * <p>
     * The identifier of the recipient entity that received the portfolio share. The recipient entities can be one of
     * the following:
     * </p>
     * <p>
     * 1. An external account.
     * </p>
     * <p>
     * 2. An organziation member account.
     * </p>
     * <p>
     * 3. An organzational unit (OU).
     * </p>
     * <p>
     * 4. The organization itself. (This shares with every account in the organization).
     * </p>
     * 
     * @return The identifier of the recipient entity that received the portfolio share. The recipient entities can be
     *         one of the following: </p>
     *         <p>
     *         1. An external account.
     *         </p>
     *         <p>
     *         2. An organziation member account.
     *         </p>
     *         <p>
     *         3. An organzational unit (OU).
     *         </p>
     *         <p>
     *         4. The organization itself. (This shares with every account in the organization).
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The type of the portfolio share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DescribePortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the portfolio share.
     * @see DescribePortfolioShareType
     */
    public final DescribePortfolioShareType type() {
        return DescribePortfolioShareType.fromValue(type);
    }

    /**
     * <p>
     * The type of the portfolio share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DescribePortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the portfolio share.
     * @see DescribePortfolioShareType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an
     * organization node, the share is automatically imported, and the field is always set to true.
     * </p>
     * 
     * @return Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an
     *         organization node, the share is automatically imported, and the field is always set to true.
     */
    public final Boolean accepted() {
        return accepted;
    }

    /**
     * <p>
     * Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
     * </p>
     * 
     * @return Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
     */
    public final Boolean shareTagOptions() {
        return shareTagOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accepted());
        hashCode = 31 * hashCode + Objects.hashCode(shareTagOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortfolioShareDetail)) {
            return false;
        }
        PortfolioShareDetail other = (PortfolioShareDetail) obj;
        return Objects.equals(principalId(), other.principalId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(accepted(), other.accepted()) && Objects.equals(shareTagOptions(), other.shareTagOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortfolioShareDetail").add("PrincipalId", principalId()).add("Type", typeAsString())
                .add("Accepted", accepted()).add("ShareTagOptions", shareTagOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Accepted":
            return Optional.ofNullable(clazz.cast(accepted()));
        case "ShareTagOptions":
            return Optional.ofNullable(clazz.cast(shareTagOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortfolioShareDetail, T> g) {
        return obj -> g.apply((PortfolioShareDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortfolioShareDetail> {
        /**
         * <p>
         * The identifier of the recipient entity that received the portfolio share. The recipient entities can be one
         * of the following:
         * </p>
         * <p>
         * 1. An external account.
         * </p>
         * <p>
         * 2. An organziation member account.
         * </p>
         * <p>
         * 3. An organzational unit (OU).
         * </p>
         * <p>
         * 4. The organization itself. (This shares with every account in the organization).
         * </p>
         * 
         * @param principalId
         *        The identifier of the recipient entity that received the portfolio share. The recipient entities can
         *        be one of the following: </p>
         *        <p>
         *        1. An external account.
         *        </p>
         *        <p>
         *        2. An organziation member account.
         *        </p>
         *        <p>
         *        3. An organzational unit (OU).
         *        </p>
         *        <p>
         *        4. The organization itself. (This shares with every account in the organization).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The type of the portfolio share.
         * </p>
         * 
         * @param type
         *        The type of the portfolio share.
         * @see DescribePortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribePortfolioShareType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the portfolio share.
         * </p>
         * 
         * @param type
         *        The type of the portfolio share.
         * @see DescribePortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribePortfolioShareType
         */
        Builder type(DescribePortfolioShareType type);

        /**
         * <p>
         * Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an
         * organization node, the share is automatically imported, and the field is always set to true.
         * </p>
         * 
         * @param accepted
         *        Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an
         *        organization node, the share is automatically imported, and the field is always set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepted(Boolean accepted);

        /**
         * <p>
         * Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
         * </p>
         * 
         * @param shareTagOptions
         *        Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareTagOptions(Boolean shareTagOptions);
    }

    static final class BuilderImpl implements Builder {
        private String principalId;

        private String type;

        private Boolean accepted;

        private Boolean shareTagOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PortfolioShareDetail model) {
            principalId(model.principalId);
            type(model.type);
            accepted(model.accepted);
            shareTagOptions(model.shareTagOptions);
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        @Transient
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DescribePortfolioShareType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getAccepted() {
            return accepted;
        }

        public final void setAccepted(Boolean accepted) {
            this.accepted = accepted;
        }

        @Override
        @Transient
        public final Builder accepted(Boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        public final Boolean getShareTagOptions() {
            return shareTagOptions;
        }

        public final void setShareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
        }

        @Override
        @Transient
        public final Builder shareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
            return this;
        }

        @Override
        public PortfolioShareDetail build() {
            return new PortfolioShareDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
