/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortfolioResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CreatePortfolioResponse.Builder, CreatePortfolioResponse> {
    private static final SdkField<PortfolioDetail> PORTFOLIO_DETAIL_FIELD = SdkField
            .<PortfolioDetail> builder(MarshallingType.SDK_POJO).memberName("PortfolioDetail")
            .getter(getter(CreatePortfolioResponse::portfolioDetail)).setter(setter(Builder::portfolioDetail))
            .constructor(PortfolioDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioDetail").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePortfolioResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_DETAIL_FIELD,
            TAGS_FIELD));

    private final PortfolioDetail portfolioDetail;

    private final List<Tag> tags;

    private CreatePortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Information about the portfolio.
     * </p>
     * 
     * @return Information about the portfolio.
     */
    public final PortfolioDetail portfolioDetail() {
        return portfolioDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tags associated with the portfolio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Information about the tags associated with the portfolio.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioResponse)) {
            return false;
        }
        CreatePortfolioResponse other = (CreatePortfolioResponse) obj;
        return Objects.equals(portfolioDetail(), other.portfolioDetail()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortfolioResponse").add("PortfolioDetail", portfolioDetail())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioDetail":
            return Optional.ofNullable(clazz.cast(portfolioDetail()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortfolioResponse, T> g) {
        return obj -> g.apply((CreatePortfolioResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortfolioResponse> {
        /**
         * <p>
         * Information about the portfolio.
         * </p>
         * 
         * @param portfolioDetail
         *        Information about the portfolio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioDetail(PortfolioDetail portfolioDetail);

        /**
         * <p>
         * Information about the portfolio.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortfolioDetail.Builder} avoiding the
         * need to create one manually via {@link PortfolioDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortfolioDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #portfolioDetail(PortfolioDetail)}.
         * 
         * @param portfolioDetail
         *        a consumer that will call methods on {@link PortfolioDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portfolioDetail(PortfolioDetail)
         */
        default Builder portfolioDetail(Consumer<PortfolioDetail.Builder> portfolioDetail) {
            return portfolioDetail(PortfolioDetail.builder().applyMutation(portfolioDetail).build());
        }

        /**
         * <p>
         * Information about the tags associated with the portfolio.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the portfolio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Information about the tags associated with the portfolio.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the portfolio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the tags associated with the portfolio.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private PortfolioDetail portfolioDetail;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioResponse model) {
            super(model);
            portfolioDetail(model.portfolioDetail);
            tags(model.tags);
        }

        public final PortfolioDetail.Builder getPortfolioDetail() {
            return portfolioDetail != null ? portfolioDetail.toBuilder() : null;
        }

        public final void setPortfolioDetail(PortfolioDetail.BuilderImpl portfolioDetail) {
            this.portfolioDetail = portfolioDetail != null ? portfolioDetail.build() : null;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreatePortfolioResponse build() {
            return new CreatePortfolioResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
