/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisioningArtifactResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CreateProvisioningArtifactResponse.Builder, CreateProvisioningArtifactResponse> {
    private static final SdkField<ProvisioningArtifactDetail> PROVISIONING_ARTIFACT_DETAIL_FIELD = SdkField
            .<ProvisioningArtifactDetail> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisioningArtifactDetail")
            .getter(getter(CreateProvisioningArtifactResponse::provisioningArtifactDetail))
            .setter(setter(Builder::provisioningArtifactDetail))
            .constructor(ProvisioningArtifactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetail").build())
            .build();

    private static final SdkField<Map<String, String>> INFO_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Info")
            .getter(getter(CreateProvisioningArtifactResponse::info))
            .setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateProvisioningArtifactResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_DETAIL_FIELD, INFO_FIELD, STATUS_FIELD));

    private final ProvisioningArtifactDetail provisioningArtifactDetail;

    private final Map<String, String> info;

    private final String status;

    private CreateProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactDetail = builder.provisioningArtifactDetail;
        this.info = builder.info;
        this.status = builder.status;
    }

    /**
     * <p>
     * Information about the provisioning artifact.
     * </p>
     * 
     * @return Information about the provisioning artifact.
     */
    public final ProvisioningArtifactDetail provisioningArtifactDetail() {
        return provisioningArtifactDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the Info property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasInfo() {
        return info != null && !(info instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specify the template source with one of the following options, but not both. Keys accepted: [
     * <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].
     * </p>
     * <p>
     * The URL of the CloudFormation template in Amazon S3, in JSON format.
     * </p>
     * <p>
     * <code>LoadTemplateFromURL</code>
     * </p>
     * <p>
     * Use the URL of the CloudFormation template in Amazon S3 in JSON format.
     * </p>
     * <p>
     * <code>ImportFromPhysicalId</code>
     * </p>
     * <p>
     * Use the physical id of the resource that contains the template; currently supports CloudFormation stack ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInfo} method.
     * </p>
     * 
     * @return Specify the template source with one of the following options, but not both. Keys accepted: [
     *         <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>
     *         <p>
     *         The URL of the CloudFormation template in Amazon S3, in JSON format.
     *         </p>
     *         <p>
     *         <code>LoadTemplateFromURL</code>
     *         </p>
     *         <p>
     *         Use the URL of the CloudFormation template in Amazon S3 in JSON format.
     *         </p>
     *         <p>
     *         <code>ImportFromPhysicalId</code>
     *         </p>
     *         <p>
     *         Use the physical id of the resource that contains the template; currently supports CloudFormation stack
     *         ARN.
     */
    public final Map<String, String> info() {
        return info;
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasInfo() ? info() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningArtifactResponse)) {
            return false;
        }
        CreateProvisioningArtifactResponse other = (CreateProvisioningArtifactResponse) obj;
        return Objects.equals(provisioningArtifactDetail(), other.provisioningArtifactDetail()) && hasInfo() == other.hasInfo()
                && Objects.equals(info(), other.info()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProvisioningArtifactResponse")
                .add("ProvisioningArtifactDetail", provisioningArtifactDetail()).add("Info", hasInfo() ? info() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactDetail":
            return Optional.ofNullable(clazz.cast(provisioningArtifactDetail()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((CreateProvisioningArtifactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProvisioningArtifactResponse> {
        /**
         * <p>
         * Information about the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactDetail
         *        Information about the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail);

        /**
         * <p>
         * Information about the provisioning artifact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningArtifactDetail.Builder}
         * avoiding the need to create one manually via {@link ProvisioningArtifactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningArtifactDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningArtifactDetail(ProvisioningArtifactDetail)}.
         * 
         * @param provisioningArtifactDetail
         *        a consumer that will call methods on {@link ProvisioningArtifactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactDetail(ProvisioningArtifactDetail)
         */
        default Builder provisioningArtifactDetail(Consumer<ProvisioningArtifactDetail.Builder> provisioningArtifactDetail) {
            return provisioningArtifactDetail(ProvisioningArtifactDetail.builder().applyMutation(provisioningArtifactDetail)
                    .build());
        }

        /**
         * <p>
         * Specify the template source with one of the following options, but not both. Keys accepted: [
         * <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].
         * </p>
         * <p>
         * The URL of the CloudFormation template in Amazon S3, in JSON format.
         * </p>
         * <p>
         * <code>LoadTemplateFromURL</code>
         * </p>
         * <p>
         * Use the URL of the CloudFormation template in Amazon S3 in JSON format.
         * </p>
         * <p>
         * <code>ImportFromPhysicalId</code>
         * </p>
         * <p>
         * Use the physical id of the resource that contains the template; currently supports CloudFormation stack ARN.
         * </p>
         * 
         * @param info
         *        Specify the template source with one of the following options, but not both. Keys accepted: [
         *        <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>
         *        <p>
         *        The URL of the CloudFormation template in Amazon S3, in JSON format.
         *        </p>
         *        <p>
         *        <code>LoadTemplateFromURL</code>
         *        </p>
         *        <p>
         *        Use the URL of the CloudFormation template in Amazon S3 in JSON format.
         *        </p>
         *        <p>
         *        <code>ImportFromPhysicalId</code>
         *        </p>
         *        <p>
         *        Use the physical id of the resource that contains the template; currently supports CloudFormation
         *        stack ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Map<String, String> info);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProvisioningArtifactDetail provisioningArtifactDetail;

        private Map<String, String> info = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningArtifactResponse model) {
            super(model);
            provisioningArtifactDetail(model.provisioningArtifactDetail);
            info(model.info);
            status(model.status);
        }

        public final ProvisioningArtifactDetail.Builder getProvisioningArtifactDetail() {
            return provisioningArtifactDetail != null ? provisioningArtifactDetail.toBuilder() : null;
        }

        public final void setProvisioningArtifactDetail(ProvisioningArtifactDetail.BuilderImpl provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail != null ? provisioningArtifactDetail.build() : null;
        }

        @Override
        public final Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail;
            return this;
        }

        public final Map<String, String> getInfo() {
            if (info instanceof SdkAutoConstructMap) {
                return null;
            }
            return info;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateProvisioningArtifactResponse build() {
            return new CreateProvisioningArtifactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
