/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProductViewResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProductViewResponse.Builder, DescribeProductViewResponse> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField
            .<ProductViewSummary> builder(MarshallingType.SDK_POJO).memberName("ProductViewSummary")
            .getter(getter(DescribeProductViewResponse::productViewSummary)).setter(setter(Builder::productViewSummary))
            .constructor(ProductViewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build())
            .build();

    private static final SdkField<List<ProvisioningArtifact>> PROVISIONING_ARTIFACTS_FIELD = SdkField
            .<List<ProvisioningArtifact>> builder(MarshallingType.LIST)
            .memberName("ProvisioningArtifacts")
            .getter(getter(DescribeProductViewResponse::provisioningArtifacts))
            .setter(setter(Builder::provisioningArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD,
            PROVISIONING_ARTIFACTS_FIELD));

    private final ProductViewSummary productViewSummary;

    private final List<ProvisioningArtifact> provisioningArtifacts;

    private DescribeProductViewResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
    }

    /**
     * <p>
     * Summary information about the product.
     * </p>
     * 
     * @return Summary information about the product.
     */
    public final ProductViewSummary productViewSummary() {
        return productViewSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningArtifacts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningArtifacts() {
        return provisioningArtifacts != null && !(provisioningArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioning artifacts for the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningArtifacts} method.
     * </p>
     * 
     * @return Information about the provisioning artifacts for the product.
     */
    public final List<ProvisioningArtifact> provisioningArtifacts() {
        return provisioningArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningArtifacts() ? provisioningArtifacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductViewResponse)) {
            return false;
        }
        DescribeProductViewResponse other = (DescribeProductViewResponse) obj;
        return Objects.equals(productViewSummary(), other.productViewSummary())
                && hasProvisioningArtifacts() == other.hasProvisioningArtifacts()
                && Objects.equals(provisioningArtifacts(), other.provisioningArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProductViewResponse").add("ProductViewSummary", productViewSummary())
                .add("ProvisioningArtifacts", hasProvisioningArtifacts() ? provisioningArtifacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewSummary":
            return Optional.ofNullable(clazz.cast(productViewSummary()));
        case "ProvisioningArtifacts":
            return Optional.ofNullable(clazz.cast(provisioningArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductViewResponse, T> g) {
        return obj -> g.apply((DescribeProductViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProductViewResponse> {
        /**
         * <p>
         * Summary information about the product.
         * </p>
         * 
         * @param productViewSummary
         *        Summary information about the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummary(ProductViewSummary productViewSummary);

        /**
         * <p>
         * Summary information about the product.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProductViewSummary.Builder} avoiding the
         * need to create one manually via {@link ProductViewSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductViewSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewSummary(ProductViewSummary)}.
         * 
         * @param productViewSummary
         *        a consumer that will call methods on {@link ProductViewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewSummary(ProductViewSummary)
         */
        default Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return productViewSummary(ProductViewSummary.builder().applyMutation(productViewSummary).build());
        }

        /**
         * <p>
         * Information about the provisioning artifacts for the product.
         * </p>
         * 
         * @param provisioningArtifacts
         *        Information about the provisioning artifacts for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts);

        /**
         * <p>
         * Information about the provisioning artifacts for the product.
         * </p>
         * 
         * @param provisioningArtifacts
         *        Information about the provisioning artifacts for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifacts(ProvisioningArtifact... provisioningArtifacts);

        /**
         * <p>
         * Information about the provisioning artifacts for the product.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProvisioningArtifact>.Builder}
         * avoiding the need to create one manually via {@link List<ProvisioningArtifact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifact>.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningArtifacts(List<ProvisioningArtifact>)}.
         * 
         * @param provisioningArtifacts
         *        a consumer that will call methods on {@link List<ProvisioningArtifact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifacts(List<ProvisioningArtifact>)
         */
        Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder>... provisioningArtifacts);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProductViewSummary productViewSummary;

        private List<ProvisioningArtifact> provisioningArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductViewResponse model) {
            super(model);
            productViewSummary(model.productViewSummary);
            provisioningArtifacts(model.provisioningArtifacts);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return productViewSummary != null ? productViewSummary.toBuilder() : null;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final List<ProvisioningArtifact.Builder> getProvisioningArtifacts() {
            List<ProvisioningArtifact.Builder> result = ProvisioningArtifactsCopier.copyToBuilder(this.provisioningArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact.BuilderImpl> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copyFromBuilder(provisioningArtifacts);
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact... provisioningArtifacts) {
            provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder>... provisioningArtifacts) {
            provisioningArtifacts(Stream.of(provisioningArtifacts)
                    .map(c -> ProvisioningArtifact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeProductViewResponse build() {
            return new DescribeProductViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
