/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningParametersRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<DescribeProvisioningParametersRequest.Builder, DescribeProvisioningParametersRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(DescribeProvisioningParametersRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(DescribeProvisioningParametersRequest::productId))
            .setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(DescribeProvisioningParametersRequest::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(DescribeProvisioningParametersRequest::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactName")
            .getter(getter(DescribeProvisioningParametersRequest::provisioningArtifactName))
            .setter(setter(Builder::provisioningArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build())
            .build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PathId")
            .getter(getter(DescribeProvisioningParametersRequest::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<String> PATH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PathName").getter(getter(DescribeProvisioningParametersRequest::pathName))
            .setter(setter(Builder::pathName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD,
            PATH_ID_FIELD, PATH_NAME_FIELD));

    private final String acceptLanguage;

    private final String productId;

    private final String productName;

    private final String provisioningArtifactId;

    private final String provisioningArtifactName;

    private final String pathId;

    private final String pathName;

    private DescribeProvisioningParametersRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier. You must provide the product name or ID, but not both.
     * </p>
     * 
     * @return The product identifier. You must provide the product name or ID, but not both.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The name of the product. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the product. You must provide the name or ID, but not both.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The identifier of the provisioning artifact. You must provide the name or ID, but not both.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The name of the provisioning artifact. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the provisioning artifact. You must provide the name or ID, but not both.
     */
    public final String provisioningArtifactName() {
        return provisioningArtifactName;
    }

    /**
     * <p>
     * The path identifier of the product. This value is optional if the product has a default path, and required if the
     * product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the
     * name or ID, but not both.
     * </p>
     * 
     * @return The path identifier of the product. This value is optional if the product has a default path, and
     *         required if the product has more than one path. To list the paths for a product, use
     *         <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.
     */
    public final String pathId() {
        return pathId;
    }

    /**
     * <p>
     * The name of the path. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the path. You must provide the name or ID, but not both.
     */
    public final String pathName() {
        return pathName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(pathName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersRequest)) {
            return false;
        }
        DescribeProvisioningParametersRequest other = (DescribeProvisioningParametersRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(productId(), other.productId())
                && Objects.equals(productName(), other.productName())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(provisioningArtifactName(), other.provisioningArtifactName())
                && Objects.equals(pathId(), other.pathId()) && Objects.equals(pathName(), other.pathName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProvisioningParametersRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProductId", productId()).add("ProductName", productName())
                .add("ProvisioningArtifactId", provisioningArtifactId())
                .add("ProvisioningArtifactName", provisioningArtifactName()).add("PathId", pathId()).add("PathName", pathName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "ProvisioningArtifactName":
            return Optional.ofNullable(clazz.cast(provisioningArtifactName()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "PathName":
            return Optional.ofNullable(clazz.cast(pathName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersRequest, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisioningParametersRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier. You must provide the product name or ID, but not both.
         * </p>
         * 
         * @param productId
         *        The product identifier. You must provide the product name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The name of the product. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param productName
         *        The name of the product. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The name of the provisioning artifact. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisioningArtifactName
         *        The name of the provisioning artifact. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactName(String provisioningArtifactName);

        /**
         * <p>
         * The path identifier of the product. This value is optional if the product has a default path, and required if
         * the product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>. You must
         * provide the name or ID, but not both.
         * </p>
         * 
         * @param pathId
         *        The path identifier of the product. This value is optional if the product has a default path, and
         *        required if the product has more than one path. To list the paths for a product, use
         *        <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * The name of the path. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param pathName
         *        The name of the path. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathName(String pathName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String productId;

        private String productName;

        private String provisioningArtifactId;

        private String provisioningArtifactName;

        private String pathId;

        private String pathName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            productId(model.productId);
            productName(model.productName);
            provisioningArtifactId(model.provisioningArtifactId);
            provisioningArtifactName(model.provisioningArtifactName);
            pathId(model.pathId);
            pathName(model.pathName);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getProvisioningArtifactName() {
            return provisioningArtifactName;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        @Override
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final String getPathId() {
            return pathId;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final String getPathName() {
            return pathName;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        @Override
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProvisioningParametersRequest build() {
            return new DescribeProvisioningParametersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
