/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceActionExecutionParametersResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<DescribeServiceActionExecutionParametersResponse.Builder, DescribeServiceActionExecutionParametersResponse> {
    private static final SdkField<List<ExecutionParameter>> SERVICE_ACTION_PARAMETERS_FIELD = SdkField
            .<List<ExecutionParameter>> builder(MarshallingType.LIST)
            .memberName("ServiceActionParameters")
            .getter(getter(DescribeServiceActionExecutionParametersResponse::serviceActionParameters))
            .setter(setter(Builder::serviceActionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_ACTION_PARAMETERS_FIELD));

    private final List<ExecutionParameter> serviceActionParameters;

    private DescribeServiceActionExecutionParametersResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionParameters = builder.serviceActionParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceActionParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasServiceActionParameters() {
        return serviceActionParameters != null && !(serviceActionParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters of the self-service action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceActionParameters} method.
     * </p>
     * 
     * @return The parameters of the self-service action.
     */
    public final List<ExecutionParameter> serviceActionParameters() {
        return serviceActionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceActionParameters() ? serviceActionParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceActionExecutionParametersResponse)) {
            return false;
        }
        DescribeServiceActionExecutionParametersResponse other = (DescribeServiceActionExecutionParametersResponse) obj;
        return hasServiceActionParameters() == other.hasServiceActionParameters()
                && Objects.equals(serviceActionParameters(), other.serviceActionParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServiceActionExecutionParametersResponse")
                .add("ServiceActionParameters", hasServiceActionParameters() ? serviceActionParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionParameters":
            return Optional.ofNullable(clazz.cast(serviceActionParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceActionExecutionParametersResponse, T> g) {
        return obj -> g.apply((DescribeServiceActionExecutionParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServiceActionExecutionParametersResponse> {
        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * 
         * @param serviceActionParameters
         *        The parameters of the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionParameters(Collection<ExecutionParameter> serviceActionParameters);

        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * 
         * @param serviceActionParameters
         *        The parameters of the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionParameters(ExecutionParameter... serviceActionParameters);

        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExecutionParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ExecutionParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceActionParameters(List<ExecutionParameter>)}.
         * 
         * @param serviceActionParameters
         *        a consumer that will call methods on {@link List<ExecutionParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionParameters(List<ExecutionParameter>)
         */
        Builder serviceActionParameters(Consumer<ExecutionParameter.Builder>... serviceActionParameters);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ExecutionParameter> serviceActionParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceActionExecutionParametersResponse model) {
            super(model);
            serviceActionParameters(model.serviceActionParameters);
        }

        public final List<ExecutionParameter.Builder> getServiceActionParameters() {
            List<ExecutionParameter.Builder> result = ExecutionParametersCopier.copyToBuilder(this.serviceActionParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceActionParameters(Collection<ExecutionParameter.BuilderImpl> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copyFromBuilder(serviceActionParameters);
        }

        @Override
        public final Builder serviceActionParameters(Collection<ExecutionParameter> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copy(serviceActionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(ExecutionParameter... serviceActionParameters) {
            serviceActionParameters(Arrays.asList(serviceActionParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(Consumer<ExecutionParameter.Builder>... serviceActionParameters) {
            serviceActionParameters(Stream.of(serviceActionParameters)
                    .map(c -> ExecutionParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServiceActionExecutionParametersResponse build() {
            return new DescribeServiceActionExecutionParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
