/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagOptionsRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ListTagOptionsRequest.Builder, ListTagOptionsRequest> {
    private static final SdkField<ListTagOptionsFilters> FILTERS_FIELD = SdkField
            .<ListTagOptionsFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListTagOptionsRequest::filters)).setter(setter(Builder::filters))
            .constructor(ListTagOptionsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListTagOptionsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListTagOptionsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));

    private final ListTagOptionsFilters filters;

    private final Integer pageSize;

    private final String pageToken;

    private ListTagOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The search filters. If no search filters are specified, the output includes all TagOptions.
     * </p>
     * 
     * @return The search filters. If no search filters are specified, the output includes all TagOptions.
     */
    public final ListTagOptionsFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagOptionsRequest)) {
            return false;
        }
        ListTagOptionsRequest other = (ListTagOptionsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagOptionsRequest").add("Filters", filters()).add("PageSize", pageSize())
                .add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagOptionsRequest, T> g) {
        return obj -> g.apply((ListTagOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTagOptionsRequest> {
        /**
         * <p>
         * The search filters. If no search filters are specified, the output includes all TagOptions.
         * </p>
         * 
         * @param filters
         *        The search filters. If no search filters are specified, the output includes all TagOptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListTagOptionsFilters filters);

        /**
         * <p>
         * The search filters. If no search filters are specified, the output includes all TagOptions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListTagOptionsFilters.Builder} avoiding
         * the need to create one manually via {@link ListTagOptionsFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListTagOptionsFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(ListTagOptionsFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ListTagOptionsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ListTagOptionsFilters)
         */
        default Builder filters(Consumer<ListTagOptionsFilters.Builder> filters) {
            return filters(ListTagOptionsFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private ListTagOptionsFilters filters;

        private Integer pageSize;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagOptionsRequest model) {
            super(model);
            filters(model.filters);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
        }

        public final ListTagOptionsFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ListTagOptionsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListTagOptionsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagOptionsRequest build() {
            return new ListTagOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
