/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceActionResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<UpdateServiceActionResponse.Builder, UpdateServiceActionResponse> {
    private static final SdkField<ServiceActionDetail> SERVICE_ACTION_DETAIL_FIELD = SdkField
            .<ServiceActionDetail> builder(MarshallingType.SDK_POJO).memberName("ServiceActionDetail")
            .getter(getter(UpdateServiceActionResponse::serviceActionDetail)).setter(setter(Builder::serviceActionDetail))
            .constructor(ServiceActionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_DETAIL_FIELD));

    private final ServiceActionDetail serviceActionDetail;

    private UpdateServiceActionResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionDetail = builder.serviceActionDetail;
    }

    /**
     * <p>
     * Detailed information about the self-service action.
     * </p>
     * 
     * @return Detailed information about the self-service action.
     */
    public final ServiceActionDetail serviceActionDetail() {
        return serviceActionDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceActionResponse)) {
            return false;
        }
        UpdateServiceActionResponse other = (UpdateServiceActionResponse) obj;
        return Objects.equals(serviceActionDetail(), other.serviceActionDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceActionResponse").add("ServiceActionDetail", serviceActionDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionDetail":
            return Optional.ofNullable(clazz.cast(serviceActionDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceActionResponse, T> g) {
        return obj -> g.apply((UpdateServiceActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceActionResponse> {
        /**
         * <p>
         * Detailed information about the self-service action.
         * </p>
         * 
         * @param serviceActionDetail
         *        Detailed information about the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionDetail(ServiceActionDetail serviceActionDetail);

        /**
         * <p>
         * Detailed information about the self-service action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceActionDetail.Builder} avoiding the
         * need to create one manually via {@link ServiceActionDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceActionDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceActionDetail(ServiceActionDetail)}.
         * 
         * @param serviceActionDetail
         *        a consumer that will call methods on {@link ServiceActionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionDetail(ServiceActionDetail)
         */
        default Builder serviceActionDetail(Consumer<ServiceActionDetail.Builder> serviceActionDetail) {
            return serviceActionDetail(ServiceActionDetail.builder().applyMutation(serviceActionDetail).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ServiceActionDetail serviceActionDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceActionResponse model) {
            super(model);
            serviceActionDetail(model.serviceActionDetail);
        }

        public final ServiceActionDetail.Builder getServiceActionDetail() {
            return serviceActionDetail != null ? serviceActionDetail.toBuilder() : null;
        }

        public final void setServiceActionDetail(ServiceActionDetail.BuilderImpl serviceActionDetail) {
            this.serviceActionDetail = serviceActionDetail != null ? serviceActionDetail.build() : null;
        }

        @Override
        public final Builder serviceActionDetail(ServiceActionDetail serviceActionDetail) {
            this.serviceActionDetail = serviceActionDetail;
            return this;
        }

        @Override
        public UpdateServiceActionResponse build() {
            return new UpdateServiceActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
