/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductViewAggregationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductViewAggregationValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ProductViewAggregationValue.getter(ProductViewAggregationValue::value)).setter(ProductViewAggregationValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Integer> APPROXIMATE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ApproximateCount").getter(ProductViewAggregationValue.getter(ProductViewAggregationValue::approximateCount)).setter(ProductViewAggregationValue.setter(Builder::approximateCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, APPROXIMATE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Integer approximateCount;

    private ProductViewAggregationValue(BuilderImpl builder) {
        this.value = builder.value;
        this.approximateCount = builder.approximateCount;
    }

    public final String value() {
        return this.value;
    }

    public final Integer approximateCount() {
        return this.approximateCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewAggregationValue)) {
            return false;
        }
        ProductViewAggregationValue other = (ProductViewAggregationValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.approximateCount(), other.approximateCount());
    }

    public final String toString() {
        return ToString.builder((String)"ProductViewAggregationValue").add("Value", (Object)this.value()).add("ApproximateCount", (Object)this.approximateCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ApproximateCount": {
                return Optional.ofNullable(clazz.cast(this.approximateCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductViewAggregationValue, T> g) {
        return obj -> g.apply((ProductViewAggregationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Integer approximateCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewAggregationValue model) {
            this.value(model.value);
            this.approximateCount(model.approximateCount);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Integer getApproximateCount() {
            return this.approximateCount;
        }

        public final void setApproximateCount(Integer approximateCount) {
            this.approximateCount = approximateCount;
        }

        @Override
        public final Builder approximateCount(Integer approximateCount) {
            this.approximateCount = approximateCount;
            return this;
        }

        public ProductViewAggregationValue build() {
            return new ProductViewAggregationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductViewAggregationValue> {
        public Builder value(String var1);

        public Builder approximateCount(Integer var1);
    }
}

