/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConstraintRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<CreateConstraintRequest.Builder, CreateConstraintRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(CreateConstraintRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(CreateConstraintRequest::portfolioId)).setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(CreateConstraintRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(CreateConstraintRequest::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateConstraintRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConstraintRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateConstraintRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, PRODUCT_ID_FIELD, PARAMETERS_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String portfolioId;

    private final String productId;

    private final String parameters;

    private final String type;

    private final String description;

    private final String idempotencyToken;

    private CreateConstraintRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.productId = builder.productId;
        this.parameters = builder.parameters;
        this.type = builder.type;
        this.description = builder.description;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
     * </p>
     * <dl>
     * <dt>LAUNCH</dt>
     * <dd>
     * <p>
     * You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.
     * </p>
     * <p>
     * Specify the <code>RoleArn</code> property as follows:
     * </p>
     * <p>
     * <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
     * </p>
     * <p>
     * Specify the <code>LocalRoleName</code> property as follows:
     * </p>
     * <p>
     * <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
     * </p>
     * <p>
     * If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role
     * with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the
     * administrator can create fewer resources per shared account.
     * </p>
     * <note>
     * <p>
     * The given role name must exist in the account used to create the launch constraint and the account of the user
     * who launches a product with this launch constraint.
     * </p>
     * </note>
     * <p>
     * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
     * </p>
     * </dd>
     * <dt>NOTIFICATION</dt>
     * <dd>
     * <p>
     * Specify the <code>NotificationArns</code> property as follows:
     * </p>
     * <p>
     * <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
     * </p>
     * </dd>
     * <dt>RESOURCE_UPDATE</dt>
     * <dd>
     * <p>
     * Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
     * </p>
     * <p>
     * <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
     * </p>
     * <p>
     * The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or
     * <code>NOT_ALLOWED</code>.
     * </p>
     * </dd>
     * <dt>STACKSET</dt>
     * <dd>
     * <p>
     * Specify the <code>Parameters</code> property as follows:
     * </p>
     * <p>
     * <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
     * </p>
     * <p>
     * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
     * </p>
     * <p>
     * Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
     * </p>
     * </dd>
     * <dt>TEMPLATE</dt>
     * <dd>
     * <p>
     * Specify the <code>Rules</code> property. For more information, see <a
     * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
     * >Template Constraint Rules</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
     *         <dl>
     *         <dt>LAUNCH</dt>
     *         <dd>
     *         <p>
     *         You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't
     *         use both.
     *         </p>
     *         <p>
     *         Specify the <code>RoleArn</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
     *         </p>
     *         <p>
     *         Specify the <code>LocalRoleName</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
     *         </p>
     *         <p>
     *         If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the
     *         IAM role with that name in the account will be used. This allows launch-role constraints to be
     *         account-agnostic so the administrator can create fewer resources per shared account.
     *         </p>
     *         <note>
     *         <p>
     *         The given role name must exist in the account used to create the launch constraint and the account of the
     *         user who launches a product with this launch constraint.
     *         </p>
     *         </note>
     *         <p>
     *         You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     *         </p>
     *         <p>
     *         You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
     *         </p>
     *         </dd>
     *         <dt>NOTIFICATION</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>NotificationArns</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
     *         </p>
     *         </dd>
     *         <dt>RESOURCE_UPDATE</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
     *         </p>
     *         <p>
     *         The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code>
     *         or <code>NOT_ALLOWED</code>.
     *         </p>
     *         </dd>
     *         <dt>STACKSET</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>Parameters</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
     *         </p>
     *         <p>
     *         You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     *         </p>
     *         <p>
     *         You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
     *         </p>
     *         <p>
     *         Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
     *         </p>
     *         </dd>
     *         <dt>TEMPLATE</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>Rules</code> property. For more information, see <a
     *         href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
     *         >Template Constraint Rules</a>.
     *         </p>
     *         </dd>
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of constraint.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LAUNCH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTIFICATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE_UPDATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STACKSET</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPLATE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of constraint.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LAUNCH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTIFICATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE_UPDATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STACKSET</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPLATE</code>
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The description of the constraint.
     * </p>
     * 
     * @return The description of the constraint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency
     * token, the same response is returned for each repeated request.
     * </p>
     * 
     * @return A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
     *         idempotency token, the same response is returned for each repeated request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConstraintRequest)) {
            return false;
        }
        CreateConstraintRequest other = (CreateConstraintRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(productId(), other.productId()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(type(), other.type()) && Objects.equals(description(), other.description())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConstraintRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("ProductId", productId()).add("Parameters", parameters())
                .add("Type", type()).add("Description", description()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConstraintRequest, T> g) {
        return obj -> g.apply((CreateConstraintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConstraintRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param productId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
         * </p>
         * <dl>
         * <dt>LAUNCH</dt>
         * <dd>
         * <p>
         * You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use
         * both.
         * </p>
         * <p>
         * Specify the <code>RoleArn</code> property as follows:
         * </p>
         * <p>
         * <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
         * </p>
         * <p>
         * Specify the <code>LocalRoleName</code> property as follows:
         * </p>
         * <p>
         * <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
         * </p>
         * <p>
         * If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM
         * role with that name in the account will be used. This allows launch-role constraints to be account-agnostic
         * so the administrator can create fewer resources per shared account.
         * </p>
         * <note>
         * <p>
         * The given role name must exist in the account used to create the launch constraint and the account of the
         * user who launches a product with this launch constraint.
         * </p>
         * </note>
         * <p>
         * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         * </p>
         * <p>
         * You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
         * </p>
         * </dd>
         * <dt>NOTIFICATION</dt>
         * <dd>
         * <p>
         * Specify the <code>NotificationArns</code> property as follows:
         * </p>
         * <p>
         * <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
         * </p>
         * </dd>
         * <dt>RESOURCE_UPDATE</dt>
         * <dd>
         * <p>
         * Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
         * </p>
         * <p>
         * <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
         * </p>
         * <p>
         * The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or
         * <code>NOT_ALLOWED</code>.
         * </p>
         * </dd>
         * <dt>STACKSET</dt>
         * <dd>
         * <p>
         * Specify the <code>Parameters</code> property as follows:
         * </p>
         * <p>
         * <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
         * </p>
         * <p>
         * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         * </p>
         * <p>
         * You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
         * </p>
         * <p>
         * Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
         * </p>
         * </dd>
         * <dt>TEMPLATE</dt>
         * <dd>
         * <p>
         * Specify the <code>Rules</code> property. For more information, see <a
         * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
         * >Template Constraint Rules</a>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param parameters
         *        The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
         *        <dl>
         *        <dt>LAUNCH</dt>
         *        <dd>
         *        <p>
         *        You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but
         *        can't use both.
         *        </p>
         *        <p>
         *        Specify the <code>RoleArn</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
         *        </p>
         *        <p>
         *        Specify the <code>LocalRoleName</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
         *        </p>
         *        <p>
         *        If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint,
         *        the IAM role with that name in the account will be used. This allows launch-role constraints to be
         *        account-agnostic so the administrator can create fewer resources per shared account.
         *        </p>
         *        <note>
         *        <p>
         *        The given role name must exist in the account used to create the launch constraint and the account of
         *        the user who launches a product with this launch constraint.
         *        </p>
         *        </note>
         *        <p>
         *        You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         *        </p>
         *        <p>
         *        You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
         *        </p>
         *        </dd>
         *        <dt>NOTIFICATION</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>NotificationArns</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
         *        </p>
         *        </dd>
         *        <dt>RESOURCE_UPDATE</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
         *        </p>
         *        <p>
         *        The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of
         *        <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.
         *        </p>
         *        </dd>
         *        <dt>STACKSET</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>Parameters</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
         *        </p>
         *        <p>
         *        You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         *        </p>
         *        <p>
         *        You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
         *        </p>
         *        <p>
         *        Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
         *        </p>
         *        </dd>
         *        <dt>TEMPLATE</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>Rules</code> property. For more information, see <a
         *        href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
         *        >Template Constraint Rules</a>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The type of constraint.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LAUNCH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTIFICATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE_UPDATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STACKSET</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPLATE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of constraint.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LAUNCH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTIFICATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE_UPDATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STACKSET</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPLATE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The description of the constraint.
         * </p>
         * 
         * @param description
         *        The description of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         * idempotency token, the same response is returned for each repeated request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         *        idempotency token, the same response is returned for each repeated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String productId;

        private String parameters;

        private String type;

        private String description;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConstraintRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            productId(model.productId);
            parameters(model.parameters);
            type(model.type);
            description(model.description);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConstraintRequest build() {
            return new CreateConstraintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
