/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisioningArtifactsForServiceActionRequest extends ServiceCatalogRequest
        implements
        ToCopyableBuilder<ListProvisioningArtifactsForServiceActionRequest.Builder, ListProvisioningArtifactsForServiceActionRequest> {
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceActionId").getter(getter(ListProvisioningArtifactsForServiceActionRequest::serviceActionId))
            .setter(setter(Builder::serviceActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListProvisioningArtifactsForServiceActionRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListProvisioningArtifactsForServiceActionRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ListProvisioningArtifactsForServiceActionRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ID_FIELD,
            PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD, ACCEPT_LANGUAGE_FIELD));

    private final String serviceActionId;

    private final Integer pageSize;

    private final String pageToken;

    private final String acceptLanguage;

    private ListProvisioningArtifactsForServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.serviceActionId = builder.serviceActionId;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.acceptLanguage = builder.acceptLanguage;
    }

    /**
     * <p>
     * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     * </p>
     * 
     * @return The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     */
    public final String serviceActionId() {
        return serviceActionId;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsForServiceActionRequest)) {
            return false;
        }
        ListProvisioningArtifactsForServiceActionRequest other = (ListProvisioningArtifactsForServiceActionRequest) obj;
        return Objects.equals(serviceActionId(), other.serviceActionId()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(pageToken(), other.pageToken()) && Objects.equals(acceptLanguage(), other.acceptLanguage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProvisioningArtifactsForServiceActionRequest").add("ServiceActionId", serviceActionId())
                .add("PageSize", pageSize()).add("PageToken", pageToken()).add("AcceptLanguage", acceptLanguage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionId":
            return Optional.ofNullable(clazz.cast(serviceActionId()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningArtifactsForServiceActionRequest, T> g) {
        return obj -> g.apply((ListProvisioningArtifactsForServiceActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisioningArtifactsForServiceActionRequest> {
        /**
         * <p>
         * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * </p>
         * 
         * @param serviceActionId
         *        The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionId(String serviceActionId);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String serviceActionId;

        private Integer pageSize;

        private String pageToken;

        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsForServiceActionRequest model) {
            super(model);
            serviceActionId(model.serviceActionId);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
            acceptLanguage(model.acceptLanguage);
        }

        public final String getServiceActionId() {
            return serviceActionId;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProvisioningArtifactsForServiceActionRequest build() {
            return new ListProvisioningArtifactsForServiceActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
