/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareType;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePortfolioSharesRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DescribePortfolioSharesRequest> {
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioId").getter(DescribePortfolioSharesRequest.getter(DescribePortfolioSharesRequest::portfolioId)).setter(DescribePortfolioSharesRequest.setter(Builder::portfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribePortfolioSharesRequest.getter(DescribePortfolioSharesRequest::typeAsString)).setter(DescribePortfolioSharesRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(DescribePortfolioSharesRequest.getter(DescribePortfolioSharesRequest::pageToken)).setter(DescribePortfolioSharesRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(DescribePortfolioSharesRequest.getter(DescribePortfolioSharesRequest::pageSize)).setter(DescribePortfolioSharesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_ID_FIELD, TYPE_FIELD, PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD));
    private final String portfolioId;
    private final String type;
    private final String pageToken;
    private final Integer pageSize;

    private DescribePortfolioSharesRequest(BuilderImpl builder) {
        super(builder);
        this.portfolioId = builder.portfolioId;
        this.type = builder.type;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
    }

    public final String portfolioId() {
        return this.portfolioId;
    }

    public final DescribePortfolioShareType type() {
        return DescribePortfolioShareType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioSharesRequest)) {
            return false;
        }
        DescribePortfolioSharesRequest other = (DescribePortfolioSharesRequest)((Object)obj);
        return Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePortfolioSharesRequest").add("PortfolioId", (Object)this.portfolioId()).add("Type", (Object)this.typeAsString()).add("PageToken", (Object)this.pageToken()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioSharesRequest, T> g) {
        return obj -> g.apply((DescribePortfolioSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String portfolioId;
        private String type;
        private String pageToken;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioSharesRequest model) {
            super(model);
            this.portfolioId(model.portfolioId);
            this.type(model.type);
            this.pageToken(model.pageToken);
            this.pageSize(model.pageSize);
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        @Transient
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DescribePortfolioShareType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        @Transient
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePortfolioSharesRequest build() {
            return new DescribePortfolioSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePortfolioSharesRequest> {
        public Builder portfolioId(String var1);

        public Builder type(String var1);

        public Builder type(DescribePortfolioShareType var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

