/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<CopyProductRequest.Builder, CopyProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(CopyProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> SOURCE_PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceProductArn").getter(getter(CopyProductRequest::sourceProductArn))
            .setter(setter(Builder::sourceProductArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProductArn").build()).build();

    private static final SdkField<String> TARGET_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetProductId").getter(getter(CopyProductRequest::targetProductId))
            .setter(setter(Builder::targetProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProductId").build()).build();

    private static final SdkField<String> TARGET_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetProductName").getter(getter(CopyProductRequest::targetProductName))
            .setter(setter(Builder::targetProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProductName").build()).build();

    private static final SdkField<List<Map<String, String>>> SOURCE_PROVISIONING_ARTIFACT_IDENTIFIERS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("SourceProvisioningArtifactIdentifiers")
            .getter(getter(CopyProductRequest::sourceProvisioningArtifactIdentifiersAsStrings))
            .setter(setter(Builder::sourceProvisioningArtifactIdentifiersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SourceProvisioningArtifactIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> COPY_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CopyOptions")
            .getter(getter(CopyProductRequest::copyOptionsAsStrings))
            .setter(setter(Builder::copyOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CopyProductRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            SOURCE_PRODUCT_ARN_FIELD, TARGET_PRODUCT_ID_FIELD, TARGET_PRODUCT_NAME_FIELD,
            SOURCE_PROVISIONING_ARTIFACT_IDENTIFIERS_FIELD, COPY_OPTIONS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String sourceProductArn;

    private final String targetProductId;

    private final String targetProductName;

    private final List<Map<String, String>> sourceProvisioningArtifactIdentifiers;

    private final List<String> copyOptions;

    private final String idempotencyToken;

    private CopyProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.sourceProductArn = builder.sourceProductArn;
        this.targetProductId = builder.targetProductId;
        this.targetProductName = builder.targetProductName;
        this.sourceProvisioningArtifactIdentifiers = builder.sourceProvisioningArtifactIdentifiers;
        this.copyOptions = builder.copyOptions;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source product.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source product.
     */
    public final String sourceProductArn() {
        return sourceProductArn;
    }

    /**
     * <p>
     * The identifier of the target product. By default, a new product is created.
     * </p>
     * 
     * @return The identifier of the target product. By default, a new product is created.
     */
    public final String targetProductId() {
        return targetProductId;
    }

    /**
     * <p>
     * A name for the target product. The default is the name of the source product.
     * </p>
     * 
     * @return A name for the target product. The default is the name of the source product.
     */
    public final String targetProductName() {
        return targetProductName;
    }

    /**
     * <p>
     * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all
     * provisioning artifacts are copied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceProvisioningArtifactIdentifiers}
     * method.
     * </p>
     * 
     * @return The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By
     *         default, all provisioning artifacts are copied.
     */
    public final List<Map<ProvisioningArtifactPropertyName, String>> sourceProvisioningArtifactIdentifiers() {
        return SourceProvisioningArtifactPropertiesCopier.copyStringToEnum(sourceProvisioningArtifactIdentifiers);
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceProvisioningArtifactIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSourceProvisioningArtifactIdentifiers() {
        return sourceProvisioningArtifactIdentifiers != null
                && !(sourceProvisioningArtifactIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all
     * provisioning artifacts are copied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceProvisioningArtifactIdentifiers}
     * method.
     * </p>
     * 
     * @return The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By
     *         default, all provisioning artifacts are copied.
     */
    public final List<Map<String, String>> sourceProvisioningArtifactIdentifiersAsStrings() {
        return sourceProvisioningArtifactIdentifiers;
    }

    /**
     * <p>
     * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
     * target product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCopyOptions} method.
     * </p>
     * 
     * @return The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to
     *         the target product.
     */
    public final List<CopyOption> copyOptions() {
        return CopyOptionsCopier.copyStringToEnum(copyOptions);
    }

    /**
     * For responses, this returns true if the service returned a value for the CopyOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCopyOptions() {
        return copyOptions != null && !(copyOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
     * target product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCopyOptions} method.
     * </p>
     * 
     * @return The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to
     *         the target product.
     */
    public final List<String> copyOptionsAsStrings() {
        return copyOptions;
    }

    /**
     * <p>
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency
     * token, the same response is returned for each repeated request.
     * </p>
     * 
     * @return A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
     *         idempotency token, the same response is returned for each repeated request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProductArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetProductId());
        hashCode = 31 * hashCode + Objects.hashCode(targetProductName());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasSourceProvisioningArtifactIdentifiers() ? sourceProvisioningArtifactIdentifiersAsStrings()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCopyOptions() ? copyOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProductRequest)) {
            return false;
        }
        CopyProductRequest other = (CopyProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(sourceProductArn(), other.sourceProductArn())
                && Objects.equals(targetProductId(), other.targetProductId())
                && Objects.equals(targetProductName(), other.targetProductName())
                && hasSourceProvisioningArtifactIdentifiers() == other.hasSourceProvisioningArtifactIdentifiers()
                && Objects.equals(sourceProvisioningArtifactIdentifiersAsStrings(),
                        other.sourceProvisioningArtifactIdentifiersAsStrings()) && hasCopyOptions() == other.hasCopyOptions()
                && Objects.equals(copyOptionsAsStrings(), other.copyOptionsAsStrings())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CopyProductRequest")
                .add("AcceptLanguage", acceptLanguage())
                .add("SourceProductArn", sourceProductArn())
                .add("TargetProductId", targetProductId())
                .add("TargetProductName", targetProductName())
                .add("SourceProvisioningArtifactIdentifiers",
                        hasSourceProvisioningArtifactIdentifiers() ? sourceProvisioningArtifactIdentifiersAsStrings() : null)
                .add("CopyOptions", hasCopyOptions() ? copyOptionsAsStrings() : null).add("IdempotencyToken", idempotencyToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "SourceProductArn":
            return Optional.ofNullable(clazz.cast(sourceProductArn()));
        case "TargetProductId":
            return Optional.ofNullable(clazz.cast(targetProductId()));
        case "TargetProductName":
            return Optional.ofNullable(clazz.cast(targetProductName()));
        case "SourceProvisioningArtifactIdentifiers":
            return Optional.ofNullable(clazz.cast(sourceProvisioningArtifactIdentifiersAsStrings()));
        case "CopyOptions":
            return Optional.ofNullable(clazz.cast(copyOptionsAsStrings()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyProductRequest, T> g) {
        return obj -> g.apply((CopyProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source product.
         * </p>
         * 
         * @param sourceProductArn
         *        The Amazon Resource Name (ARN) of the source product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProductArn(String sourceProductArn);

        /**
         * <p>
         * The identifier of the target product. By default, a new product is created.
         * </p>
         * 
         * @param targetProductId
         *        The identifier of the target product. By default, a new product is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetProductId(String targetProductId);

        /**
         * <p>
         * A name for the target product. The default is the name of the source product.
         * </p>
         * 
         * @param targetProductName
         *        A name for the target product. The default is the name of the source product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetProductName(String targetProductName);

        /**
         * <p>
         * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default,
         * all provisioning artifacts are copied.
         * </p>
         * 
         * @param sourceProvisioningArtifactIdentifiers
         *        The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By
         *        default, all provisioning artifacts are copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProvisioningArtifactIdentifiersWithStrings(
                Collection<? extends Map<String, String>> sourceProvisioningArtifactIdentifiers);

        /**
         * <p>
         * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default,
         * all provisioning artifacts are copied.
         * </p>
         * 
         * @param sourceProvisioningArtifactIdentifiers
         *        The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By
         *        default, all provisioning artifacts are copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProvisioningArtifactIdentifiersWithStrings(Map<String, String>... sourceProvisioningArtifactIdentifiers);

        /**
         * <p>
         * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
         * target product.
         * </p>
         * 
         * @param copyOptions
         *        The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied
         *        to the target product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptionsWithStrings(Collection<String> copyOptions);

        /**
         * <p>
         * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
         * target product.
         * </p>
         * 
         * @param copyOptions
         *        The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied
         *        to the target product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptionsWithStrings(String... copyOptions);

        /**
         * <p>
         * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
         * target product.
         * </p>
         * 
         * @param copyOptions
         *        The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied
         *        to the target product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptions(Collection<CopyOption> copyOptions);

        /**
         * <p>
         * The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the
         * target product.
         * </p>
         * 
         * @param copyOptions
         *        The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied
         *        to the target product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptions(CopyOption... copyOptions);

        /**
         * <p>
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         * idempotency token, the same response is returned for each repeated request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         *        idempotency token, the same response is returned for each repeated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String sourceProductArn;

        private String targetProductId;

        private String targetProductName;

        private List<Map<String, String>> sourceProvisioningArtifactIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> copyOptions = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            sourceProductArn(model.sourceProductArn);
            targetProductId(model.targetProductId);
            targetProductName(model.targetProductName);
            sourceProvisioningArtifactIdentifiersWithStrings(model.sourceProvisioningArtifactIdentifiers);
            copyOptionsWithStrings(model.copyOptions);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getSourceProductArn() {
            return sourceProductArn;
        }

        public final void setSourceProductArn(String sourceProductArn) {
            this.sourceProductArn = sourceProductArn;
        }

        @Override
        @Transient
        public final Builder sourceProductArn(String sourceProductArn) {
            this.sourceProductArn = sourceProductArn;
            return this;
        }

        public final String getTargetProductId() {
            return targetProductId;
        }

        public final void setTargetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
        }

        @Override
        @Transient
        public final Builder targetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
            return this;
        }

        public final String getTargetProductName() {
            return targetProductName;
        }

        public final void setTargetProductName(String targetProductName) {
            this.targetProductName = targetProductName;
        }

        @Override
        @Transient
        public final Builder targetProductName(String targetProductName) {
            this.targetProductName = targetProductName;
            return this;
        }

        public final Collection<? extends Map<String, String>> getSourceProvisioningArtifactIdentifiers() {
            if (sourceProvisioningArtifactIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceProvisioningArtifactIdentifiers;
        }

        public final void setSourceProvisioningArtifactIdentifiers(
                Collection<? extends Map<String, String>> sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactPropertiesCopier
                    .copy(sourceProvisioningArtifactIdentifiers);
        }

        @Override
        @Transient
        public final Builder sourceProvisioningArtifactIdentifiersWithStrings(
                Collection<? extends Map<String, String>> sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactPropertiesCopier
                    .copy(sourceProvisioningArtifactIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceProvisioningArtifactIdentifiersWithStrings(
                Map<String, String>... sourceProvisioningArtifactIdentifiers) {
            sourceProvisioningArtifactIdentifiersWithStrings(Arrays.asList(sourceProvisioningArtifactIdentifiers));
            return this;
        }

        public final Collection<String> getCopyOptions() {
            if (copyOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return copyOptions;
        }

        public final void setCopyOptions(Collection<String> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copy(copyOptions);
        }

        @Override
        @Transient
        public final Builder copyOptionsWithStrings(Collection<String> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copy(copyOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder copyOptionsWithStrings(String... copyOptions) {
            copyOptionsWithStrings(Arrays.asList(copyOptions));
            return this;
        }

        @Override
        @Transient
        public final Builder copyOptions(Collection<CopyOption> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copyEnumToString(copyOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder copyOptions(CopyOption... copyOptions) {
            copyOptions(Arrays.asList(copyOptions));
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyProductRequest build() {
            return new CopyProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
