/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about the error, along with identifying information about the self-service action
 * and its associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedServiceActionAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedServiceActionAssociation.Builder, FailedServiceActionAssociation> {
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceActionId").getter(getter(FailedServiceActionAssociation::serviceActionId))
            .setter(setter(Builder::serviceActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(FailedServiceActionAssociation::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(FailedServiceActionAssociation::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(FailedServiceActionAssociation::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(FailedServiceActionAssociation::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ID_FIELD,
            PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceActionId;

    private final String productId;

    private final String provisioningArtifactId;

    private final String errorCode;

    private final String errorMessage;

    private FailedServiceActionAssociation(BuilderImpl builder) {
        this.serviceActionId = builder.serviceActionId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     * </p>
     * 
     * @return The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     */
    public final String serviceActionId() {
        return serviceActionId;
    }

    /**
     * <p>
     * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     * </p>
     * 
     * @return The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     * </p>
     * 
     * @return The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The error code. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ServiceActionAssociationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code. Valid values are listed below.
     * @see ServiceActionAssociationErrorCode
     */
    public final ServiceActionAssociationErrorCode errorCode() {
        return ServiceActionAssociationErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ServiceActionAssociationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code. Valid values are listed below.
     * @see ServiceActionAssociationErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * A text description of the error.
     * </p>
     * 
     * @return A text description of the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedServiceActionAssociation)) {
            return false;
        }
        FailedServiceActionAssociation other = (FailedServiceActionAssociation) obj;
        return Objects.equals(serviceActionId(), other.serviceActionId()) && Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedServiceActionAssociation").add("ServiceActionId", serviceActionId())
                .add("ProductId", productId()).add("ProvisioningArtifactId", provisioningArtifactId())
                .add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionId":
            return Optional.ofNullable(clazz.cast(serviceActionId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedServiceActionAssociation, T> g) {
        return obj -> g.apply((FailedServiceActionAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedServiceActionAssociation> {
        /**
         * <p>
         * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * </p>
         * 
         * @param serviceActionId
         *        The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionId(String serviceActionId);

        /**
         * <p>
         * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * </p>
         * 
         * @param productId
         *        The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The error code. Valid values are listed below.
         * </p>
         * 
         * @param errorCode
         *        The error code. Valid values are listed below.
         * @see ServiceActionAssociationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionAssociationErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code. Valid values are listed below.
         * </p>
         * 
         * @param errorCode
         *        The error code. Valid values are listed below.
         * @see ServiceActionAssociationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionAssociationErrorCode
         */
        Builder errorCode(ServiceActionAssociationErrorCode errorCode);

        /**
         * <p>
         * A text description of the error.
         * </p>
         * 
         * @param errorMessage
         *        A text description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String serviceActionId;

        private String productId;

        private String provisioningArtifactId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedServiceActionAssociation model) {
            serviceActionId(model.serviceActionId);
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getServiceActionId() {
            return serviceActionId;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        @Override
        @Transient
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        @Transient
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        @Transient
        public final Builder errorCode(ServiceActionAssociationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedServiceActionAssociation build() {
            return new FailedServiceActionAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
