/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConstraintsForPortfolioResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListConstraintsForPortfolioResponse.Builder, ListConstraintsForPortfolioResponse> {
    private static final SdkField<List<ConstraintDetail>> CONSTRAINT_DETAILS_FIELD = SdkField
            .<List<ConstraintDetail>> builder(MarshallingType.LIST)
            .memberName("ConstraintDetails")
            .getter(getter(ListConstraintsForPortfolioResponse::constraintDetails))
            .setter(setter(Builder::constraintDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConstraintDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConstraintDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListConstraintsForPortfolioResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_DETAILS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<ConstraintDetail> constraintDetails;

    private final String nextPageToken;

    private ListConstraintsForPortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.constraintDetails = builder.constraintDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConstraintDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConstraintDetails() {
        return constraintDetails != null && !(constraintDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the constraints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConstraintDetails} method.
     * </p>
     * 
     * @return Information about the constraints.
     */
    public final List<ConstraintDetail> constraintDetails() {
        return constraintDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConstraintDetails() ? constraintDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConstraintsForPortfolioResponse)) {
            return false;
        }
        ListConstraintsForPortfolioResponse other = (ListConstraintsForPortfolioResponse) obj;
        return hasConstraintDetails() == other.hasConstraintDetails()
                && Objects.equals(constraintDetails(), other.constraintDetails())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConstraintsForPortfolioResponse")
                .add("ConstraintDetails", hasConstraintDetails() ? constraintDetails() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstraintDetails":
            return Optional.ofNullable(clazz.cast(constraintDetails()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConstraintsForPortfolioResponse, T> g) {
        return obj -> g.apply((ListConstraintsForPortfolioResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
        /**
         * <p>
         * Information about the constraints.
         * </p>
         * 
         * @param constraintDetails
         *        Information about the constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintDetails(Collection<ConstraintDetail> constraintDetails);

        /**
         * <p>
         * Information about the constraints.
         * </p>
         * 
         * @param constraintDetails
         *        Information about the constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintDetails(ConstraintDetail... constraintDetails);

        /**
         * <p>
         * Information about the constraints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConstraintDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ConstraintDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConstraintDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #constraintDetails(List<ConstraintDetail>)}.
         * 
         * @param constraintDetails
         *        a consumer that will call methods on {@link List<ConstraintDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintDetails(List<ConstraintDetail>)
         */
        Builder constraintDetails(Consumer<ConstraintDetail.Builder>... constraintDetails);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ConstraintDetail> constraintDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConstraintsForPortfolioResponse model) {
            super(model);
            constraintDetails(model.constraintDetails);
            nextPageToken(model.nextPageToken);
        }

        public final List<ConstraintDetail.Builder> getConstraintDetails() {
            List<ConstraintDetail.Builder> result = ConstraintDetailsCopier.copyToBuilder(this.constraintDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConstraintDetails(Collection<ConstraintDetail.BuilderImpl> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copyFromBuilder(constraintDetails);
        }

        @Override
        @Transient
        public final Builder constraintDetails(Collection<ConstraintDetail> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copy(constraintDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder constraintDetails(ConstraintDetail... constraintDetails) {
            constraintDetails(Arrays.asList(constraintDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder constraintDetails(Consumer<ConstraintDetail.Builder>... constraintDetails) {
            constraintDetails(Stream.of(constraintDetails).map(c -> ConstraintDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListConstraintsForPortfolioResponse build() {
            return new ListConstraintsForPortfolioResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
