/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The constraints that the administrator has put on the parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterConstraints implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterConstraints.Builder, ParameterConstraints> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedValues")
            .getter(getter(ParameterConstraints::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedPattern").getter(getter(ParameterConstraints::allowedPattern))
            .setter(setter(Builder::allowedPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPattern").build()).build();

    private static final SdkField<String> CONSTRAINT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstraintDescription").getter(getter(ParameterConstraints::constraintDescription))
            .setter(setter(Builder::constraintDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDescription").build())
            .build();

    private static final SdkField<String> MAX_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxLength").getter(getter(ParameterConstraints::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()).build();

    private static final SdkField<String> MIN_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinLength").getter(getter(ParameterConstraints::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()).build();

    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxValue").getter(getter(ParameterConstraints::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinValue").getter(getter(ParameterConstraints::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD,
            ALLOWED_PATTERN_FIELD, CONSTRAINT_DESCRIPTION_FIELD, MAX_LENGTH_FIELD, MIN_LENGTH_FIELD, MAX_VALUE_FIELD,
            MIN_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> allowedValues;

    private final String allowedPattern;

    private final String constraintDescription;

    private final String maxLength;

    private final String minLength;

    private final String maxValue;

    private final String minValue;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.allowedPattern = builder.allowedPattern;
        this.constraintDescription = builder.constraintDescription;
        this.maxLength = builder.maxLength;
        this.minLength = builder.minLength;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that the administrator has allowed for the parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return The values that the administrator has allowed for the parameter.
     */
    public final List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * A regular expression that represents the patterns that allow for <code>String</code> types. The pattern must
     * match the entire parameter value provided.
     * </p>
     * 
     * @return A regular expression that represents the patterns that allow for <code>String</code> types. The pattern
     *         must match the entire parameter value provided.
     */
    public final String allowedPattern() {
        return allowedPattern;
    }

    /**
     * <p>
     * A string that explains a constraint when the constraint is violated. For example, without a constraint
     * description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following error
     * message when the user specifies an invalid value:
     * </p>
     * <p>
     * <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
     * </p>
     * <p>
     * By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you
     * can display the following customized error message:
     * </p>
     * <p>
     * <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
     * </p>
     * 
     * @return A string that explains a constraint when the constraint is violated. For example, without a constraint
     *         description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following
     *         error message when the user specifies an invalid value:</p>
     *         <p>
     *         <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
     *         </p>
     *         <p>
     *         By adding a constraint description, such as must only contain letters (uppercase and lowercase) and
     *         numbers, you can display the following customized error message:
     *         </p>
     *         <p>
     *         <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
     */
    public final String constraintDescription() {
        return constraintDescription;
    }

    /**
     * <p>
     * An integer value that determines the largest number of characters you want to allow for <code>String</code>
     * types.
     * </p>
     * 
     * @return An integer value that determines the largest number of characters you want to allow for
     *         <code>String</code> types.
     */
    public final String maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * An integer value that determines the smallest number of characters you want to allow for <code>String</code>
     * types.
     * </p>
     * 
     * @return An integer value that determines the smallest number of characters you want to allow for
     *         <code>String</code> types.
     */
    public final String minLength() {
        return minLength;
    }

    /**
     * <p>
     * A numeric value that determines the largest numeric value you want to allow for <code>Number</code> types.
     * </p>
     * 
     * @return A numeric value that determines the largest numeric value you want to allow for <code>Number</code>
     *         types.
     */
    public final String maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * A numeric value that determines the smallest numeric value you want to allow for <code>Number</code> types.
     * </p>
     * 
     * @return A numeric value that determines the smallest numeric value you want to allow for <code>Number</code>
     *         types.
     */
    public final String minValue() {
        return minValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(constraintDescription());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints) obj;
        return hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(allowedPattern(), other.allowedPattern())
                && Objects.equals(constraintDescription(), other.constraintDescription())
                && Objects.equals(maxLength(), other.maxLength()) && Objects.equals(minLength(), other.minLength())
                && Objects.equals(maxValue(), other.maxValue()) && Objects.equals(minValue(), other.minValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterConstraints").add("AllowedValues", hasAllowedValues() ? allowedValues() : null)
                .add("AllowedPattern", allowedPattern()).add("ConstraintDescription", constraintDescription())
                .add("MaxLength", maxLength()).add("MinLength", minLength()).add("MaxValue", maxValue())
                .add("MinValue", minValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "AllowedPattern":
            return Optional.ofNullable(clazz.cast(allowedPattern()));
        case "ConstraintDescription":
            return Optional.ofNullable(clazz.cast(constraintDescription()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterConstraints, T> g) {
        return obj -> g.apply((ParameterConstraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterConstraints> {
        /**
         * <p>
         * The values that the administrator has allowed for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        The values that the administrator has allowed for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * The values that the administrator has allowed for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        The values that the administrator has allowed for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * A regular expression that represents the patterns that allow for <code>String</code> types. The pattern must
         * match the entire parameter value provided.
         * </p>
         * 
         * @param allowedPattern
         *        A regular expression that represents the patterns that allow for <code>String</code> types. The
         *        pattern must match the entire parameter value provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPattern(String allowedPattern);

        /**
         * <p>
         * A string that explains a constraint when the constraint is violated. For example, without a constraint
         * description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following
         * error message when the user specifies an invalid value:
         * </p>
         * <p>
         * <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
         * </p>
         * <p>
         * By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers,
         * you can display the following customized error message:
         * </p>
         * <p>
         * <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
         * </p>
         * 
         * @param constraintDescription
         *        A string that explains a constraint when the constraint is violated. For example, without a constraint
         *        description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the
         *        following error message when the user specifies an invalid value:</p>
         *        <p>
         *        <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
         *        </p>
         *        <p>
         *        By adding a constraint description, such as must only contain letters (uppercase and lowercase) and
         *        numbers, you can display the following customized error message:
         *        </p>
         *        <p>
         *        <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintDescription(String constraintDescription);

        /**
         * <p>
         * An integer value that determines the largest number of characters you want to allow for <code>String</code>
         * types.
         * </p>
         * 
         * @param maxLength
         *        An integer value that determines the largest number of characters you want to allow for
         *        <code>String</code> types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(String maxLength);

        /**
         * <p>
         * An integer value that determines the smallest number of characters you want to allow for <code>String</code>
         * types.
         * </p>
         * 
         * @param minLength
         *        An integer value that determines the smallest number of characters you want to allow for
         *        <code>String</code> types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(String minLength);

        /**
         * <p>
         * A numeric value that determines the largest numeric value you want to allow for <code>Number</code> types.
         * </p>
         * 
         * @param maxValue
         *        A numeric value that determines the largest numeric value you want to allow for <code>Number</code>
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(String maxValue);

        /**
         * <p>
         * A numeric value that determines the smallest numeric value you want to allow for <code>Number</code> types.
         * </p>
         * 
         * @param minValue
         *        A numeric value that determines the smallest numeric value you want to allow for <code>Number</code>
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(String minValue);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private String allowedPattern;

        private String constraintDescription;

        private String maxLength;

        private String minLength;

        private String maxValue;

        private String minValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            allowedValues(model.allowedValues);
            allowedPattern(model.allowedPattern);
            constraintDescription(model.constraintDescription);
            maxLength(model.maxLength);
            minLength(model.minLength);
            maxValue(model.maxValue);
            minValue(model.minValue);
        }

        public final Collection<String> getAllowedValues() {
            if (allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @Override
        @Transient
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final String getAllowedPattern() {
            return allowedPattern;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        @Transient
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final String getConstraintDescription() {
            return constraintDescription;
        }

        public final void setConstraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
        }

        @Override
        @Transient
        public final Builder constraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
            return this;
        }

        public final String getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        @Transient
        public final Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final String getMinLength() {
            return minLength;
        }

        public final void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        @Override
        @Transient
        public final Builder minLength(String minLength) {
            this.minLength = minLength;
            return this;
        }

        public final String getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        @Transient
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getMinValue() {
            return minValue;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Override
        @Transient
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
