/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a resource change that will occur when a plan is executed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceChange implements SdkPojo, Serializable, ToCopyableBuilder<ResourceChange.Builder, ResourceChange> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ResourceChange::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(ResourceChange::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalResourceId").getter(getter(ResourceChange::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceChange::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> REPLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Replacement").getter(getter(ResourceChange::replacementAsString)).setter(setter(Builder::replacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replacement").build()).build();

    private static final SdkField<List<String>> SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Scope")
            .getter(getter(ResourceChange::scopeAsStrings))
            .setter(setter(Builder::scopeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceChangeDetail>> DETAILS_FIELD = SdkField
            .<List<ResourceChangeDetail>> builder(MarshallingType.LIST)
            .memberName("Details")
            .getter(getter(ResourceChange::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceChangeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceChangeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, REPLACEMENT_FIELD, SCOPE_FIELD,
            DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final String replacement;

    private final List<String> scope;

    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    /**
     * <p>
     * The change action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The change action.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The change action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The change action.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The ID of the resource, as defined in the CloudFormation template.
     * </p>
     * 
     * @return The ID of the resource, as defined in the CloudFormation template.
     */
    public final String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The ID of the resource, if it was already created.
     * </p>
     * 
     * @return The ID of the resource, if it was already created.
     */
    public final String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and replaced with a
     * new one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementAsString}.
     * </p>
     * 
     * @return If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and
     *         replaced with a new one.
     * @see Replacement
     */
    public final Replacement replacement() {
        return Replacement.fromValue(replacement);
    }

    /**
     * <p>
     * If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and replaced with a
     * new one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementAsString}.
     * </p>
     * 
     * @return If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and
     *         replaced with a new one.
     * @see Replacement
     */
    public final String replacementAsString() {
        return replacement;
    }

    /**
     * <p>
     * The change scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScope} method.
     * </p>
     * 
     * @return The change scope.
     */
    public final List<ResourceAttribute> scope() {
        return ScopeCopier.copyStringToEnum(scope);
    }

    /**
     * For responses, this returns true if the service returned a value for the Scope property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasScope() {
        return scope != null && !(scope instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The change scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScope} method.
     * </p>
     * 
     * @return The change scope.
     */
    public final List<String> scopeAsStrings() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Information about the resource changes.
     */
    public final List<ResourceChangeDetail> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(replacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasScope() ? scopeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(replacementAsString(), other.replacementAsString()) && hasScope() == other.hasScope()
                && Objects.equals(scopeAsStrings(), other.scopeAsStrings()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceChange").add("Action", actionAsString()).add("LogicalResourceId", logicalResourceId())
                .add("PhysicalResourceId", physicalResourceId()).add("ResourceType", resourceType())
                .add("Replacement", replacementAsString()).add("Scope", hasScope() ? scopeAsStrings() : null)
                .add("Details", hasDetails() ? details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Replacement":
            return Optional.ofNullable(clazz.cast(replacementAsString()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsStrings()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceChange, T> g) {
        return obj -> g.apply((ResourceChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceChange> {
        /**
         * <p>
         * The change action.
         * </p>
         * 
         * @param action
         *        The change action.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The change action.
         * </p>
         * 
         * @param action
         *        The change action.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The ID of the resource, as defined in the CloudFormation template.
         * </p>
         * 
         * @param logicalResourceId
         *        The ID of the resource, as defined in the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The ID of the resource, if it was already created.
         * </p>
         * 
         * @param physicalResourceId
         *        The ID of the resource, if it was already created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and replaced
         * with a new one.
         * </p>
         * 
         * @param replacement
         *        If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and
         *        replaced with a new one.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(String replacement);

        /**
         * <p>
         * If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and replaced
         * with a new one.
         * </p>
         * 
         * @param replacement
         *        If the change type is <code>Modify</code>, indicates whether the existing resource is deleted and
         *        replaced with a new one.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(Replacement replacement);

        /**
         * <p>
         * The change scope.
         * </p>
         * 
         * @param scope
         *        The change scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeWithStrings(Collection<String> scope);

        /**
         * <p>
         * The change scope.
         * </p>
         * 
         * @param scope
         *        The change scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeWithStrings(String... scope);

        /**
         * <p>
         * The change scope.
         * </p>
         * 
         * @param scope
         *        The change scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<ResourceAttribute> scope);

        /**
         * <p>
         * The change scope.
         * </p>
         * 
         * @param scope
         *        The change scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(ResourceAttribute... scope);

        /**
         * <p>
         * Information about the resource changes.
         * </p>
         * 
         * @param details
         *        Information about the resource changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<ResourceChangeDetail> details);

        /**
         * <p>
         * Information about the resource changes.
         * </p>
         * 
         * @param details
         *        Information about the resource changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceChangeDetail... details);

        /**
         * <p>
         * Information about the resource changes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceChangeDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceChangeDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceChangeDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #details(List<ResourceChangeDetail>)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link List<ResourceChangeDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(List<ResourceChangeDetail>)
         */
        Builder details(Consumer<ResourceChangeDetail.Builder>... details);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private String replacement;

        private List<String> scope = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceChangeDetail> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            action(model.action);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            replacement(model.replacement);
            scopeWithStrings(model.scope);
            details(model.details);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        @Transient
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        @Transient
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getReplacement() {
            return replacement;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Override
        @Transient
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        @Transient
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement == null ? null : replacement.toString());
            return this;
        }

        public final Collection<String> getScope() {
            if (scope instanceof SdkAutoConstructList) {
                return null;
            }
            return scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        @Override
        @Transient
        public final Builder scopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scopeWithStrings(String... scope) {
            scopeWithStrings(Arrays.asList(scope));
            return this;
        }

        @Override
        @Transient
        public final Builder scope(Collection<ResourceAttribute> scope) {
            this.scope = ScopeCopier.copyEnumToString(scope);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scope(ResourceAttribute... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final List<ResourceChangeDetail.Builder> getDetails() {
            List<ResourceChangeDetail.Builder> result = ResourceChangeDetailsCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        @Override
        @Transient
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder details(ResourceChangeDetail... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder details(Consumer<ResourceChangeDetail.Builder>... details) {
            details(Stream.of(details).map(c -> ResourceChangeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceChange build() {
            return new ResourceChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
