/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisionedProductPropertiesResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<UpdateProvisionedProductPropertiesResponse.Builder, UpdateProvisionedProductPropertiesResponse> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId").getter(getter(UpdateProvisionedProductPropertiesResponse::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<Map<String, String>> PROVISIONED_PRODUCT_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ProvisionedProductProperties")
            .getter(getter(UpdateProvisionedProductPropertiesResponse::provisionedProductPropertiesAsStrings))
            .setter(setter(Builder::provisionedProductPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductProperties")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(UpdateProvisionedProductPropertiesResponse::recordId))
            .setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateProvisionedProductPropertiesResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD,
            PROVISIONED_PRODUCT_PROPERTIES_FIELD, RECORD_ID_FIELD, STATUS_FIELD));

    private final String provisionedProductId;

    private final Map<String, String> provisionedProductProperties;

    private final String recordId;

    private final String status;

    private UpdateProvisionedProductPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductProperties = builder.provisionedProductProperties;
        this.recordId = builder.recordId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The provisioned product identifier.
     * </p>
     * 
     * @return The provisioned product identifier.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * A map that contains the properties updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedProductProperties} method.
     * </p>
     * 
     * @return A map that contains the properties updated.
     */
    public final Map<PropertyKey, String> provisionedProductProperties() {
        return ProvisionedProductPropertiesCopier.copyStringToEnum(provisionedProductProperties);
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedProductProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisionedProductProperties() {
        return provisionedProductProperties != null && !(provisionedProductProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains the properties updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedProductProperties} method.
     * </p>
     * 
     * @return A map that contains the properties updated.
     */
    public final Map<String, String> provisionedProductPropertiesAsStrings() {
        return provisionedProductProperties;
    }

    /**
     * <p>
     * The identifier of the record.
     * </p>
     * 
     * @return The identifier of the record.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see RecordStatus
     */
    public final RecordStatus status() {
        return RecordStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see RecordStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasProvisionedProductProperties() ? provisionedProductPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductPropertiesResponse)) {
            return false;
        }
        UpdateProvisionedProductPropertiesResponse other = (UpdateProvisionedProductPropertiesResponse) obj;
        return Objects.equals(provisionedProductId(), other.provisionedProductId())
                && hasProvisionedProductProperties() == other.hasProvisionedProductProperties()
                && Objects.equals(provisionedProductPropertiesAsStrings(), other.provisionedProductPropertiesAsStrings())
                && Objects.equals(recordId(), other.recordId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateProvisionedProductPropertiesResponse")
                .add("ProvisionedProductId", provisionedProductId())
                .add("ProvisionedProductProperties",
                        hasProvisionedProductProperties() ? provisionedProductPropertiesAsStrings() : null)
                .add("RecordId", recordId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ProvisionedProductProperties":
            return Optional.ofNullable(clazz.cast(provisionedProductPropertiesAsStrings()));
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductPropertiesResponse, T> g) {
        return obj -> g.apply((UpdateProvisionedProductPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProvisionedProductPropertiesResponse> {
        /**
         * <p>
         * The provisioned product identifier.
         * </p>
         * 
         * @param provisionedProductId
         *        The provisioned product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * A map that contains the properties updated.
         * </p>
         * 
         * @param provisionedProductProperties
         *        A map that contains the properties updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties);

        /**
         * <p>
         * A map that contains the properties updated.
         * </p>
         * 
         * @param provisionedProductProperties
         *        A map that contains the properties updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties);

        /**
         * <p>
         * The identifier of the record.
         * </p>
         * 
         * @param recordId
         *        The identifier of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see RecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see RecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordStatus
         */
        Builder status(RecordStatus status);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String provisionedProductId;

        private Map<String, String> provisionedProductProperties = DefaultSdkAutoConstructMap.getInstance();

        private String recordId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductPropertiesResponse model) {
            super(model);
            provisionedProductId(model.provisionedProductId);
            provisionedProductPropertiesWithStrings(model.provisionedProductProperties);
            recordId(model.recordId);
            status(model.status);
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        @Transient
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final Map<String, String> getProvisionedProductProperties() {
            if (provisionedProductProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return provisionedProductProperties;
        }

        public final void setProvisionedProductProperties(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
        }

        @Override
        @Transient
        public final Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
            return this;
        }

        @Override
        @Transient
        public final Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copyEnumToString(provisionedProductProperties);
            return this;
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        @Transient
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateProvisionedProductPropertiesResponse build() {
            return new UpdateProvisionedProductPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
