/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;

public class ListAcceptedPortfolioSharesIterable
implements SdkIterable<ListAcceptedPortfolioSharesResponse> {
    private final ServiceCatalogClient client;
    private final ListAcceptedPortfolioSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAcceptedPortfolioSharesIterable(ServiceCatalogClient client, ListAcceptedPortfolioSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAcceptedPortfolioSharesResponseFetcher();
    }

    public Iterator<ListAcceptedPortfolioSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAcceptedPortfolioSharesResponseFetcher
    implements SyncPageFetcher<ListAcceptedPortfolioSharesResponse> {
        private ListAcceptedPortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListAcceptedPortfolioSharesResponse nextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return ListAcceptedPortfolioSharesIterable.this.client.listAcceptedPortfolioShares(ListAcceptedPortfolioSharesIterable.this.firstRequest);
            }
            return ListAcceptedPortfolioSharesIterable.this.client.listAcceptedPortfolioShares((ListAcceptedPortfolioSharesRequest)((Object)ListAcceptedPortfolioSharesIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

