/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateTagOptionFromResourceRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<DisassociateTagOptionFromResourceRequest.Builder, DisassociateTagOptionFromResourceRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(DisassociateTagOptionFromResourceRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> TAG_OPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagOptionId").getter(getter(DisassociateTagOptionFromResourceRequest::tagOptionId))
            .setter(setter(Builder::tagOptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            TAG_OPTION_ID_FIELD));

    private final String resourceId;

    private final String tagOptionId;

    private DisassociateTagOptionFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagOptionId = builder.tagOptionId;
    }

    /**
     * <p>
     * The resource identifier.
     * </p>
     * 
     * @return The resource identifier.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The TagOption identifier.
     * </p>
     * 
     * @return The TagOption identifier.
     */
    public final String tagOptionId() {
        return tagOptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(tagOptionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTagOptionFromResourceRequest)) {
            return false;
        }
        DisassociateTagOptionFromResourceRequest other = (DisassociateTagOptionFromResourceRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(tagOptionId(), other.tagOptionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateTagOptionFromResourceRequest").add("ResourceId", resourceId())
                .add("TagOptionId", tagOptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "TagOptionId":
            return Optional.ofNullable(clazz.cast(tagOptionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTagOptionFromResourceRequest, T> g) {
        return obj -> g.apply((DisassociateTagOptionFromResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateTagOptionFromResourceRequest> {
        /**
         * <p>
         * The resource identifier.
         * </p>
         * 
         * @param resourceId
         *        The resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The TagOption identifier.
         * </p>
         * 
         * @param tagOptionId
         *        The TagOption identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptionId(String tagOptionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String tagOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTagOptionFromResourceRequest model) {
            super(model);
            resourceId(model.resourceId);
            tagOptionId(model.tagOptionId);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getTagOptionId() {
            return tagOptionId;
        }

        public final void setTagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
        }

        @Override
        public final Builder tagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateTagOptionFromResourceRequest build() {
            return new DisassociateTagOptionFromResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
