/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyTerminateProvisionedProductEngineWorkflowResultRequest extends ServiceCatalogRequest
        implements
        ToCopyableBuilder<NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder, NotifyTerminateProvisionedProductEngineWorkflowResultRequest> {
    private static final SdkField<String> WORKFLOW_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowToken")
            .getter(getter(NotifyTerminateProvisionedProductEngineWorkflowResultRequest::workflowToken))
            .setter(setter(Builder::workflowToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowToken").build()).build();

    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(NotifyTerminateProvisionedProductEngineWorkflowResultRequest::recordId))
            .setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NotifyTerminateProvisionedProductEngineWorkflowResultRequest::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason")
            .getter(getter(NotifyTerminateProvisionedProductEngineWorkflowResultRequest::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(NotifyTerminateProvisionedProductEngineWorkflowResultRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TOKEN_FIELD,
            RECORD_ID_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String workflowToken;

    private final String recordId;

    private final String status;

    private final String failureReason;

    private final String idempotencyToken;

    private NotifyTerminateProvisionedProductEngineWorkflowResultRequest(BuilderImpl builder) {
        super(builder);
        this.workflowToken = builder.workflowToken;
        this.recordId = builder.recordId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The encrypted contents of the terminate engine execution payload that Service Catalog sends after the Terraform
     * product terminate workflow starts.
     * </p>
     * 
     * @return The encrypted contents of the terminate engine execution payload that Service Catalog sends after the
     *         Terraform product terminate workflow starts.
     */
    public final String workflowToken() {
        return workflowToken;
    }

    /**
     * <p>
     * The identifier of the record.
     * </p>
     * 
     * @return The identifier of the record.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * <p>
     * The status of the terminate engine execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EngineWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the terminate engine execution.
     * @see EngineWorkflowStatus
     */
    public final EngineWorkflowStatus status() {
        return EngineWorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the terminate engine execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EngineWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the terminate engine execution.
     * @see EngineWorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason why the terminate engine execution failed.
     * </p>
     * 
     * @return The reason why the terminate engine execution failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The idempotency token that identifies the terminate engine execution.
     * </p>
     * 
     * @return The idempotency token that identifies the terminate engine execution.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowToken());
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyTerminateProvisionedProductEngineWorkflowResultRequest)) {
            return false;
        }
        NotifyTerminateProvisionedProductEngineWorkflowResultRequest other = (NotifyTerminateProvisionedProductEngineWorkflowResultRequest) obj;
        return Objects.equals(workflowToken(), other.workflowToken()) && Objects.equals(recordId(), other.recordId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyTerminateProvisionedProductEngineWorkflowResultRequest")
                .add("WorkflowToken", workflowToken()).add("RecordId", recordId()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowToken":
            return Optional.ofNullable(clazz.cast(workflowToken()));
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyTerminateProvisionedProductEngineWorkflowResultRequest, T> g) {
        return obj -> g.apply((NotifyTerminateProvisionedProductEngineWorkflowResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, NotifyTerminateProvisionedProductEngineWorkflowResultRequest> {
        /**
         * <p>
         * The encrypted contents of the terminate engine execution payload that Service Catalog sends after the
         * Terraform product terminate workflow starts.
         * </p>
         * 
         * @param workflowToken
         *        The encrypted contents of the terminate engine execution payload that Service Catalog sends after the
         *        Terraform product terminate workflow starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowToken(String workflowToken);

        /**
         * <p>
         * The identifier of the record.
         * </p>
         * 
         * @param recordId
         *        The identifier of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The status of the terminate engine execution.
         * </p>
         * 
         * @param status
         *        The status of the terminate engine execution.
         * @see EngineWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineWorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the terminate engine execution.
         * </p>
         * 
         * @param status
         *        The status of the terminate engine execution.
         * @see EngineWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineWorkflowStatus
         */
        Builder status(EngineWorkflowStatus status);

        /**
         * <p>
         * The reason why the terminate engine execution failed.
         * </p>
         * 
         * @param failureReason
         *        The reason why the terminate engine execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The idempotency token that identifies the terminate engine execution.
         * </p>
         * 
         * @param idempotencyToken
         *        The idempotency token that identifies the terminate engine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String workflowToken;

        private String recordId;

        private String status;

        private String failureReason;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyTerminateProvisionedProductEngineWorkflowResultRequest model) {
            super(model);
            workflowToken(model.workflowToken);
            recordId(model.recordId);
            status(model.status);
            failureReason(model.failureReason);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getWorkflowToken() {
            return workflowToken;
        }

        public final void setWorkflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
        }

        @Override
        public final Builder workflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
            return this;
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EngineWorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyTerminateProvisionedProductEngineWorkflowResultRequest build() {
            return new NotifyTerminateProvisionedProductEngineWorkflowResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
