/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogBaseClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogServiceClientConfiguration;
import software.amazon.awssdk.services.servicecatalog.endpoints.ServiceCatalogEndpointProvider;

@SdkInternalApi
final class DefaultServiceCatalogAsyncClientBuilder
extends DefaultServiceCatalogBaseClientBuilder<ServiceCatalogAsyncClientBuilder, ServiceCatalogAsyncClient>
implements ServiceCatalogAsyncClientBuilder {
    DefaultServiceCatalogAsyncClientBuilder() {
    }

    @Override
    public DefaultServiceCatalogAsyncClientBuilder endpointProvider(ServiceCatalogEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceCatalogAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultServiceCatalogAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ServiceCatalogServiceClientConfiguration serviceClientConfiguration = ServiceCatalogServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultServiceCatalogAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

