/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher;

/**
 * Service client for accessing AWS Service Catalog asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Service Catalog</fullname>
 * <p>
 * <a href="http://aws.amazon.com/servicecatalog">Service Catalog</a> enables organizations to create and manage
 * catalogs of IT services that are approved for Amazon Web Services. To get the most out of this documentation, you
 * should be familiar with the terminology discussed in <a
 * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/what-is_concepts.html">Service Catalog
 * Concepts</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceCatalogAsyncClient extends AwsClient {
    String SERVICE_NAME = "servicecatalog";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicecatalog";

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     *
     * @param acceptPortfolioShareRequest
     * @return A Java Future containing the result of the AcceptPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AcceptPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptPortfolioShareResponse> acceptPortfolioShare(
            AcceptPortfolioShareRequest acceptPortfolioShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptPortfolioShareRequest#builder()}
     * </p>
     *
     * @param acceptPortfolioShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AcceptPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AcceptPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptPortfolioShareResponse> acceptPortfolioShare(
            Consumer<AcceptPortfolioShareRequest.Builder> acceptPortfolioShareRequest) {
        return acceptPortfolioShare(AcceptPortfolioShareRequest.builder().applyMutation(acceptPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     * @return A Java Future containing the result of the AssociateBudgetWithResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateBudgetWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBudgetWithResourceResponse> associateBudgetWithResource(
            AssociateBudgetWithResourceRequest associateBudgetWithResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBudgetWithResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateBudgetWithResourceRequest#builder()}
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateBudgetWithResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateBudgetWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBudgetWithResourceResponse> associateBudgetWithResource(
            Consumer<AssociateBudgetWithResourceRequest.Builder> associateBudgetWithResourceRequest) {
        return associateBudgetWithResource(AssociateBudgetWithResourceRequest.builder()
                .applyMutation(associateBudgetWithResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     * <p>
     * If you share the portfolio with principal name sharing enabled, the <code>PrincipalARN</code> association is
     * included in the share.
     * </p>
     * <p>
     * The <code>PortfolioID</code>, <code>PrincipalARN</code>, and <code>PrincipalType</code> parameters are required.
     * </p>
     * <p>
     * You can associate a maximum of 10 Principals with a portfolio using <code>PrincipalType</code> as
     * <code>IAM_PATTERN</code>.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param associatePrincipalWithPortfolioRequest
     * @return A Java Future containing the result of the AssociatePrincipalWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociatePrincipalWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePrincipalWithPortfolioResponse> associatePrincipalWithPortfolio(
            AssociatePrincipalWithPortfolioRequest associatePrincipalWithPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     * <p>
     * If you share the portfolio with principal name sharing enabled, the <code>PrincipalARN</code> association is
     * included in the share.
     * </p>
     * <p>
     * The <code>PortfolioID</code>, <code>PrincipalARN</code>, and <code>PrincipalType</code> parameters are required.
     * </p>
     * <p>
     * You can associate a maximum of 10 Principals with a portfolio using <code>PrincipalType</code> as
     * <code>IAM_PATTERN</code>.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePrincipalWithPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePrincipalWithPortfolioRequest#builder()}
     * </p>
     *
     * @param associatePrincipalWithPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociatePrincipalWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociatePrincipalWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePrincipalWithPortfolioResponse> associatePrincipalWithPortfolio(
            Consumer<AssociatePrincipalWithPortfolioRequest.Builder> associatePrincipalWithPortfolioRequest) {
        return associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest.builder()
                .applyMutation(associatePrincipalWithPortfolioRequest).build());
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     * @return A Java Future containing the result of the AssociateProductWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateProductWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProductWithPortfolioResponse> associateProductWithPortfolio(
            AssociateProductWithPortfolioRequest associateProductWithPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProductWithPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateProductWithPortfolioRequest#builder()}
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateProductWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateProductWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProductWithPortfolioResponse> associateProductWithPortfolio(
            Consumer<AssociateProductWithPortfolioRequest.Builder> associateProductWithPortfolioRequest) {
        return associateProductWithPortfolio(AssociateProductWithPortfolioRequest.builder()
                .applyMutation(associateProductWithPortfolioRequest).build());
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     * @return A Java Future containing the result of the AssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceActionWithProvisioningArtifactResponse> associateServiceActionWithProvisioningArtifact(
            AssociateServiceActionWithProvisioningArtifactRequest associateServiceActionWithProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateServiceActionWithProvisioningArtifactRequest.Builder} avoiding the need to create one manually
     * via {@link AssociateServiceActionWithProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceActionWithProvisioningArtifactResponse> associateServiceActionWithProvisioningArtifact(
            Consumer<AssociateServiceActionWithProvisioningArtifactRequest.Builder> associateServiceActionWithProvisioningArtifactRequest) {
        return associateServiceActionWithProvisioningArtifact(AssociateServiceActionWithProvisioningArtifactRequest.builder()
                .applyMutation(associateServiceActionWithProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     * @return A Java Future containing the result of the AssociateTagOptionWithResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateTagOptionWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTagOptionWithResourceResponse> associateTagOptionWithResource(
            AssociateTagOptionWithResourceRequest associateTagOptionWithResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTagOptionWithResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTagOptionWithResourceRequest#builder()}
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateTagOptionWithResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateTagOptionWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTagOptionWithResourceResponse> associateTagOptionWithResource(
            Consumer<AssociateTagOptionWithResourceRequest.Builder> associateTagOptionWithResourceRequest) {
        return associateTagOptionWithResource(AssociateTagOptionWithResourceRequest.builder()
                .applyMutation(associateTagOptionWithResourceRequest).build());
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     * @return A Java Future containing the result of the BatchAssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateServiceActionWithProvisioningArtifactResponse> batchAssociateServiceActionWithProvisioningArtifact(
            BatchAssociateServiceActionWithProvisioningArtifactRequest batchAssociateServiceActionWithProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder} avoiding the need to create one
     * manually via {@link BatchAssociateServiceActionWithProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchAssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateServiceActionWithProvisioningArtifactResponse> batchAssociateServiceActionWithProvisioningArtifact(
            Consumer<BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder> batchAssociateServiceActionWithProvisioningArtifactRequest) {
        return batchAssociateServiceActionWithProvisioningArtifact(BatchAssociateServiceActionWithProvisioningArtifactRequest
                .builder().applyMutation(batchAssociateServiceActionWithProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     * @return A Java Future containing the result of the BatchDisassociateServiceActionFromProvisioningArtifact
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateServiceActionFromProvisioningArtifactResponse> batchDisassociateServiceActionFromProvisioningArtifact(
            BatchDisassociateServiceActionFromProvisioningArtifactRequest batchDisassociateServiceActionFromProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder} avoiding the need to create one
     * manually via {@link BatchDisassociateServiceActionFromProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDisassociateServiceActionFromProvisioningArtifact
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateServiceActionFromProvisioningArtifactResponse> batchDisassociateServiceActionFromProvisioningArtifact(
            Consumer<BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder> batchDisassociateServiceActionFromProvisioningArtifactRequest) {
        return batchDisassociateServiceActionFromProvisioningArtifact(BatchDisassociateServiceActionFromProvisioningArtifactRequest
                .builder().applyMutation(batchDisassociateServiceActionFromProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same Region or
     * another Region. If you copy a product to another account, you must first share the product in a portfolio using
     * <a>CreatePortfolioShare</a>.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     *
     * @param copyProductRequest
     * @return A Java Future containing the result of the CopyProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CopyProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyProductResponse> copyProduct(CopyProductRequest copyProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same Region or
     * another Region. If you copy a product to another account, you must first share the product in a portfolio using
     * <a>CreatePortfolioShare</a>.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyProductRequest.Builder} avoiding the need to
     * create one manually via {@link CopyProductRequest#builder()}
     * </p>
     *
     * @param copyProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CopyProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyProductResponse> copyProduct(Consumer<CopyProductRequest.Builder> copyProductRequest) {
        return copyProduct(CopyProductRequest.builder().applyMutation(copyProductRequest).build());
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createConstraintRequest
     * @return A Java Future containing the result of the CreateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConstraintResponse> createConstraint(CreateConstraintRequest createConstraintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConstraintRequest#builder()}
     * </p>
     *
     * @param createConstraintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConstraintResponse> createConstraint(
            Consumer<CreateConstraintRequest.Builder> createConstraintRequest) {
        return createConstraint(CreateConstraintRequest.builder().applyMutation(createConstraintRequest).build());
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createPortfolioRequest
     * @return A Java Future containing the result of the CreatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePortfolioResponse> createPortfolio(CreatePortfolioRequest createPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePortfolioRequest#builder()}
     * </p>
     *
     * @param createPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePortfolioResponse> createPortfolio(
            Consumer<CreatePortfolioRequest.Builder> createPortfolioRequest) {
        return createPortfolio(CreatePortfolioRequest.builder().applyMutation(createPortfolioRequest).build());
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param createPortfolioShareRequest
     * @return A Java Future containing the result of the CreatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePortfolioShareResponse> createPortfolioShare(
            CreatePortfolioShareRequest createPortfolioShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePortfolioShareRequest#builder()}
     * </p>
     *
     * @param createPortfolioShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePortfolioShareResponse> createPortfolioShare(
            Consumer<CreatePortfolioShareRequest.Builder> createPortfolioShareRequest) {
        return createPortfolioShare(CreatePortfolioShareRequest.builder().applyMutation(createPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProductRequest
     * @return A Java Future containing the result of the CreateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProductResponse> createProduct(CreateProductRequest createProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProductRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProductRequest#builder()}
     * </p>
     *
     * @param createProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProductResponse> createProduct(Consumer<CreateProductRequest.Builder> createProductRequest) {
        return createProduct(CreateProductRequest.builder().applyMutation(createProductRequest).build());
    }

    /**
     * <p>
     * Creates a plan.
     * </p>
     * <p>
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating
     * a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILABLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     * @return A Java Future containing the result of the CreateProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisionedProductPlanResponse> createProvisionedProductPlan(
            CreateProvisionedProductPlanRequest createProvisionedProductPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a plan.
     * </p>
     * <p>
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating
     * a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILABLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisionedProductPlanResponse> createProvisionedProductPlan(
            Consumer<CreateProvisionedProductPlanRequest.Builder> createProvisionedProductPlanRequest) {
        return createProvisionedProductPlan(CreateProvisionedProductPlanRequest.builder()
                .applyMutation(createProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProvisioningArtifactRequest
     * @return A Java Future containing the result of the CreateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisioningArtifactResponse> createProvisioningArtifact(
            CreateProvisioningArtifactRequest createProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param createProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisioningArtifactResponse> createProvisioningArtifact(
            Consumer<CreateProvisioningArtifactRequest.Builder> createProvisioningArtifactRequest) {
        return createProvisioningArtifact(CreateProvisioningArtifactRequest.builder()
                .applyMutation(createProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     *
     * @param createServiceActionRequest
     * @return A Java Future containing the result of the CreateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceActionResponse> createServiceAction(
            CreateServiceActionRequest createServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceActionRequest#builder()}
     * </p>
     *
     * @param createServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceActionResponse> createServiceAction(
            Consumer<CreateServiceActionRequest.Builder> createServiceActionRequest) {
        return createServiceAction(CreateServiceActionRequest.builder().applyMutation(createServiceActionRequest).build());
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     *
     * @param createTagOptionRequest
     * @return A Java Future containing the result of the CreateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTagOptionResponse> createTagOption(CreateTagOptionRequest createTagOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTagOptionRequest#builder()}
     * </p>
     *
     * @param createTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTagOptionResponse> createTagOption(
            Consumer<CreateTagOptionRequest.Builder> createTagOptionRequest) {
        return createTagOption(CreateTagOptionRequest.builder().applyMutation(createTagOptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteConstraintRequest
     * @return A Java Future containing the result of the DeleteConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConstraintResponse> deleteConstraint(DeleteConstraintRequest deleteConstraintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConstraintRequest#builder()}
     * </p>
     *
     * @param deleteConstraintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConstraintResponse> deleteConstraint(
            Consumer<DeleteConstraintRequest.Builder> deleteConstraintRequest) {
        return deleteConstraint(DeleteConstraintRequest.builder().applyMutation(deleteConstraintRequest).build());
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deletePortfolioRequest
     * @return A Java Future containing the result of the DeletePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePortfolioResponse> deletePortfolio(DeletePortfolioRequest deletePortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePortfolioRequest#builder()}
     * </p>
     *
     * @param deletePortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePortfolioResponse> deletePortfolio(
            Consumer<DeletePortfolioRequest.Builder> deletePortfolioRequest) {
        return deletePortfolio(DeletePortfolioRequest.builder().applyMutation(deletePortfolioRequest).build());
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     *
     * @param deletePortfolioShareRequest
     * @return A Java Future containing the result of the DeletePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePortfolioShareResponse> deletePortfolioShare(
            DeletePortfolioShareRequest deletePortfolioShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePortfolioShareRequest#builder()}
     * </p>
     *
     * @param deletePortfolioShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeletePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePortfolioShareResponse> deletePortfolioShare(
            Consumer<DeletePortfolioShareRequest.Builder> deletePortfolioShareRequest) {
        return deletePortfolioShare(DeletePortfolioShareRequest.builder().applyMutation(deletePortfolioShareRequest).build());
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteProductRequest
     * @return A Java Future containing the result of the DeleteProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProductResponse> deleteProduct(DeleteProductRequest deleteProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProductRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProductRequest#builder()}
     * </p>
     *
     * @param deleteProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProductResponse> deleteProduct(Consumer<DeleteProductRequest.Builder> deleteProductRequest) {
        return deleteProduct(DeleteProductRequest.builder().applyMutation(deleteProductRequest).build());
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     * @return A Java Future containing the result of the DeleteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedProductPlanResponse> deleteProvisionedProductPlan(
            DeleteProvisionedProductPlanRequest deleteProvisionedProductPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedProductPlanResponse> deleteProvisionedProductPlan(
            Consumer<DeleteProvisionedProductPlanRequest.Builder> deleteProvisionedProductPlanRequest) {
        return deleteProvisionedProductPlan(DeleteProvisionedProductPlanRequest.builder()
                .applyMutation(deleteProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     * @return A Java Future containing the result of the DeleteProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisioningArtifactResponse> deleteProvisioningArtifact(
            DeleteProvisioningArtifactRequest deleteProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisioningArtifactResponse> deleteProvisioningArtifact(
            Consumer<DeleteProvisioningArtifactRequest.Builder> deleteProvisioningArtifactRequest) {
        return deleteProvisioningArtifact(DeleteProvisioningArtifactRequest.builder()
                .applyMutation(deleteProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     *
     * @param deleteServiceActionRequest
     * @return A Java Future containing the result of the DeleteServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceActionResponse> deleteServiceAction(
            DeleteServiceActionRequest deleteServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceActionRequest#builder()}
     * </p>
     *
     * @param deleteServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceActionResponse> deleteServiceAction(
            Consumer<DeleteServiceActionRequest.Builder> deleteServiceActionRequest) {
        return deleteServiceAction(DeleteServiceActionRequest.builder().applyMutation(deleteServiceActionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     *
     * @param deleteTagOptionRequest
     * @return A Java Future containing the result of the DeleteTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTagOptionResponse> deleteTagOption(DeleteTagOptionRequest deleteTagOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTagOptionRequest#builder()}
     * </p>
     *
     * @param deleteTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTagOptionResponse> deleteTagOption(
            Consumer<DeleteTagOptionRequest.Builder> deleteTagOptionRequest) {
        return deleteTagOption(DeleteTagOptionRequest.builder().applyMutation(deleteTagOptionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     *
     * @param describeConstraintRequest
     * @return A Java Future containing the result of the DescribeConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConstraintResponse> describeConstraint(DescribeConstraintRequest describeConstraintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConstraintRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConstraintRequest#builder()}
     * </p>
     *
     * @param describeConstraintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConstraintResponse> describeConstraint(
            Consumer<DescribeConstraintRequest.Builder> describeConstraintRequest) {
        return describeConstraint(DescribeConstraintRequest.builder().applyMutation(describeConstraintRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     *
     * @param describeCopyProductStatusRequest
     * @return A Java Future containing the result of the DescribeCopyProductStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeCopyProductStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCopyProductStatusResponse> describeCopyProductStatus(
            DescribeCopyProductStatusRequest describeCopyProductStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCopyProductStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCopyProductStatusRequest#builder()}
     * </p>
     *
     * @param describeCopyProductStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCopyProductStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeCopyProductStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCopyProductStatusResponse> describeCopyProductStatus(
            Consumer<DescribeCopyProductStatusRequest.Builder> describeCopyProductStatusRequest) {
        return describeCopyProductStatus(DescribeCopyProductStatusRequest.builder()
                .applyMutation(describeCopyProductStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param describePortfolioRequest
     * @return A Java Future containing the result of the DescribePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioResponse> describePortfolio(DescribePortfolioRequest describePortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePortfolioRequest#builder()}
     * </p>
     *
     * @param describePortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioResponse> describePortfolio(
            Consumer<DescribePortfolioRequest.Builder> describePortfolioRequest) {
        return describePortfolio(DescribePortfolioRequest.builder().applyMutation(describePortfolioRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     * @return A Java Future containing the result of the DescribePortfolioShareStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShareStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioShareStatusResponse> describePortfolioShareStatus(
            DescribePortfolioShareStatusRequest describePortfolioShareStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioShareStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePortfolioShareStatusRequest#builder()}
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribePortfolioShareStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShareStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioShareStatusResponse> describePortfolioShareStatus(
            Consumer<DescribePortfolioShareStatusRequest.Builder> describePortfolioShareStatusRequest) {
        return describePortfolioShareStatus(DescribePortfolioShareStatusRequest.builder()
                .applyMutation(describePortfolioShareStatusRequest).build());
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A Java Future containing the result of the DescribePortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioSharesResponse> describePortfolioShares(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioSharesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePortfolioSharesRequest#builder()}
     * </p>
     *
     * @param describePortfolioSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePortfolioSharesResponse> describePortfolioShares(
            Consumer<DescribePortfolioSharesRequest.Builder> describePortfolioSharesRequest) {
        return describePortfolioShares(DescribePortfolioSharesRequest.builder().applyMutation(describePortfolioSharesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesPublisher describePortfolioSharesPaginator(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) {
        return new DescribePortfolioSharesPublisher(this, describePortfolioSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioSharesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePortfolioSharesRequest#builder()}
     * </p>
     *
     * @param describePortfolioSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesPublisher describePortfolioSharesPaginator(
            Consumer<DescribePortfolioSharesRequest.Builder> describePortfolioSharesRequest) {
        return describePortfolioSharesPaginator(DescribePortfolioSharesRequest.builder()
                .applyMutation(describePortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <note>
     * <p>
     * Running this operation with administrator access results in a failure. <a>DescribeProductAsAdmin</a> should be
     * used instead.
     * </p>
     * </note>
     *
     * @param describeProductRequest
     * @return A Java Future containing the result of the DescribeProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductResponse> describeProduct(DescribeProductRequest describeProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <note>
     * <p>
     * Running this operation with administrator access results in a failure. <a>DescribeProductAsAdmin</a> should be
     * used instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductRequest#builder()}
     * </p>
     *
     * @param describeProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductResponse> describeProduct(
            Consumer<DescribeProductRequest.Builder> describeProductRequest) {
        return describeProduct(DescribeProductRequest.builder().applyMutation(describeProductRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     *
     * @param describeProductAsAdminRequest
     * @return A Java Future containing the result of the DescribeProductAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductAsAdminResponse> describeProductAsAdmin(
            DescribeProductAsAdminRequest describeProductAsAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProductAsAdminRequest#builder()}
     * </p>
     *
     * @param describeProductAsAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeProductAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductAsAdminResponse> describeProductAsAdmin(
            Consumer<DescribeProductAsAdminRequest.Builder> describeProductAsAdminRequest) {
        return describeProductAsAdmin(DescribeProductAsAdminRequest.builder().applyMutation(describeProductAsAdminRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     *
     * @param describeProductViewRequest
     * @return A Java Future containing the result of the DescribeProductView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductViewResponse> describeProductView(
            DescribeProductViewRequest describeProductViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductViewRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProductViewRequest#builder()}
     * </p>
     *
     * @param describeProductViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeProductView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProductViewResponse> describeProductView(
            Consumer<DescribeProductViewRequest.Builder> describeProductViewRequest) {
        return describeProductView(DescribeProductViewRequest.builder().applyMutation(describeProductViewRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for
     *        localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned
     *        product identifier. Customers must provide either Id or Name.
     * @return A Java Future containing the result of the DescribeProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisionedProductResponse> describeProvisionedProduct(
            DescribeProvisionedProductRequest describeProvisionedProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProvisionedProductRequest#builder()}
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest.Builder} to
     *        create a request. DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language
     *        code for localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another
     *        provisioned product identifier. Customers must provide either Id or Name.
     * @return A Java Future containing the result of the DescribeProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisionedProductResponse> describeProvisionedProduct(
            Consumer<DescribeProvisionedProductRequest.Builder> describeProvisionedProductRequest) {
        return describeProvisionedProduct(DescribeProvisionedProductRequest.builder()
                .applyMutation(describeProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     * @return A Java Future containing the result of the DescribeProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisionedProductPlanResponse> describeProvisionedProductPlan(
            DescribeProvisionedProductPlanRequest describeProvisionedProductPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisionedProductPlanResponse> describeProvisionedProductPlan(
            Consumer<DescribeProvisionedProductPlanRequest.Builder> describeProvisionedProductPlanRequest) {
        return describeProvisionedProductPlan(DescribeProvisionedProductPlanRequest.builder()
                .applyMutation(describeProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     * @return A Java Future containing the result of the DescribeProvisioningArtifact operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisioningArtifactResponse> describeProvisioningArtifact(
            DescribeProvisioningArtifactRequest describeProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningArtifactRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeProvisioningArtifact operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisioningArtifactResponse> describeProvisioningArtifact(
            Consumer<DescribeProvisioningArtifactRequest.Builder> describeProvisioningArtifactRequest) {
        return describeProvisioningArtifact(DescribeProvisioningArtifactRequest.builder()
                .applyMutation(describeProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     *
     * @param describeProvisioningParametersRequest
     * @return A Java Future containing the result of the DescribeProvisioningParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisioningParametersResponse> describeProvisioningParameters(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningParametersRequest#builder()}
     * </p>
     *
     * @param describeProvisioningParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeProvisioningParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProvisioningParametersResponse> describeProvisioningParameters(
            Consumer<DescribeProvisioningParametersRequest.Builder> describeProvisioningParametersRequest) {
        return describeProvisioningParameters(DescribeProvisioningParametersRequest.builder()
                .applyMutation(describeProvisioningParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note>
     *
     * @param describeRecordRequest
     * @return A Java Future containing the result of the DescribeRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecordResponse> describeRecord(DescribeRecordRequest describeRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecordRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRecordRequest#builder()}
     * </p>
     *
     * @param describeRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecordResponse> describeRecord(Consumer<DescribeRecordRequest.Builder> describeRecordRequest) {
        return describeRecord(DescribeRecordRequest.builder().applyMutation(describeRecordRequest).build());
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     *
     * @param describeServiceActionRequest
     * @return A Java Future containing the result of the DescribeServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceActionResponse> describeServiceAction(
            DescribeServiceActionRequest describeServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceActionRequest#builder()}
     * </p>
     *
     * @param describeServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceActionResponse> describeServiceAction(
            Consumer<DescribeServiceActionRequest.Builder> describeServiceActionRequest) {
        return describeServiceAction(DescribeServiceActionRequest.builder().applyMutation(describeServiceActionRequest).build());
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     * @return A Java Future containing the result of the DescribeServiceActionExecutionParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceActionExecutionParametersResponse> describeServiceActionExecutionParameters(
            DescribeServiceActionExecutionParametersRequest describeServiceActionExecutionParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeServiceActionExecutionParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeServiceActionExecutionParametersRequest#builder()}
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeServiceActionExecutionParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceActionExecutionParametersResponse> describeServiceActionExecutionParameters(
            Consumer<DescribeServiceActionExecutionParametersRequest.Builder> describeServiceActionExecutionParametersRequest) {
        return describeServiceActionExecutionParameters(DescribeServiceActionExecutionParametersRequest.builder()
                .applyMutation(describeServiceActionExecutionParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     *
     * @param describeTagOptionRequest
     * @return A Java Future containing the result of the DescribeTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTagOptionResponse> describeTagOption(DescribeTagOptionRequest describeTagOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTagOptionRequest#builder()}
     * </p>
     *
     * @param describeTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTagOptionResponse> describeTagOption(
            Consumer<DescribeTagOptionRequest.Builder> describeTagOptionRequest) {
        return describeTagOption(DescribeTagOptionRequest.builder().applyMutation(describeTagOptionRequest).build());
    }

    /**
     * <p>
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares,
     * but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with
     * your organization structure if the structure changes after calling this API. Only the management account in the
     * organization can call this API.
     * </p>
     * <p>
     * You cannot call this API if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations
     * access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the
     * organization structure. Specifically, accounts that you removed from the organization after disabling Service
     * Catalog access will retain access to the previously shared portfolio.
     * </p>
     * </important>
     *
     * @param disableAwsOrganizationsAccessRequest
     * @return A Java Future containing the result of the DisableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableAwsOrganizationsAccessResponse> disableAWSOrganizationsAccess(
            DisableAwsOrganizationsAccessRequest disableAwsOrganizationsAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares,
     * but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with
     * your organization structure if the structure changes after calling this API. Only the management account in the
     * organization can call this API.
     * </p>
     * <p>
     * You cannot call this API if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations
     * access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the
     * organization structure. Specifically, accounts that you removed from the organization after disabling Service
     * Catalog access will retain access to the previously shared portfolio.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableAwsOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link DisableAwsOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param disableAwsOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableAwsOrganizationsAccessResponse> disableAWSOrganizationsAccess(
            Consumer<DisableAwsOrganizationsAccessRequest.Builder> disableAwsOrganizationsAccessRequest) {
        return disableAWSOrganizationsAccess(DisableAwsOrganizationsAccessRequest.builder()
                .applyMutation(disableAwsOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     * @return A Java Future containing the result of the DisassociateBudgetFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateBudgetFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBudgetFromResourceResponse> disassociateBudgetFromResource(
            DisassociateBudgetFromResourceRequest disassociateBudgetFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBudgetFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateBudgetFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateBudgetFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateBudgetFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBudgetFromResourceResponse> disassociateBudgetFromResource(
            Consumer<DisassociateBudgetFromResourceRequest.Builder> disassociateBudgetFromResourceRequest) {
        return disassociateBudgetFromResource(DisassociateBudgetFromResourceRequest.builder()
                .applyMutation(disassociateBudgetFromResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     * <p>
     * The <code>PrincipalType</code> and <code>PrincipalARN</code> must match the
     * <code>AssociatePrincipalWithPortfolio</code> call request details. For example, to disassociate an association
     * created with a <code>PrincipalARN</code> of <code>PrincipalType</code> IAM you must use the
     * <code>PrincipalType</code> IAM when calling <code>DisassociatePrincipalFromPortfolio</code>.
     * </p>
     * <p>
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share
     * recipient accounts will no longer be able to provision products in this portfolio using a role matching the name
     * of the associated principal.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * <note>
     * <p>
     * If you disassociate a principal from a portfolio, with PrincipalType as <code>IAM</code>, the same principal will
     * still have access to the portfolio if it matches one of the associated principals of type
     * <code>IAM_PATTERN</code>. To fully remove access for a principal, verify all the associated Principals of type
     * <code>IAM_PATTERN</code>, and then ensure you disassociate any <code>IAM_PATTERN</code> principals that match the
     * principal whose access you are removing.
     * </p>
     * </note>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     * @return A Java Future containing the result of the DisassociatePrincipalFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePrincipalFromPortfolioResponse> disassociatePrincipalFromPortfolio(
            DisassociatePrincipalFromPortfolioRequest disassociatePrincipalFromPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     * <p>
     * The <code>PrincipalType</code> and <code>PrincipalARN</code> must match the
     * <code>AssociatePrincipalWithPortfolio</code> call request details. For example, to disassociate an association
     * created with a <code>PrincipalARN</code> of <code>PrincipalType</code> IAM you must use the
     * <code>PrincipalType</code> IAM when calling <code>DisassociatePrincipalFromPortfolio</code>.
     * </p>
     * <p>
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share
     * recipient accounts will no longer be able to provision products in this portfolio using a role matching the name
     * of the associated principal.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * <note>
     * <p>
     * If you disassociate a principal from a portfolio, with PrincipalType as <code>IAM</code>, the same principal will
     * still have access to the portfolio if it matches one of the associated principals of type
     * <code>IAM_PATTERN</code>. To fully remove access for a principal, verify all the associated Principals of type
     * <code>IAM_PATTERN</code>, and then ensure you disassociate any <code>IAM_PATTERN</code> principals that match the
     * principal whose access you are removing.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePrincipalFromPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePrincipalFromPortfolioRequest#builder()}
     * </p>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociatePrincipalFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePrincipalFromPortfolioResponse> disassociatePrincipalFromPortfolio(
            Consumer<DisassociatePrincipalFromPortfolioRequest.Builder> disassociatePrincipalFromPortfolioRequest) {
        return disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest.builder()
                .applyMutation(disassociatePrincipalFromPortfolioRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     * @return A Java Future containing the result of the DisassociateProductFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateProductFromPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateProductFromPortfolioResponse> disassociateProductFromPortfolio(
            DisassociateProductFromPortfolioRequest disassociateProductFromPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateProductFromPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateProductFromPortfolioRequest#builder()}
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateProductFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateProductFromPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateProductFromPortfolioResponse> disassociateProductFromPortfolio(
            Consumer<DisassociateProductFromPortfolioRequest.Builder> disassociateProductFromPortfolioRequest) {
        return disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest.builder()
                .applyMutation(disassociateProductFromPortfolioRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     * @return A Java Future containing the result of the DisassociateServiceActionFromProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceActionFromProvisioningArtifactResponse> disassociateServiceActionFromProvisioningArtifact(
            DisassociateServiceActionFromProvisioningArtifactRequest disassociateServiceActionFromProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateServiceActionFromProvisioningArtifactRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociateServiceActionFromProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateServiceActionFromProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceActionFromProvisioningArtifactResponse> disassociateServiceActionFromProvisioningArtifact(
            Consumer<DisassociateServiceActionFromProvisioningArtifactRequest.Builder> disassociateServiceActionFromProvisioningArtifactRequest) {
        return disassociateServiceActionFromProvisioningArtifact(DisassociateServiceActionFromProvisioningArtifactRequest
                .builder().applyMutation(disassociateServiceActionFromProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     * @return A Java Future containing the result of the DisassociateTagOptionFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateTagOptionFromResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTagOptionFromResourceResponse> disassociateTagOptionFromResource(
            DisassociateTagOptionFromResourceRequest disassociateTagOptionFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTagOptionFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateTagOptionFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateTagOptionFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateTagOptionFromResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTagOptionFromResourceResponse> disassociateTagOptionFromResource(
            Consumer<DisassociateTagOptionFromResourceRequest.Builder> disassociateTagOptionFromResourceRequest) {
        return disassociateTagOptionFromResource(DisassociateTagOptionFromResourceRequest.builder()
                .applyMutation(disassociateTagOptionFromResourceRequest).build());
    }

    /**
     * <p>
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on
     * your organization in order to sync your shares with the current structure. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * When you call this API, Service Catalog calls <code>organizations:EnableAWSServiceAccess</code> on your behalf so
     * that your shares stay in sync with any changes in your Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the
     * portfolio access permissions might not sync with the latest changes to the organization structure. Specifically,
     * accounts that you removed from the organization after disabling Service Catalog access, and before you enabled
     * access again, can retain access to the previously shared portfolio. As a result, an account that has been removed
     * from the organization might still be able to create or manage Amazon Web Services resources when it is no longer
     * authorized to do so. Amazon Web Services is working to resolve this issue.
     * </p>
     * </important>
     *
     * @param enableAwsOrganizationsAccessRequest
     * @return A Java Future containing the result of the EnableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.EnableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableAwsOrganizationsAccessResponse> enableAWSOrganizationsAccess(
            EnableAwsOrganizationsAccessRequest enableAwsOrganizationsAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on
     * your organization in order to sync your shares with the current structure. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * When you call this API, Service Catalog calls <code>organizations:EnableAWSServiceAccess</code> on your behalf so
     * that your shares stay in sync with any changes in your Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the
     * portfolio access permissions might not sync with the latest changes to the organization structure. Specifically,
     * accounts that you removed from the organization after disabling Service Catalog access, and before you enabled
     * access again, can retain access to the previously shared portfolio. As a result, an account that has been removed
     * from the organization might still be able to create or manage Amazon Web Services resources when it is no longer
     * authorized to do so. Amazon Web Services is working to resolve this issue.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableAwsOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link EnableAwsOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param enableAwsOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the EnableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.EnableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableAwsOrganizationsAccessResponse> enableAWSOrganizationsAccess(
            Consumer<EnableAwsOrganizationsAccessRequest.Builder> enableAwsOrganizationsAccessRequest) {
        return enableAWSOrganizationsAccess(EnableAwsOrganizationsAccessRequest.builder()
                .applyMutation(enableAwsOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     * @return A Java Future containing the result of the ExecuteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteProvisionedProductPlanResponse> executeProvisionedProductPlan(
            ExecuteProvisionedProductPlanRequest executeProvisionedProductPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ExecuteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteProvisionedProductPlanResponse> executeProvisionedProductPlan(
            Consumer<ExecuteProvisionedProductPlanRequest.Builder> executeProvisionedProductPlanRequest) {
        return executeProvisionedProductPlan(ExecuteProvisionedProductPlanRequest.builder()
                .applyMutation(executeProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     * @return A Java Future containing the result of the ExecuteProvisionedProductServiceAction operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteProvisionedProductServiceActionResponse> executeProvisionedProductServiceAction(
            ExecuteProvisionedProductServiceActionRequest executeProvisionedProductServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ExecuteProvisionedProductServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ExecuteProvisionedProductServiceActionRequest#builder()}
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ExecuteProvisionedProductServiceAction operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteProvisionedProductServiceActionResponse> executeProvisionedProductServiceAction(
            Consumer<ExecuteProvisionedProductServiceActionRequest.Builder> executeProvisionedProductServiceActionRequest) {
        return executeProvisionedProductServiceAction(ExecuteProvisionedProductServiceActionRequest.builder()
                .applyMutation(executeProvisionedProductServiceActionRequest).build());
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     * @return A Java Future containing the result of the GetAWSOrganizationsAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsOrganizationsAccessStatusResponse> getAWSOrganizationsAccessStatus(
            GetAwsOrganizationsAccessStatusRequest getAwsOrganizationsAccessStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsOrganizationsAccessStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetAwsOrganizationsAccessStatusRequest#builder()}
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAWSOrganizationsAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsOrganizationsAccessStatusResponse> getAWSOrganizationsAccessStatus(
            Consumer<GetAwsOrganizationsAccessStatusRequest.Builder> getAwsOrganizationsAccessStatusRequest) {
        return getAWSOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.builder()
                .applyMutation(getAwsOrganizationsAccessStatusRequest).build());
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @return A Java Future containing the result of the GetAWSOrganizationsAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsOrganizationsAccessStatusResponse> getAWSOrganizationsAccessStatus() {
        return getAWSOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.builder().build());
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A Java Future containing the result of the GetProvisionedProductOutputs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedProductOutputsResponse> getProvisionedProductOutputs(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedProductOutputsRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedProductOutputsRequest#builder()}
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetProvisionedProductOutputs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedProductOutputsResponse> getProvisionedProductOutputs(
            Consumer<GetProvisionedProductOutputsRequest.Builder> getProvisionedProductOutputsRequest) {
        return getProvisionedProductOutputs(GetProvisionedProductOutputsRequest.builder()
                .applyMutation(getProvisionedProductOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsPublisher getProvisionedProductOutputsPaginator(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) {
        return new GetProvisionedProductOutputsPublisher(this, getProvisionedProductOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedProductOutputsRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedProductOutputsRequest#builder()}
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsPublisher getProvisionedProductOutputsPaginator(
            Consumer<GetProvisionedProductOutputsRequest.Builder> getProvisionedProductOutputsRequest) {
        return getProvisionedProductOutputsPaginator(GetProvisionedProductOutputsRequest.builder()
                .applyMutation(getProvisionedProductOutputsRequest).build());
    }

    /**
     * <p>
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service
     * Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the
     * provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks,
     * are not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, and
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <note>
     * <p>
     * When you import an existing CloudFormation stack into a portfolio, Service Catalog does not apply the product's
     * associated constraints during the import process. Service Catalog applies the constraints after you call
     * <code>UpdateProvisionedProduct</code> for the provisioned product.
     * </p>
     * </note>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     * <p>
     * You can only import one provisioned product at a time. The product's CloudFormation stack must have the
     * <code>IMPORT_COMPLETE</code> status before you import another.
     * </p>
     *
     * @param importAsProvisionedProductRequest
     * @return A Java Future containing the result of the ImportAsProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ImportAsProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportAsProvisionedProductResponse> importAsProvisionedProduct(
            ImportAsProvisionedProductRequest importAsProvisionedProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service
     * Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the
     * provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks,
     * are not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, and
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <note>
     * <p>
     * When you import an existing CloudFormation stack into a portfolio, Service Catalog does not apply the product's
     * associated constraints during the import process. Service Catalog applies the constraints after you call
     * <code>UpdateProvisionedProduct</code> for the provisioned product.
     * </p>
     * </note>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     * <p>
     * You can only import one provisioned product at a time. The product's CloudFormation stack must have the
     * <code>IMPORT_COMPLETE</code> status before you import another.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportAsProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link ImportAsProvisionedProductRequest#builder()}
     * </p>
     *
     * @param importAsProvisionedProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ImportAsProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ImportAsProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportAsProvisionedProductResponse> importAsProvisionedProduct(
            Consumer<ImportAsProvisionedProductRequest.Builder> importAsProvisionedProductRequest) {
        return importAsProvisionedProduct(ImportAsProvisionedProductRequest.builder()
                .applyMutation(importAsProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A Java Future containing the result of the ListAcceptedPortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceptedPortfolioSharesResponse> listAcceptedPortfolioShares(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceptedPortfolioSharesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAcceptedPortfolioSharesRequest#builder()}
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAcceptedPortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceptedPortfolioSharesResponse> listAcceptedPortfolioShares(
            Consumer<ListAcceptedPortfolioSharesRequest.Builder> listAcceptedPortfolioSharesRequest) {
        return listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.builder()
                .applyMutation(listAcceptedPortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     *
     * @return A Java Future containing the result of the ListAcceptedPortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceptedPortfolioSharesResponse> listAcceptedPortfolioShares() {
        return listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesPublisher listAcceptedPortfolioSharesPaginator() {
        return listAcceptedPortfolioSharesPaginator(ListAcceptedPortfolioSharesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesPublisher listAcceptedPortfolioSharesPaginator(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) {
        return new ListAcceptedPortfolioSharesPublisher(this, listAcceptedPortfolioSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceptedPortfolioSharesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAcceptedPortfolioSharesRequest#builder()}
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesPublisher listAcceptedPortfolioSharesPaginator(
            Consumer<ListAcceptedPortfolioSharesRequest.Builder> listAcceptedPortfolioSharesRequest) {
        return listAcceptedPortfolioSharesPaginator(ListAcceptedPortfolioSharesRequest.builder()
                .applyMutation(listAcceptedPortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A Java Future containing the result of the ListBudgetsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBudgetsForResourceResponse> listBudgetsForResource(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListBudgetsForResourceRequest#builder()}
     * </p>
     *
     * @param listBudgetsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBudgetsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBudgetsForResourceResponse> listBudgetsForResource(
            Consumer<ListBudgetsForResourceRequest.Builder> listBudgetsForResourceRequest) {
        return listBudgetsForResource(ListBudgetsForResourceRequest.builder().applyMutation(listBudgetsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourcePublisher listBudgetsForResourcePaginator(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) {
        return new ListBudgetsForResourcePublisher(this, listBudgetsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListBudgetsForResourceRequest#builder()}
     * </p>
     *
     * @param listBudgetsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourcePublisher listBudgetsForResourcePaginator(
            Consumer<ListBudgetsForResourceRequest.Builder> listBudgetsForResourceRequest) {
        return listBudgetsForResourcePaginator(ListBudgetsForResourceRequest.builder()
                .applyMutation(listBudgetsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A Java Future containing the result of the ListConstraintsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConstraintsForPortfolioResponse> listConstraintsForPortfolio(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConstraintsForPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link ListConstraintsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConstraintsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConstraintsForPortfolioResponse> listConstraintsForPortfolio(
            Consumer<ListConstraintsForPortfolioRequest.Builder> listConstraintsForPortfolioRequest) {
        return listConstraintsForPortfolio(ListConstraintsForPortfolioRequest.builder()
                .applyMutation(listConstraintsForPortfolioRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioPublisher listConstraintsForPortfolioPaginator(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) {
        return new ListConstraintsForPortfolioPublisher(this, listConstraintsForPortfolioRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConstraintsForPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link ListConstraintsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioPublisher listConstraintsForPortfolioPaginator(
            Consumer<ListConstraintsForPortfolioRequest.Builder> listConstraintsForPortfolioRequest) {
        return listConstraintsForPortfolioPaginator(ListConstraintsForPortfolioRequest.builder()
                .applyMutation(listConstraintsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param listLaunchPathsRequest
     * @return A Java Future containing the result of the ListLaunchPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLaunchPathsResponse> listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchPathsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLaunchPathsRequest#builder()}
     * </p>
     *
     * @param listLaunchPathsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLaunchPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLaunchPathsResponse> listLaunchPaths(
            Consumer<ListLaunchPathsRequest.Builder> listLaunchPathsRequest) {
        return listLaunchPaths(ListLaunchPathsRequest.builder().applyMutation(listLaunchPathsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchPathsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsPublisher listLaunchPathsPaginator(ListLaunchPathsRequest listLaunchPathsRequest) {
        return new ListLaunchPathsPublisher(this, listLaunchPathsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchPathsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLaunchPathsRequest#builder()}
     * </p>
     *
     * @param listLaunchPathsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsPublisher listLaunchPathsPaginator(Consumer<ListLaunchPathsRequest.Builder> listLaunchPathsRequest) {
        return listLaunchPathsPaginator(ListLaunchPathsRequest.builder().applyMutation(listLaunchPathsRequest).build());
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A Java Future containing the result of the ListOrganizationPortfolioAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationPortfolioAccessResponse> listOrganizationPortfolioAccess(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationPortfolioAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOrganizationPortfolioAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationPortfolioAccessResponse> listOrganizationPortfolioAccess(
            Consumer<ListOrganizationPortfolioAccessRequest.Builder> listOrganizationPortfolioAccessRequest) {
        return listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessRequest.builder()
                .applyMutation(listOrganizationPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessPublisher listOrganizationPortfolioAccessPaginator(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) {
        return new ListOrganizationPortfolioAccessPublisher(this, listOrganizationPortfolioAccessRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationPortfolioAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessPublisher listOrganizationPortfolioAccessPaginator(
            Consumer<ListOrganizationPortfolioAccessRequest.Builder> listOrganizationPortfolioAccessRequest) {
        return listOrganizationPortfolioAccessPaginator(ListOrganizationPortfolioAccessRequest.builder()
                .applyMutation(listOrganizationPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A Java Future containing the result of the ListPortfolioAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPortfolioAccessResponse> listPortfolioAccess(
            ListPortfolioAccessRequest listPortfolioAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfolioAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListPortfolioAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPortfolioAccessResponse> listPortfolioAccess(
            Consumer<ListPortfolioAccessRequest.Builder> listPortfolioAccessRequest) {
        return listPortfolioAccess(ListPortfolioAccessRequest.builder().applyMutation(listPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessPublisher listPortfolioAccessPaginator(ListPortfolioAccessRequest listPortfolioAccessRequest) {
        return new ListPortfolioAccessPublisher(this, listPortfolioAccessRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfolioAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessPublisher listPortfolioAccessPaginator(
            Consumer<ListPortfolioAccessRequest.Builder> listPortfolioAccessRequest) {
        return listPortfolioAccessPaginator(ListPortfolioAccessRequest.builder().applyMutation(listPortfolioAccessRequest)
                .build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A Java Future containing the result of the ListPortfolios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPortfoliosResponse> listPortfolios(ListPortfoliosRequest listPortfoliosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortfoliosRequest#builder()}
     * </p>
     *
     * @param listPortfoliosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPortfolios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPortfoliosResponse> listPortfolios(Consumer<ListPortfoliosRequest.Builder> listPortfoliosRequest) {
        return listPortfolios(ListPortfoliosRequest.builder().applyMutation(listPortfoliosRequest).build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @return A Java Future containing the result of the ListPortfolios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPortfoliosResponse> listPortfolios() {
        return listPortfolios(ListPortfoliosRequest.builder().build());
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A Java Future containing the result of the ListPortfoliosForProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPortfoliosForProductResponse> listPortfoliosForProduct(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosForProductRequest.Builder} avoiding
     * the need to create one manually via {@link ListPortfoliosForProductRequest#builder()}
     * </p>
     *
     * @param listPortfoliosForProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPortfoliosForProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPortfoliosForProductResponse> listPortfoliosForProduct(
            Consumer<ListPortfoliosForProductRequest.Builder> listPortfoliosForProductRequest) {
        return listPortfoliosForProduct(ListPortfoliosForProductRequest.builder().applyMutation(listPortfoliosForProductRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductPublisher listPortfoliosForProductPaginator(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) {
        return new ListPortfoliosForProductPublisher(this, listPortfoliosForProductRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosForProductRequest.Builder} avoiding
     * the need to create one manually via {@link ListPortfoliosForProductRequest#builder()}
     * </p>
     *
     * @param listPortfoliosForProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductPublisher listPortfoliosForProductPaginator(
            Consumer<ListPortfoliosForProductRequest.Builder> listPortfoliosForProductRequest) {
        return listPortfoliosForProductPaginator(ListPortfoliosForProductRequest.builder()
                .applyMutation(listPortfoliosForProductRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosPublisher listPortfoliosPaginator() {
        return listPortfoliosPaginator(ListPortfoliosRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosPublisher listPortfoliosPaginator(ListPortfoliosRequest listPortfoliosRequest) {
        return new ListPortfoliosPublisher(this, listPortfoliosRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortfoliosRequest#builder()}
     * </p>
     *
     * @param listPortfoliosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosPublisher listPortfoliosPaginator(Consumer<ListPortfoliosRequest.Builder> listPortfoliosRequest) {
        return listPortfoliosPaginator(ListPortfoliosRequest.builder().applyMutation(listPortfoliosRequest).build());
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A Java Future containing the result of the ListPrincipalsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPrincipalsForPortfolioResponse> listPrincipalsForPortfolio(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsForPortfolioRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrincipalsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPrincipalsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPrincipalsForPortfolioResponse> listPrincipalsForPortfolio(
            Consumer<ListPrincipalsForPortfolioRequest.Builder> listPrincipalsForPortfolioRequest) {
        return listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest.builder()
                .applyMutation(listPrincipalsForPortfolioRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioPublisher listPrincipalsForPortfolioPaginator(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) {
        return new ListPrincipalsForPortfolioPublisher(this, listPrincipalsForPortfolioRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsForPortfolioRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrincipalsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioPublisher listPrincipalsForPortfolioPaginator(
            Consumer<ListPrincipalsForPortfolioRequest.Builder> listPrincipalsForPortfolioRequest) {
        return listPrincipalsForPortfolioPaginator(ListPrincipalsForPortfolioRequest.builder()
                .applyMutation(listPrincipalsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     * @return A Java Future containing the result of the ListProvisionedProductPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedProductPlansResponse> listProvisionedProductPlans(
            ListProvisionedProductPlansRequest listProvisionedProductPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedProductPlansRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedProductPlansRequest#builder()}
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProvisionedProductPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedProductPlansResponse> listProvisionedProductPlans(
            Consumer<ListProvisionedProductPlansRequest.Builder> listProvisionedProductPlansRequest) {
        return listProvisionedProductPlans(ListProvisionedProductPlansRequest.builder()
                .applyMutation(listProvisionedProductPlansRequest).build());
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @return A Java Future containing the result of the ListProvisionedProductPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedProductPlansResponse> listProvisionedProductPlans() {
        return listProvisionedProductPlans(ListProvisionedProductPlansRequest.builder().build());
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     * @return A Java Future containing the result of the ListProvisioningArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningArtifactsResponse> listProvisioningArtifacts(
            ListProvisioningArtifactsRequest listProvisioningArtifactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningArtifactsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningArtifactsRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProvisioningArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningArtifactsResponse> listProvisioningArtifacts(
            Consumer<ListProvisioningArtifactsRequest.Builder> listProvisioningArtifactsRequest) {
        return listProvisioningArtifacts(ListProvisioningArtifactsRequest.builder()
                .applyMutation(listProvisioningArtifactsRequest).build());
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A Java Future containing the result of the ListProvisioningArtifactsForServiceAction operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> listProvisioningArtifactsForServiceAction(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListProvisioningArtifactsForServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ListProvisioningArtifactsForServiceActionRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListProvisioningArtifactsForServiceAction operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> listProvisioningArtifactsForServiceAction(
            Consumer<ListProvisioningArtifactsForServiceActionRequest.Builder> listProvisioningArtifactsForServiceActionRequest) {
        return listProvisioningArtifactsForServiceAction(ListProvisioningArtifactsForServiceActionRequest.builder()
                .applyMutation(listProvisioningArtifactsForServiceActionRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionPublisher listProvisioningArtifactsForServiceActionPaginator(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest) {
        return new ListProvisioningArtifactsForServiceActionPublisher(this, listProvisioningArtifactsForServiceActionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListProvisioningArtifactsForServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ListProvisioningArtifactsForServiceActionRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionPublisher listProvisioningArtifactsForServiceActionPaginator(
            Consumer<ListProvisioningArtifactsForServiceActionRequest.Builder> listProvisioningArtifactsForServiceActionRequest) {
        return listProvisioningArtifactsForServiceActionPaginator(ListProvisioningArtifactsForServiceActionRequest.builder()
                .applyMutation(listProvisioningArtifactsForServiceActionRequest).build());
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @param listRecordHistoryRequest
     * @return A Java Future containing the result of the ListRecordHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecordHistoryResponse> listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecordHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link ListRecordHistoryRequest#builder()}
     * </p>
     *
     * @param listRecordHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRecordHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecordHistoryResponse> listRecordHistory(
            Consumer<ListRecordHistoryRequest.Builder> listRecordHistoryRequest) {
        return listRecordHistory(ListRecordHistoryRequest.builder().applyMutation(listRecordHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @return A Java Future containing the result of the ListRecordHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecordHistoryResponse> listRecordHistory() {
        return listRecordHistory(ListRecordHistoryRequest.builder().build());
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A Java Future containing the result of the ListResourcesForTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesForTagOptionResponse> listResourcesForTagOption(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForTagOptionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourcesForTagOptionRequest#builder()}
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResourcesForTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesForTagOptionResponse> listResourcesForTagOption(
            Consumer<ListResourcesForTagOptionRequest.Builder> listResourcesForTagOptionRequest) {
        return listResourcesForTagOption(ListResourcesForTagOptionRequest.builder()
                .applyMutation(listResourcesForTagOptionRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionPublisher listResourcesForTagOptionPaginator(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) {
        return new ListResourcesForTagOptionPublisher(this, listResourcesForTagOptionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForTagOptionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourcesForTagOptionRequest#builder()}
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionPublisher listResourcesForTagOptionPaginator(
            Consumer<ListResourcesForTagOptionRequest.Builder> listResourcesForTagOptionRequest) {
        return listResourcesForTagOptionPaginator(ListResourcesForTagOptionRequest.builder()
                .applyMutation(listResourcesForTagOptionRequest).build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A Java Future containing the result of the ListServiceActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceActionsResponse> listServiceActions(ListServiceActionsRequest listServiceActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceActionsRequest#builder()}
     * </p>
     *
     * @param listServiceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceActionsResponse> listServiceActions(
            Consumer<ListServiceActionsRequest.Builder> listServiceActionsRequest) {
        return listServiceActions(ListServiceActionsRequest.builder().applyMutation(listServiceActionsRequest).build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @return A Java Future containing the result of the ListServiceActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceActionsResponse> listServiceActions() {
        return listServiceActions(ListServiceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A Java Future containing the result of the ListServiceActionsForProvisioningArtifact operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> listServiceActionsForProvisioningArtifact(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceActionsForProvisioningArtifactRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceActionsForProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceActionsForProvisioningArtifact operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> listServiceActionsForProvisioningArtifact(
            Consumer<ListServiceActionsForProvisioningArtifactRequest.Builder> listServiceActionsForProvisioningArtifactRequest) {
        return listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactRequest.builder()
                .applyMutation(listServiceActionsForProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactPublisher listServiceActionsForProvisioningArtifactPaginator(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest) {
        return new ListServiceActionsForProvisioningArtifactPublisher(this, listServiceActionsForProvisioningArtifactRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceActionsForProvisioningArtifactRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceActionsForProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactPublisher listServiceActionsForProvisioningArtifactPaginator(
            Consumer<ListServiceActionsForProvisioningArtifactRequest.Builder> listServiceActionsForProvisioningArtifactRequest) {
        return listServiceActionsForProvisioningArtifactPaginator(ListServiceActionsForProvisioningArtifactRequest.builder()
                .applyMutation(listServiceActionsForProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsPublisher listServiceActionsPaginator() {
        return listServiceActionsPaginator(ListServiceActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsPublisher listServiceActionsPaginator(ListServiceActionsRequest listServiceActionsRequest) {
        return new ListServiceActionsPublisher(this, listServiceActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceActionsRequest#builder()}
     * </p>
     *
     * @param listServiceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsPublisher listServiceActionsPaginator(
            Consumer<ListServiceActionsRequest.Builder> listServiceActionsRequest) {
        return listServiceActionsPaginator(ListServiceActionsRequest.builder().applyMutation(listServiceActionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific Amazon Web Services account name or Region.
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     * @return A Java Future containing the result of the ListStackInstancesForProvisionedProduct operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesForProvisionedProductResponse> listStackInstancesForProvisionedProduct(
            ListStackInstancesForProvisionedProductRequest listStackInstancesForProvisionedProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific Amazon Web Services account name or Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListStackInstancesForProvisionedProductRequest.Builder} avoiding the need to create one manually via
     * {@link ListStackInstancesForProvisionedProductRequest#builder()}
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStackInstancesForProvisionedProduct operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesForProvisionedProductResponse> listStackInstancesForProvisionedProduct(
            Consumer<ListStackInstancesForProvisionedProductRequest.Builder> listStackInstancesForProvisionedProductRequest) {
        return listStackInstancesForProvisionedProduct(ListStackInstancesForProvisionedProductRequest.builder()
                .applyMutation(listStackInstancesForProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A Java Future containing the result of the ListTagOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagOptionsResponse> listTagOptions(ListTagOptionsRequest listTagOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagOptionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagOptionsRequest#builder()}
     * </p>
     *
     * @param listTagOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagOptionsResponse> listTagOptions(Consumer<ListTagOptionsRequest.Builder> listTagOptionsRequest) {
        return listTagOptions(ListTagOptionsRequest.builder().applyMutation(listTagOptionsRequest).build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @return A Java Future containing the result of the ListTagOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagOptionsResponse> listTagOptions() {
        return listTagOptions(ListTagOptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsPublisher listTagOptionsPaginator() {
        return listTagOptionsPaginator(ListTagOptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsPublisher listTagOptionsPaginator(ListTagOptionsRequest listTagOptionsRequest) {
        return new ListTagOptionsPublisher(this, listTagOptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagOptionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagOptionsRequest#builder()}
     * </p>
     *
     * @param listTagOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsPublisher listTagOptionsPaginator(Consumer<ListTagOptionsRequest.Builder> listTagOptionsRequest) {
        return listTagOptionsPaginator(ListTagOptionsRequest.builder().applyMutation(listTagOptionsRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the provisioning engine execution.
     * </p>
     *
     * @param notifyProvisionProductEngineWorkflowResultRequest
     * @return A Java Future containing the result of the NotifyProvisionProductEngineWorkflowResult operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyProvisionProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyProvisionProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyProvisionProductEngineWorkflowResultResponse> notifyProvisionProductEngineWorkflowResult(
            NotifyProvisionProductEngineWorkflowResultRequest notifyProvisionProductEngineWorkflowResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the provisioning engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyProvisionProductEngineWorkflowResultRequest.Builder} avoiding the need to create one manually via
     * {@link NotifyProvisionProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyProvisionProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the NotifyProvisionProductEngineWorkflowResult operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyProvisionProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyProvisionProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyProvisionProductEngineWorkflowResultResponse> notifyProvisionProductEngineWorkflowResult(
            Consumer<NotifyProvisionProductEngineWorkflowResultRequest.Builder> notifyProvisionProductEngineWorkflowResultRequest) {
        return notifyProvisionProductEngineWorkflowResult(NotifyProvisionProductEngineWorkflowResultRequest.builder()
                .applyMutation(notifyProvisionProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the terminate engine execution.
     * </p>
     *
     * @param notifyTerminateProvisionedProductEngineWorkflowResultRequest
     * @return A Java Future containing the result of the NotifyTerminateProvisionedProductEngineWorkflowResult
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyTerminateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyTerminateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyTerminateProvisionedProductEngineWorkflowResultResponse> notifyTerminateProvisionedProductEngineWorkflowResult(
            NotifyTerminateProvisionedProductEngineWorkflowResultRequest notifyTerminateProvisionedProductEngineWorkflowResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the terminate engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder} avoiding the need to create one
     * manually via {@link NotifyTerminateProvisionedProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyTerminateProvisionedProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the NotifyTerminateProvisionedProductEngineWorkflowResult
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyTerminateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyTerminateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyTerminateProvisionedProductEngineWorkflowResultResponse> notifyTerminateProvisionedProductEngineWorkflowResult(
            Consumer<NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder> notifyTerminateProvisionedProductEngineWorkflowResultRequest) {
        return notifyTerminateProvisionedProductEngineWorkflowResult(NotifyTerminateProvisionedProductEngineWorkflowResultRequest
                .builder().applyMutation(notifyTerminateProvisionedProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the update engine execution.
     * </p>
     *
     * @param notifyUpdateProvisionedProductEngineWorkflowResultRequest
     * @return A Java Future containing the result of the NotifyUpdateProvisionedProductEngineWorkflowResult operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyUpdateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyUpdateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyUpdateProvisionedProductEngineWorkflowResultResponse> notifyUpdateProvisionedProductEngineWorkflowResult(
            NotifyUpdateProvisionedProductEngineWorkflowResultRequest notifyUpdateProvisionedProductEngineWorkflowResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the update engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder} avoiding the need to create one
     * manually via {@link NotifyUpdateProvisionedProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyUpdateProvisionedProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the NotifyUpdateProvisionedProductEngineWorkflowResult operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.NotifyUpdateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyUpdateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyUpdateProvisionedProductEngineWorkflowResultResponse> notifyUpdateProvisionedProductEngineWorkflowResult(
            Consumer<NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder> notifyUpdateProvisionedProductEngineWorkflowResultRequest) {
        return notifyUpdateProvisionedProductEngineWorkflowResult(NotifyUpdateProvisionedProductEngineWorkflowResultRequest
                .builder().applyMutation(notifyUpdateProvisionedProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on
     * an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the
     * status of this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't
     * include conflicted keys as tags, or this will cause the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param provisionProductRequest
     * @return A Java Future containing the result of the ProvisionProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ProvisionProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionProductResponse> provisionProduct(ProvisionProductRequest provisionProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on
     * an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the
     * status of this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't
     * include conflicted keys as tags, or this will cause the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionProductRequest.Builder} avoiding the need
     * to create one manually via {@link ProvisionProductRequest#builder()}
     * </p>
     *
     * @param provisionProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ProvisionProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ProvisionProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionProductResponse> provisionProduct(
            Consumer<ProvisionProductRequest.Builder> provisionProductRequest) {
        return provisionProduct(ProvisionProductRequest.builder().applyMutation(provisionProductRequest).build());
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     *
     * @param rejectPortfolioShareRequest
     * @return A Java Future containing the result of the RejectPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.RejectPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectPortfolioShareResponse> rejectPortfolioShare(
            RejectPortfolioShareRequest rejectPortfolioShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectPortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link RejectPortfolioShareRequest#builder()}
     * </p>
     *
     * @param rejectPortfolioShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RejectPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.RejectPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectPortfolioShareResponse> rejectPortfolioShare(
            Consumer<RejectPortfolioShareRequest.Builder> rejectPortfolioShareRequest) {
        return rejectPortfolioShare(RejectPortfolioShareRequest.builder().applyMutation(rejectPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @param scanProvisionedProductsRequest
     * @return A Java Future containing the result of the ScanProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ScanProvisionedProductsResponse> scanProvisionedProducts(
            ScanProvisionedProductsRequest scanProvisionedProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScanProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link ScanProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param scanProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ScanProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ScanProvisionedProductsResponse> scanProvisionedProducts(
            Consumer<ScanProvisionedProductsRequest.Builder> scanProvisionedProductsRequest) {
        return scanProvisionedProducts(ScanProvisionedProductsRequest.builder().applyMutation(scanProvisionedProductsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ScanProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ScanProvisionedProductsResponse> scanProvisionedProducts() {
        return scanProvisionedProducts(ScanProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @param searchProductsRequest
     * @return A Java Future containing the result of the SearchProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchProductsResponse> searchProducts(SearchProductsRequest searchProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProductsRequest#builder()}
     * </p>
     *
     * @param searchProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchProductsResponse> searchProducts(Consumer<SearchProductsRequest.Builder> searchProductsRequest) {
        return searchProducts(SearchProductsRequest.builder().applyMutation(searchProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @return A Java Future containing the result of the SearchProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchProductsResponse> searchProducts() {
        return searchProducts(SearchProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A Java Future containing the result of the SearchProductsAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProductsAsAdminResponse> searchProductsAsAdmin(
            SearchProductsAsAdminRequest searchProductsAsAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link SearchProductsAsAdminRequest#builder()}
     * </p>
     *
     * @param searchProductsAsAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SearchProductsAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProductsAsAdminResponse> searchProductsAsAdmin(
            Consumer<SearchProductsAsAdminRequest.Builder> searchProductsAsAdminRequest) {
        return searchProductsAsAdmin(SearchProductsAsAdminRequest.builder().applyMutation(searchProductsAsAdminRequest).build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @return A Java Future containing the result of the SearchProductsAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProductsAsAdminResponse> searchProductsAsAdmin() {
        return searchProductsAsAdmin(SearchProductsAsAdminRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminPublisher searchProductsAsAdminPaginator() {
        return searchProductsAsAdminPaginator(SearchProductsAsAdminRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminPublisher searchProductsAsAdminPaginator(
            SearchProductsAsAdminRequest searchProductsAsAdminRequest) {
        return new SearchProductsAsAdminPublisher(this, searchProductsAsAdminRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link SearchProductsAsAdminRequest#builder()}
     * </p>
     *
     * @param searchProductsAsAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminPublisher searchProductsAsAdminPaginator(
            Consumer<SearchProductsAsAdminRequest.Builder> searchProductsAsAdminRequest) {
        return searchProductsAsAdminPaginator(SearchProductsAsAdminRequest.builder().applyMutation(searchProductsAsAdminRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsPublisher searchProductsPaginator() {
        return searchProductsPaginator(SearchProductsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsPublisher searchProductsPaginator(SearchProductsRequest searchProductsRequest) {
        return new SearchProductsPublisher(this, searchProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProductsRequest#builder()}
     * </p>
     *
     * @param searchProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsPublisher searchProductsPaginator(Consumer<SearchProductsRequest.Builder> searchProductsRequest) {
        return searchProductsPaginator(SearchProductsRequest.builder().applyMutation(searchProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A Java Future containing the result of the SearchProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProvisionedProductsResponse> searchProvisionedProducts(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param searchProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SearchProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProvisionedProductsResponse> searchProvisionedProducts(
            Consumer<SearchProvisionedProductsRequest.Builder> searchProvisionedProductsRequest) {
        return searchProvisionedProducts(SearchProvisionedProductsRequest.builder()
                .applyMutation(searchProvisionedProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @return A Java Future containing the result of the SearchProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProvisionedProductsResponse> searchProvisionedProducts() {
        return searchProvisionedProducts(SearchProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsPublisher searchProvisionedProductsPaginator() {
        return searchProvisionedProductsPaginator(SearchProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsPublisher searchProvisionedProductsPaginator(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) {
        return new SearchProvisionedProductsPublisher(this, searchProvisionedProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param searchProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsPublisher searchProvisionedProductsPaginator(
            Consumer<SearchProvisionedProductsRequest.Builder> searchProvisionedProductsRequest) {
        return searchProvisionedProductsPaginator(SearchProvisionedProductsRequest.builder()
                .applyMutation(searchProvisionedProductsRequest).build());
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param terminateProvisionedProductRequest
     * @return A Java Future containing the result of the TerminateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.TerminateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateProvisionedProductResponse> terminateProvisionedProduct(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateProvisionedProductRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateProvisionedProductRequest#builder()}
     * </p>
     *
     * @param terminateProvisionedProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the TerminateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.TerminateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateProvisionedProductResponse> terminateProvisionedProduct(
            Consumer<TerminateProvisionedProductRequest.Builder> terminateProvisionedProductRequest) {
        return terminateProvisionedProduct(TerminateProvisionedProductRequest.builder()
                .applyMutation(terminateProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     *
     * @param updateConstraintRequest
     * @return A Java Future containing the result of the UpdateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConstraintResponse> updateConstraint(UpdateConstraintRequest updateConstraintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConstraintRequest#builder()}
     * </p>
     *
     * @param updateConstraintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConstraintResponse> updateConstraint(
            Consumer<UpdateConstraintRequest.Builder> updateConstraintRequest) {
        return updateConstraint(UpdateConstraintRequest.builder().applyMutation(updateConstraintRequest).build());
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     *
     * @param updatePortfolioRequest
     * @return A Java Future containing the result of the UpdatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePortfolioResponse> updatePortfolio(UpdatePortfolioRequest updatePortfolioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePortfolioRequest#builder()}
     * </p>
     *
     * @param updatePortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePortfolioResponse> updatePortfolio(
            Consumer<UpdatePortfolioRequest.Builder> updatePortfolioRequest) {
        return updatePortfolio(UpdatePortfolioRequest.builder().applyMutation(updatePortfolioRequest).build());
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable <code>TagOptions</code> sharing
     * or Principal sharing for an existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code>CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be completed.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param updatePortfolioShareRequest
     * @return A Java Future containing the result of the UpdatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePortfolioShareResponse> updatePortfolioShare(
            UpdatePortfolioShareRequest updatePortfolioShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable <code>TagOptions</code> sharing
     * or Principal sharing for an existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code>CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be completed.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePortfolioShareRequest#builder()}
     * </p>
     *
     * @param updatePortfolioShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePortfolioShareResponse> updatePortfolioShare(
            Consumer<UpdatePortfolioShareRequest.Builder> updatePortfolioShareRequest) {
        return updatePortfolioShare(UpdatePortfolioShareRequest.builder().applyMutation(updatePortfolioShareRequest).build());
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     *
     * @param updateProductRequest
     * @return A Java Future containing the result of the UpdateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProductResponse> updateProduct(UpdateProductRequest updateProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProductRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProductRequest#builder()}
     * </p>
     *
     * @param updateProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProductResponse> updateProduct(Consumer<UpdateProductRequest.Builder> updateProductRequest) {
        return updateProduct(UpdateProductRequest.builder().applyMutation(updateProductRequest).build());
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param updateProvisionedProductRequest
     * @return A Java Future containing the result of the UpdateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedProductResponse> updateProvisionedProduct(
            UpdateProvisionedProductRequest updateProvisionedProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProvisionedProductRequest#builder()}
     * </p>
     *
     * @param updateProvisionedProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedProductResponse> updateProvisionedProduct(
            Consumer<UpdateProvisionedProductRequest.Builder> updateProvisionedProductRequest) {
        return updateProvisionedProduct(UpdateProvisionedProductRequest.builder().applyMutation(updateProvisionedProductRequest)
                .build());
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     * @return A Java Future containing the result of the UpdateProvisionedProductProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedProductPropertiesResponse> updateProvisionedProductProperties(
            UpdateProvisionedProductPropertiesRequest updateProvisionedProductPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisionedProductPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProvisionedProductPropertiesRequest#builder()}
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateProvisionedProductProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedProductPropertiesResponse> updateProvisionedProductProperties(
            Consumer<UpdateProvisionedProductPropertiesRequest.Builder> updateProvisionedProductPropertiesRequest) {
        return updateProvisionedProductProperties(UpdateProvisionedProductPropertiesRequest.builder()
                .applyMutation(updateProvisionedProductPropertiesRequest).build());
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     * @return A Java Future containing the result of the UpdateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisioningArtifactResponse> updateProvisioningArtifact(
            UpdateProvisioningArtifactRequest updateProvisioningArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisioningArtifactResponse> updateProvisioningArtifact(
            Consumer<UpdateProvisioningArtifactRequest.Builder> updateProvisioningArtifactRequest) {
        return updateProvisioningArtifact(UpdateProvisioningArtifactRequest.builder()
                .applyMutation(updateProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     *
     * @param updateServiceActionRequest
     * @return A Java Future containing the result of the UpdateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceActionResponse> updateServiceAction(
            UpdateServiceActionRequest updateServiceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceActionRequest#builder()}
     * </p>
     *
     * @param updateServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceActionResponse> updateServiceAction(
            Consumer<UpdateServiceActionRequest.Builder> updateServiceActionRequest) {
        return updateServiceAction(UpdateServiceActionRequest.builder().applyMutation(updateServiceActionRequest).build());
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     *
     * @param updateTagOptionRequest
     * @return A Java Future containing the result of the UpdateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagOptionResponse> updateTagOption(UpdateTagOptionRequest updateTagOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTagOptionRequest#builder()}
     * </p>
     *
     * @param updateTagOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Use the Amazon Web Services Management Console
     *         to perform the migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagOptionResponse> updateTagOption(
            Consumer<UpdateTagOptionRequest.Builder> updateTagOptionRequest) {
        return updateTagOption(UpdateTagOptionRequest.builder().applyMutation(updateTagOptionRequest).build());
    }

    @Override
    default ServiceCatalogServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ServiceCatalogAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceCatalogAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceCatalogAsyncClient}.
     */
    static ServiceCatalogAsyncClientBuilder builder() {
        return new DefaultServiceCatalogAsyncClientBuilder();
    }
}
