/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;

public class ListAcceptedPortfolioSharesPublisher
implements SdkPublisher<ListAcceptedPortfolioSharesResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListAcceptedPortfolioSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAcceptedPortfolioSharesPublisher(ServiceCatalogAsyncClient client, ListAcceptedPortfolioSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAcceptedPortfolioSharesPublisher(ServiceCatalogAsyncClient client, ListAcceptedPortfolioSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAcceptedPortfolioSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAcceptedPortfolioSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAcceptedPortfolioSharesResponseFetcher
    implements AsyncPageFetcher<ListAcceptedPortfolioSharesResponse> {
        private ListAcceptedPortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListAcceptedPortfolioSharesResponse> nextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return ListAcceptedPortfolioSharesPublisher.this.client.listAcceptedPortfolioShares(ListAcceptedPortfolioSharesPublisher.this.firstRequest);
            }
            return ListAcceptedPortfolioSharesPublisher.this.client.listAcceptedPortfolioShares((ListAcceptedPortfolioSharesRequest)((Object)ListAcceptedPortfolioSharesPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

