/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ProductViewAggregationsCopier {
    static Map<String, List<ProductViewAggregationValue>> copy(
            Map<String, ? extends Collection<? extends ProductViewAggregationValue>> productViewAggregationsParam) {
        Map<String, List<ProductViewAggregationValue>> map;
        if (productViewAggregationsParam == null || productViewAggregationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductViewAggregationValue>> modifiableMap = new LinkedHashMap<>(
                    productViewAggregationsParam.size());
            productViewAggregationsParam.forEach((key, value) -> {
                List<ProductViewAggregationValue> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductViewAggregationValue> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<ProductViewAggregationValue>> copyFromBuilder(
            Map<String, ? extends Collection<? extends ProductViewAggregationValue.Builder>> productViewAggregationsParam) {
        Map<String, List<ProductViewAggregationValue>> map;
        if (productViewAggregationsParam == null || productViewAggregationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductViewAggregationValue>> modifiableMap = new LinkedHashMap<>(
                    productViewAggregationsParam.size());
            productViewAggregationsParam.forEach((key, value) -> {
                List<ProductViewAggregationValue> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductViewAggregationValue> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        ProductViewAggregationValue member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<ProductViewAggregationValue.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends ProductViewAggregationValue>> productViewAggregationsParam) {
        Map<String, List<ProductViewAggregationValue.Builder>> map;
        if (productViewAggregationsParam == null || productViewAggregationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductViewAggregationValue.Builder>> modifiableMap = new LinkedHashMap<>(
                    productViewAggregationsParam.size());
            productViewAggregationsParam.forEach((key, value) -> {
                List<ProductViewAggregationValue.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductViewAggregationValue.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        ProductViewAggregationValue.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
