/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class SourceProvisioningArtifactPropertiesCopier {
    static List<Map<String, String>> copy(Collection<? extends Map<String, String>> sourceProvisioningArtifactPropertiesParam) {
        List<Map<String, String>> list;
        if (sourceProvisioningArtifactPropertiesParam == null
                || sourceProvisioningArtifactPropertiesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, String>> modifiableList = new ArrayList<>(sourceProvisioningArtifactPropertiesParam.size());
            sourceProvisioningArtifactPropertiesParam.forEach(entry -> {
                Map<String, String> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        modifiableMap.put(key, value);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, String>> copyEnumToString(
            Collection<? extends Map<ProvisioningArtifactPropertyName, String>> sourceProvisioningArtifactPropertiesParam) {
        List<Map<String, String>> list;
        if (sourceProvisioningArtifactPropertiesParam == null
                || sourceProvisioningArtifactPropertiesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, String>> modifiableList = new ArrayList<>(sourceProvisioningArtifactPropertiesParam.size());
            sourceProvisioningArtifactPropertiesParam.forEach(entry -> {
                Map<String, String> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        String result = key.toString();
                        modifiableMap.put(result, value);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<ProvisioningArtifactPropertyName, String>> copyStringToEnum(
            Collection<? extends Map<String, String>> sourceProvisioningArtifactPropertiesParam) {
        List<Map<ProvisioningArtifactPropertyName, String>> list;
        if (sourceProvisioningArtifactPropertiesParam == null
                || sourceProvisioningArtifactPropertiesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<ProvisioningArtifactPropertyName, String>> modifiableList = new ArrayList<>(
                    sourceProvisioningArtifactPropertiesParam.size());
            sourceProvisioningArtifactPropertiesParam.forEach(entry -> {
                Map<ProvisioningArtifactPropertyName, String> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<ProvisioningArtifactPropertyName, String> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        ProvisioningArtifactPropertyName result = ProvisioningArtifactPropertyName.fromValue(key);
                        if (result != ProvisioningArtifactPropertyName.UNKNOWN_TO_SDK_VERSION) {
                            modifiableMap.put(result, value);
                        }
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
