/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;

public class ListBudgetsForResourceIterable
implements SdkIterable<ListBudgetsForResourceResponse> {
    private final ServiceCatalogClient client;
    private final ListBudgetsForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBudgetsForResourceIterable(ServiceCatalogClient client, ListBudgetsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBudgetsForResourceResponseFetcher();
    }

    public Iterator<ListBudgetsForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBudgetsForResourceResponseFetcher
    implements SyncPageFetcher<ListBudgetsForResourceResponse> {
        private ListBudgetsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListBudgetsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListBudgetsForResourceResponse nextPage(ListBudgetsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListBudgetsForResourceIterable.this.client.listBudgetsForResource(ListBudgetsForResourceIterable.this.firstRequest);
            }
            return ListBudgetsForResourceIterable.this.client.listBudgetsForResource((ListBudgetsForResourceRequest)((Object)ListBudgetsForResourceIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

