/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductType;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SourceConnection;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, CreateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(CreateProductRequest.getter(CreateProductRequest::acceptLanguage)).setter(CreateProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateProductRequest.getter(CreateProductRequest::name)).setter(CreateProductRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(CreateProductRequest.getter(CreateProductRequest::owner)).setter(CreateProductRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateProductRequest.getter(CreateProductRequest::description)).setter(CreateProductRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Distributor").getter(CreateProductRequest.getter(CreateProductRequest::distributor)).setter(CreateProductRequest.setter(Builder::distributor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()}).build();
    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportDescription").getter(CreateProductRequest.getter(CreateProductRequest::supportDescription)).setter(CreateProductRequest.setter(Builder::supportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(CreateProductRequest.getter(CreateProductRequest::supportEmail)).setter(CreateProductRequest.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportUrl").getter(CreateProductRequest.getter(CreateProductRequest::supportUrl)).setter(CreateProductRequest.setter(Builder::supportUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(CreateProductRequest.getter(CreateProductRequest::productTypeAsString)).setter(CreateProductRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProductRequest.getter(CreateProductRequest::tags)).setter(CreateProductRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisioningArtifactProperties> PROVISIONING_ARTIFACT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningArtifactParameters").getter(CreateProductRequest.getter(CreateProductRequest::provisioningArtifactParameters)).setter(CreateProductRequest.setter(Builder::provisioningArtifactParameters)).constructor(ProvisioningArtifactProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactParameters").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateProductRequest.getter(CreateProductRequest::idempotencyToken)).setter(CreateProductRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<SourceConnection> SOURCE_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConnection").getter(CreateProductRequest.getter(CreateProductRequest::sourceConnection)).setter(CreateProductRequest.setter(Builder::sourceConnection)).constructor(SourceConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_URL_FIELD, PRODUCT_TYPE_FIELD, TAGS_FIELD, PROVISIONING_ARTIFACT_PARAMETERS_FIELD, IDEMPOTENCY_TOKEN_FIELD, SOURCE_CONNECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Distributor", DISTRIBUTOR_FIELD);
            this.put("SupportDescription", SUPPORT_DESCRIPTION_FIELD);
            this.put("SupportEmail", SUPPORT_EMAIL_FIELD);
            this.put("SupportUrl", SUPPORT_URL_FIELD);
            this.put("ProductType", PRODUCT_TYPE_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ProvisioningArtifactParameters", PROVISIONING_ARTIFACT_PARAMETERS_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
            this.put("SourceConnection", SOURCE_CONNECTION_FIELD);
        }
    });
    private final String acceptLanguage;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final String productType;
    private final List<Tag> tags;
    private final ProvisioningArtifactProperties provisioningArtifactParameters;
    private final String idempotencyToken;
    private final SourceConnection sourceConnection;

    private CreateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.productType = builder.productType;
        this.tags = builder.tags;
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.idempotencyToken = builder.idempotencyToken;
        this.sourceConnection = builder.sourceConnection;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final String description() {
        return this.description;
    }

    public final String distributor() {
        return this.distributor;
    }

    public final String supportDescription() {
        return this.supportDescription;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportUrl() {
        return this.supportUrl;
    }

    public final ProductType productType() {
        return ProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ProvisioningArtifactProperties provisioningArtifactParameters() {
        return this.provisioningArtifactParameters;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final SourceConnection sourceConnection() {
        return this.sourceConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductRequest)) {
            return false;
        }
        CreateProductRequest other = (CreateProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.distributor(), other.distributor()) && Objects.equals(this.supportDescription(), other.supportDescription()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportUrl(), other.supportUrl()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.provisioningArtifactParameters(), other.provisioningArtifactParameters()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.sourceConnection(), other.sourceConnection());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("Description", (Object)this.description()).add("Distributor", (Object)this.distributor()).add("SupportDescription", (Object)this.supportDescription()).add("SupportEmail", (Object)this.supportEmail()).add("SupportUrl", (Object)this.supportUrl()).add("ProductType", (Object)this.productTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ProvisioningArtifactParameters", (Object)this.provisioningArtifactParameters()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("SourceConnection", (Object)this.sourceConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Distributor": {
                return Optional.ofNullable(clazz.cast(this.distributor()));
            }
            case "SupportDescription": {
                return Optional.ofNullable(clazz.cast(this.supportDescription()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportUrl": {
                return Optional.ofNullable(clazz.cast(this.supportUrl()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ProvisioningArtifactParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactParameters()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "SourceConnection": {
                return Optional.ofNullable(clazz.cast(this.sourceConnection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateProductRequest, T> g) {
        return obj -> g.apply((CreateProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private String productType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ProvisioningArtifactProperties provisioningArtifactParameters;
        private String idempotencyToken;
        private SourceConnection sourceConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.name(model.name);
            this.owner(model.owner);
            this.description(model.description);
            this.distributor(model.distributor);
            this.supportDescription(model.supportDescription);
            this.supportEmail(model.supportEmail);
            this.supportUrl(model.supportUrl);
            this.productType(model.productType);
            this.tags(model.tags);
            this.provisioningArtifactParameters(model.provisioningArtifactParameters);
            this.idempotencyToken(model.idempotencyToken);
            this.sourceConnection(model.sourceConnection);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(ProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = AddTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = AddTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningArtifactProperties.Builder getProvisioningArtifactParameters() {
            return this.provisioningArtifactParameters != null ? this.provisioningArtifactParameters.toBuilder() : null;
        }

        public final void setProvisioningArtifactParameters(ProvisioningArtifactProperties.BuilderImpl provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters != null ? provisioningArtifactParameters.build() : null;
        }

        @Override
        public final Builder provisioningArtifactParameters(ProvisioningArtifactProperties provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final SourceConnection.Builder getSourceConnection() {
            return this.sourceConnection != null ? this.sourceConnection.toBuilder() : null;
        }

        public final void setSourceConnection(SourceConnection.BuilderImpl sourceConnection) {
            this.sourceConnection = sourceConnection != null ? sourceConnection.build() : null;
        }

        @Override
        public final Builder sourceConnection(SourceConnection sourceConnection) {
            this.sourceConnection = sourceConnection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProductRequest build() {
            return new CreateProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder productType(String var1);

        public Builder productType(ProductType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder provisioningArtifactParameters(ProvisioningArtifactProperties var1);

        default public Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactProperties.Builder> provisioningArtifactParameters) {
            return this.provisioningArtifactParameters((ProvisioningArtifactProperties)((ProvisioningArtifactProperties.Builder)ProvisioningArtifactProperties.builder().applyMutation(provisioningArtifactParameters)).build());
        }

        public Builder idempotencyToken(String var1);

        public Builder sourceConnection(SourceConnection var1);

        default public Builder sourceConnection(Consumer<SourceConnection.Builder> sourceConnection) {
            return this.sourceConnection((SourceConnection)((SourceConnection.Builder)SourceConnection.builder().applyMutation(sourceConnection)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

