/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductViewResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProductViewResponse> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductViewSummary").getter(DescribeProductViewResponse.getter(DescribeProductViewResponse::productViewSummary)).setter(DescribeProductViewResponse.setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build()}).build();
    private static final SdkField<List<ProvisioningArtifact>> PROVISIONING_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningArtifacts").getter(DescribeProductViewResponse.getter(DescribeProductViewResponse::provisioningArtifacts)).setter(DescribeProductViewResponse.setter(Builder::provisioningArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD, PROVISIONING_ARTIFACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProductViewSummary", PRODUCT_VIEW_SUMMARY_FIELD);
            this.put("ProvisioningArtifacts", PROVISIONING_ARTIFACTS_FIELD);
        }
    });
    private final ProductViewSummary productViewSummary;
    private final List<ProvisioningArtifact> provisioningArtifacts;

    private DescribeProductViewResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
    }

    public final ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public final boolean hasProvisioningArtifacts() {
        return this.provisioningArtifacts != null && !(this.provisioningArtifacts instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningArtifact> provisioningArtifacts() {
        return this.provisioningArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningArtifacts() ? this.provisioningArtifacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductViewResponse)) {
            return false;
        }
        DescribeProductViewResponse other = (DescribeProductViewResponse)((Object)obj);
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && this.hasProvisioningArtifacts() == other.hasProvisioningArtifacts() && Objects.equals(this.provisioningArtifacts(), other.provisioningArtifacts());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProductViewResponse").add("ProductViewSummary", (Object)this.productViewSummary()).add("ProvisioningArtifacts", this.hasProvisioningArtifacts() ? this.provisioningArtifacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "ProvisioningArtifacts": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductViewResponse, T> g) {
        return obj -> g.apply((DescribeProductViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private List<ProvisioningArtifact> provisioningArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductViewResponse model) {
            super(model);
            this.productViewSummary(model.productViewSummary);
            this.provisioningArtifacts(model.provisioningArtifacts);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final List<ProvisioningArtifact.Builder> getProvisioningArtifacts() {
            List<ProvisioningArtifact.Builder> result = ProvisioningArtifactsCopier.copyToBuilder(this.provisioningArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact.BuilderImpl> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copyFromBuilder(provisioningArtifacts);
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact ... provisioningArtifacts) {
            this.provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... provisioningArtifacts) {
            this.provisioningArtifacts(Stream.of(provisioningArtifacts).map(c -> (ProvisioningArtifact)((ProvisioningArtifact.Builder)ProvisioningArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeProductViewResponse build() {
            return new DescribeProductViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductViewResponse> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder provisioningArtifacts(Collection<ProvisioningArtifact> var1);

        public Builder provisioningArtifacts(ProvisioningArtifact ... var1);

        public Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... var1);
    }
}

